package com.edu24ol.newclass.discover.util

import android.content.Context
import android.content.Intent
import com.edu24.data.server.discover.entity.ArticleInfo
import com.edu24.data.server.discover.entity.VideoScene
import com.edu24.data.server.mall.bean.StrategyBean
import com.sankuai.waimai.router.common.DefaultUriRequest


object DiscoverRouterUtils {
    @JvmStatic
    @JvmOverloads
    fun startDiscoverTopicDetailActivity(
        context: Context?,
        topicId: Long, belongPage: String?,
        belongSeat: String?, seatNum: String?, strategyBean: StrategyBean?
    ) {
        DefaultUriRequest(context!!, "/topicDetail")
            .putExtra("intent_topic_id", topicId)
            .putExtra("belongPage", belongPage)
            .putExtra("belongSeat", belongSeat)
            .putExtra("seatNum", seatNum)
            .putExtra("strategyBean", strategyBean)
            .start()
    }
    @JvmStatic
    @JvmOverloads
    fun startForwardDynamic(context: Context, articleInfo: ArticleInfo?) {
        DefaultUriRequest(context, "/forwardDynamic")
            .putExtra("article_info", articleInfo)
            .start()
    }

    @JvmStatic
    @JvmOverloads
    fun startArticleDetailAct(
        context: Context?, articleId: Long, belongPage: String?,
        belongSeat: String?, seatNum: String?, strategyBean: StrategyBean?
    ) {
        DefaultUriRequest(context!!, "/articleDetailAct")
            .putExtra("articleId", articleId)
            .putExtra("belongPage", belongPage)
            .putExtra("belongSeat", belongSeat)
            .putExtra("seatNum", seatNum)
            .putExtra("strategyBean", strategyBean)
            .setIntentFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP)
            .start()
    }


    @JvmStatic
    @JvmOverloads
    fun startVideoArticleDetail(
        context: Context,
        articleId: Long,
        scrollToCommentArea: Boolean = false,
        secondCategoryId: Int = 0,
        videoStartPlayPosition: Long = 0,
        scene: Int = VideoScene.SCENE_DISCOVER,
        pagingOffset: Int = -1,
        belongPage: String? = null,
        belongSeat: String? = null,
        seatNum: String? = null,
        strategyBean: StrategyBean? = null
    ) {
        DefaultUriRequest(context, "/articleDetailAct")
            .apply {
                putExtra("articleId", articleId)
                putExtra("belongPage", belongPage)
                putExtra("belongSeat", belongSeat)
                putExtra("seatNum", seatNum)
                putExtra("strategyBean", strategyBean)
                putExtra("scrollToCommentArea", scrollToCommentArea)
                putExtra("pagingOffset", pagingOffset)
                putExtra("scene", scene)
                putExtra("secondCategoryId", secondCategoryId)
                putExtra("videoStartPlayPosition", videoStartPlayPosition)
                setIntentFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            }
            .start()
    }

}