package com.edu24ol.newclass.discover.text;

import android.graphics.Color;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;

import com.hqwx.android.platform.stat.Referrer;
import com.hqwx.android.service.AppRouter;

import androidx.annotation.NonNull;

public class TopicClickableSpan extends ClickableSpan {

    private long topicId;

    public TopicClickableSpan(long topicId) {
        this.topicId = topicId;
    }

    @Override
    public void onClick(@NonNull View widget) {
        AppRouter.startDiscoverTopicDetailActivity(widget.getContext(), topicId,
                Referrer.getInstance().getCurrentFragmentPageName(), "内容列表");
    }

    @Override
    public void updateDrawState(@NonNull TextPaint ds) {
        super.updateDrawState(ds);
        ds.setColor(Color.parseColor("#366DE8"));
        ds.setUnderlineText(false);
    }
}
