package com.edu24ol.newclass.discover.text;

import android.graphics.Color;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;

import com.hqwx.android.service.AppRouter;

import androidx.annotation.NonNull;

public class AtUserClickableSpan extends ClickableSpan {

    private long userId;

    public AtUserClickableSpan(long userId) {
        this.userId = userId;
    }

    @Override
    public void onClick(@NonNull View widget) {
        AppRouter.startDiscoverAuthorDetailActivity(widget.getContext(), userId);
    }

    @Override
    public void updateDrawState(@NonNull TextPaint ds) {
        super.updateDrawState(ds);
        ds.setColor(Color.parseColor("#366DE8"));
        ds.setUnderlineText(false);
    }
}
