package com.edu24ol.newclass.discover.stat;

import android.content.Context;
import android.text.TextUtils;

import com.hqwx.android.platform.stat.BaseStat;
import com.hqwx.android.platform.stat.StatAgent;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class DiscoverStat extends BaseStat{

    /**
     * @param belongPage      所属页面
     * @param belongSeat      所属模块
     * @param contentType     内容类型
     * @param contentId       内容ID
     * @param contentName     内容名称
     * @param contentLabel    内容标签
     * @param examinationName 考试名称
     * @param accountPetName  作者账号昵称
     */
    public static void onAppContentDetail(Context context, String belongPage, String belongSeat,
                                          String contentType,
                                          long contentId, String contentName, String accountPetName,
                                          String contentLabel, String examinationID, String examinationName,
                                          String seatNum, int strategyId,
                                          String strategyName,
                                          String strategyBelongExam, int strategySortNum) {
        Map<String, Object> params = new HashMap<>(5);
        params.put("belongPage", belongPage);
        params.put("belongSeat", belongSeat);
        params.put("contentType", contentType);
        params.put("contentID", String.valueOf(contentId));
        params.put("contentName", contentName);
        params.put("accountPetName", accountPetName);
        params.put("contentLabel", contentLabel);
        params.put("examinationID", examinationID);
        params.put("examinationName", examinationName);
        if (!TextUtils.isEmpty(seatNum)) {
            params.put("seatNum", seatNum);
        }
        params.put("strategId", strategyId);
        params.put("strategName", strategyName);
        params.put("strategBelongExam", strategyBelongExam);
        params.put("strategSortNum", strategySortNum);
        BaseStat.onSensorsEvent(context, "AppContentDetail", params);
    }

    /**
     * 点赞
     * <p>
     *
     * @param belongPage      所属页面,发现、内容详情页
     * @param belongSeat      所属模块,推荐列表、关注列表
     * @param isEffective     是否有效,是、否；分别对应点赞和取消点赞
     * @param contentId       内容ID
     * @param contentName     内容名称
     * @param contentLabel    内容标签
     * @param accountPetName  作者账号昵称
     * @param examinationName 考试名称,所属考试名称
     */
    public static void onAppContentLike(Context context, String belongPage, String belongSeat,
                                        boolean isEffective,
                                        String contentId, String contentName, String accountPetName,
                                        String contentLabel, String examinationName) {
        Map<String, Object> params = new HashMap<>(5);
        params.put("belongPage", belongPage);
        params.put("belongSeat", belongSeat);
        params.put("isEffective", isEffective);
        params.put("contentID", String.valueOf(contentId));
        params.put("contentName", contentName);
        params.put("accountPetName", accountPetName);
        params.put("contentLabel", contentLabel);
        params.put("examinationName", examinationName);
        BaseStat.onSensorsEvent(context, "AppContentLike", params);
    }


    /**
     * 评论
     *
     * @param contentId       内容ID
     * @param contentName     内容名称
     * @param accountPetName  作者账号昵称
     * @param contentLabel    内容标签
     * @param examinationName 考试名称
     * @param commentCategory 评论类别  一级评论、二级评论
     */
    public static void onAppContentComment(Context context, long contentId, String contentName,
                                           String accountPetName, String contentLabel,
                                           String examinationName, String commentCategory) {
        Map<String, Object> params = new HashMap<>(6);
        params.put("contentID", String.valueOf(contentId));
        params.put("contentName", contentName);
        params.put("accountPetName", accountPetName);
        params.put("contentLabel", contentLabel);
        params.put("examinationName", examinationName);
        params.put("commentCategory", commentCategory);
        BaseStat.onSensorsEvent(context, "AppContentComment", params);
    }

    public static void onAppTopicDetail(String topicName, String examinationName,
                                        String topicCategory, String belongPage, String belongSeat,
                                        String seatNum, int strategyId,
                                        String strategyName,
                                        String strategyBelongExam, int strategySortNum
    ) {
        Map<String, Object> params = new HashMap<>(5);
        params.put("topicName", topicName);
        params.put("examinationName", examinationName);
        params.put("topicCategory", String.valueOf(topicCategory));
        params.put("belongPage", belongPage);
        params.put("belongSeat", belongSeat);
        if (!TextUtils.isEmpty(seatNum)) {
            params.put("seatNum", seatNum);
        }
        params.put("strategId", strategyId);
        params.put("strategName", strategyName);
        params.put("strategBelongExam", strategyBelongExam);
        params.put("strategSortNum", strategySortNum);
        BaseStat.onSensorsEvent(null, "AppTopicDetail", params);
    }

    public static void onAppFollow(String belongPage
        , String follow, long accountId, String accountName) {


        JSONObject properties = new JSONObject();
        try {
            properties.put("follow", follow);
            properties.put("accountName", accountName);
            properties.put("accountId", String.valueOf(accountId));
            properties.put("belongPage", belongPage);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        SensorsDataAPI.sharedInstance().track("AppFollow", properties);
    }

    public static void onVideoEffect(long videoId, String videoTitle, long videoDuration, long playbackProgressDuration,
                                     String examinationName, String accountIssue, long playbackDuration, boolean isNext) {
        JSONObject properties = new JSONObject();
        try {
            properties.put("videoId", videoId);
            properties.put("videoTitle", videoTitle);
            properties.put("videoDuration", videoDuration);
            properties.put("playbackProgressDuration", playbackProgressDuration);
            properties.put("examinationName", examinationName);
            properties.put("accountIssue", accountIssue);
            properties.put("playbackDuration", playbackDuration);
            properties.put("isNext", isNext);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        SensorsDataAPI.sharedInstance().track("videoEffect", properties);
    }

    public static void onAppContentClick(String belongPage,
                                         String clickElement) {
        JSONObject properties = new JSONObject();
        try {
            properties.put("belongPage", belongPage);
            properties.put("clickElement", clickElement);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        SensorsDataAPI.sharedInstance().track("appContentClick", properties);
    }
    /**
     * app停留时长
     */
    public static void onAppStay(Context context, String belongPage,String belongSeat, long eventDuration, String contentType,
                                 String contentName, String examinationName) {
        Map<String, Object> params = new HashMap<>();
        params.put("belongPage", belongPage);
        params.put("belongSeat", belongSeat);
        params.put("eventDuration", eventDuration);
        params.put("contentType", contentType);
        params.put("contentName", contentName);
        params.put("examinationName", examinationName);
        onSensorsEvent(context, "appStay", params);
    }
}
