package com.edu24ol.newclass.discover.report

import com.edu24.data.server.impl.IDiscoverjApi
import com.hqwx.android.platform.exception.HqException
import com.hqwx.android.platform.mvp.BaseMvpPresenter
import com.hqwx.android.platform.server.BaseRes
import rx.android.schedulers.AndroidSchedulers
import rx.schedulers.Schedulers

class ReportPresenter<V : ReportActivityContract.IReportMvpView>(
    val api: IDiscoverjApi
) : BaseMvpPresenter<V>(),
    ReportActivityContract.IReportPresenter<V> {


    override fun submitReport(token: String, articleId: Long, content: String, tipsType: Int) {
        compositeSubscription.add(
            api.commitReport(token, articleId, content, tipsType).subscribeOn(Schedulers.io())
                .doOnSubscribe {
                    mvpView.isActive.let { mvpView.showLoading() }
                }
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(
                    { t: BaseRes? ->
                        if (mvpView.isActive) {
                            mvpView.hideLoading()
                            if (t!!.isSuccessful) {
                                mvpView.onSubmitSuccess()
                            } else {
                                mvpView.onSubmitFailure(HqException(t.message))
                            }
                        }
                    }, { t: Throwable? ->
                        mvpView.isActive.let {
                            mvpView.hideLoading()
                            t?.let { it1 -> mvpView.onSubmitFailure(it1) }
                        }
                    }
                ))
    }
}