package com.edu24ol.newclass.discover.presenter.published

import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean
import com.edu24.data.server.discover.response.AriticleAuthorArticleListResponse
import com.edu24.data.server.impl.IDiscoverjApi
import com.hqwx.android.platform.kt.toSubscribeWithoutLoading
import com.hqwx.android.platform.mvp.BaseMvpPresenter
import com.yy.android.educommon.log.YLog
import rx.Observable

class PublishedImpl<V : PublishedContract.View>(private val api: IDiscoverjApi) : BaseMvpPresenter<V>(),
    PublishedContract.Presenter<V> {
    override fun getPublishArticleDetail(
        passport: String?,
        authorId: Long,
        articleId: Long,
        homeDiscoverArticleItemBean: HomeDiscoverArticleItemBean?
    ) {
        api.getAuthorArticleList(passport, authorId, 0, 1)
            .onErrorResumeNext { Observable.just(AriticleAuthorArticleListResponse()) }
            .toSubscribeWithoutLoading(compositeSubscription, mvpView, {
                var articleInfo = it.data?.list?.get(0)
                if (articleInfo != null && articleInfo.id == articleId) {
                    YLog.info(this, "keepon getPublishArticleDetail 接口获取")
                    mvpView.onGetPublishedArticleDetailSuccess(articleInfo)
                } else {
                    if (homeDiscoverArticleItemBean != null) {
                        YLog.info(this, "keepon getPublishArticleDetail 自行组装 ")
                        mvpView.onGetPublishedArticleDetailSuccess(homeDiscoverArticleItemBean)
                    } else {
                        mvpView.onGetPublishedArticleDetailFailure(it.hqException)
                    }
                }
            }, {
                mvpView.onGetPublishedArticleDetailFailure(it)
            })
    }

}