package com.edu24ol.newclass.discover.presenter;

import com.hqwx.android.platform.BasePresenter;
import com.hqwx.android.platform.BaseView;

import rx.subscriptions.CompositeSubscription;

/**
 * Created by zhanghong on 2019/4/22.
 */

public interface IDiscoverArticlePresenter extends BasePresenter {

    void handleArticleLikeState(boolean isToLike, long articleId, int handlePosition);

    /**
     * 删除
     *
     * @param articleId
     */
    void deleteArticle(String token, long articleId);

    interface IDiscoverArticleView extends BaseView {

        CompositeSubscription getCompositeSubscription();

        void onHandlerArticleLikeStateSuccess(boolean isToLike, int handlePosition);

        void onDeleteArticleSuccess(long articleId);

        void onDeleteArticleFailure(Throwable throwable, long articleId);
    }
}
