package com.edu24ol.newclass.discover.presenter;

import com.edu24.data.DataApiFactory;
import com.edu24.data.server.discover.DiscoverDataApiFactory;
import com.edu24.data.server.response.BooleanRes;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.server.BaseRes;
import com.hqwx.android.service.ServiceFactory;
import com.yy.android.educommon.log.YLog;

import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

/**
 * Created by zhanghong on 2019/4/22.
 */

public class DiscoverArticlePresenter implements IDiscoverArticlePresenter {

    private IDiscoverArticleView mDiscoverArticleView;

    public DiscoverArticlePresenter(IDiscoverArticleView discoverArticleView) {
        mDiscoverArticleView = discoverArticleView;
    }

    @Override
    public void handleArticleLikeState(final boolean isToLike, long articleId,
                                       final int handlePosition) {
        Observable<BaseRes> observable = null;
        if (isToLike) {
            observable = DiscoverDataApiFactory.getInstance().getDiscoverApi()
                    .likeArticle(ServiceFactory.getAccountService().getHqToken(), articleId);
        } else {
            observable = DiscoverDataApiFactory.getInstance().getDiscoverApi()
                    .unLikeArticle(ServiceFactory.getAccountService().getHqToken(), articleId);
        }
        mDiscoverArticleView.getCompositeSubscription().add(
                observable
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new Subscriber<BaseRes>() {
                            @Override
                            public void onCompleted() {

                            }

                            @Override
                            public void onError(Throwable e) {
                                YLog.error(this, e);
                            }

                            @Override
                            public void onNext(BaseRes baseRes) {
                                if (baseRes.isSuccessful()) {
                                    mDiscoverArticleView.onHandlerArticleLikeStateSuccess(isToLike,
                                            handlePosition);
                                }
                            }
                        })
        );
    }

    @Override
    public void deleteArticle(String token, long articleId) {
        if (mDiscoverArticleView != null &&
                mDiscoverArticleView.getCompositeSubscription() != null) {
            mDiscoverArticleView.getCompositeSubscription().add(
                    DataApiFactory.getInstance().getDiscoverjApi().deleteContent(token, articleId)
                            .subscribeOn(Schedulers.io())
                            .observeOn(AndroidSchedulers.mainThread())
                            .subscribe(new Subscriber<BooleanRes>() {
                                @Override
                                public void onCompleted() {

                                }

                                @Override
                                public void onError(Throwable e) {
                                    if (mDiscoverArticleView != null) {
                                        mDiscoverArticleView.onDeleteArticleFailure(e, articleId);
                                    }
                                }

                                @Override
                                public void onNext(BooleanRes baseRes) {
                                    if (mDiscoverArticleView != null) {
                                        if (baseRes.isSuccessful()) {
                                            mDiscoverArticleView.onDeleteArticleSuccess(articleId);
                                        } else {
                                            mDiscoverArticleView.onDeleteArticleFailure(
                                                    new HqException(baseRes.getMessage()),
                                                    articleId);
                                        }
                                    }

                                }
                            })
            );
        }

    }

    @Override
    public void start() {

    }

    @Override
    public void stop() {

    }
}
