package com.edu24ol.newclass.discover.presenter;

import com.edu24.data.server.discover.DiscoverDataApiFactory;
import com.edu24ol.newclass.discover.presenter.ui.IAuthorFollowUI;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.server.BaseRes;
import com.yy.android.educommon.log.YLog;

import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class AuthorFollowActionPresenter implements IAuthorFollowActionPresenter {

    private IAuthorFollowUI mUIController;

    public AuthorFollowActionPresenter(IAuthorFollowUI articleFollowUI) {
        mUIController = articleFollowUI;
    }

    @Override
    public void followAuthor(String token, final long authorId) {
        if (mUIController != null && mUIController.getCompositeSubscription() != null) {
            mUIController.getCompositeSubscription().add(
                    DiscoverDataApiFactory.getInstance().getDiscoverApi()
                            .followAuthor(token, authorId)
                            .subscribeOn(Schedulers.io())
                            .doOnSubscribe(new Action0() {
                                @Override
                                public void call() {
                                    mUIController.showLoadingDialog();
                                }
                            })
                            .subscribeOn(AndroidSchedulers.mainThread())
                            .observeOn(AndroidSchedulers.mainThread())
                            .subscribe(new Subscriber<BaseRes>() {
                                @Override
                                public void onCompleted() {
                                    mUIController.dismissLoadingDialog();
                                }

                                @Override
                                public void onError(Throwable e) {
                                    mUIController.dismissLoadingDialog();
                                    mUIController.onFollowAuthorFail(e);
                                    YLog.error("", e);
                                }

                                @Override
                                public void onNext(BaseRes response) {
                                    if (response != null && response.isSuccessful()) {
                                        mUIController.onFollowAuthorSuccess(authorId);
                                    } else {
                                        mUIController.onFollowAuthorFail(
                                                new HqException(response.getMessage()));
                                    }
                                }
                            })
            );
        }
    }

    @Override
    public void unFollowAuthor(String token, final long authorId) {
        if (mUIController != null && mUIController.getCompositeSubscription() != null) {
            mUIController.getCompositeSubscription().add(
                    DiscoverDataApiFactory.getInstance().getDiscoverApi()
                            .unFollowAuthor(token, authorId)
                            .subscribeOn(Schedulers.io())
                            .doOnSubscribe(new Action0() {
                                @Override
                                public void call() {
                                    mUIController.showLoadingDialog();
                                }
                            })
                            .subscribeOn(AndroidSchedulers.mainThread())
                            .observeOn(AndroidSchedulers.mainThread())
                            .subscribe(new Subscriber<BaseRes>() {
                                @Override
                                public void onCompleted() {
                                    mUIController.dismissLoadingDialog();
                                }

                                @Override
                                public void onError(Throwable e) {
                                    mUIController.dismissLoadingDialog();
                                    mUIController.onUnFollowAuthorFail(e);
                                    YLog.error("", e);
                                }

                                @Override
                                public void onNext(BaseRes response) {
                                    if (response != null && response.isSuccessful()) {
                                        mUIController.onUnFollowAuthorSuccess(authorId);
                                    } else {
                                        mUIController.onUnFollowAuthorFail(
                                                new HqException(response.getMessage()));
                                    }
                                }
                            })
            );
        }
    }

}
