package com.edu24ol.newclass.discover.presenter;

import com.edu24.data.DataApiFactory;
import com.edu24ol.newclass.discover.presenter.ui.IArticleStatMvpView;
import com.hqwx.android.platform.mvp.BaseMvpPresenter;
import com.hqwx.android.platform.server.BaseRes;
import com.yy.android.educommon.log.YLog;

import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class ArticleStatPresenter<V extends IArticleStatMvpView> extends BaseMvpPresenter<V>
        implements IArticleStatPresenter<V> {
    @Override
    public void statArticleShare(long articleId, String token) {
        getCompositeSubscription().add(
                DataApiFactory.getInstance().getDiscoverjApi()
                        .commitShareEvent(articleId, token)
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new Subscriber<BaseRes>() {
                            @Override
                            public void onCompleted() {

                            }

                            @Override
                            public void onError(Throwable e) {
                                YLog.error(this, e);

                            }

                            @Override
                            public void onNext(BaseRes res) {
                            }
                        })
        );
    }

    @Override
    public void statArticleExposure(Long[] articleIds, String token,int type) {
        getCompositeSubscription().add(
                DataApiFactory.getInstance().getDiscoverjApi()
                        .commitExposureEvent(token, articleIds, type)
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new Subscriber<BaseRes>() {
                            @Override
                            public void onCompleted() {

                            }

                            @Override
                            public void onError(Throwable e) {
                                YLog.error(this, e);

                            }

                            @Override
                            public void onNext(BaseRes res) {
                            }
                        })
        );
    }
}
