package com.edu24ol.newclass.discover.home.recommend;

import android.content.Context;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by zhanghong on 2019/4/22.
 */

public class HomeDiscoverRecommendListAdapter extends DiscoverBaseArticleListAdapter {

    public interface OnHomeDiscoverItemClickListener {

        void onLastRecordLearnClick();
    }

    public OnHomeDiscoverItemClickListener mOnHomeDiscoverItemClickListener;

    public void setOnHomeDiscoverItemClickListener(
            OnHomeDiscoverItemClickListener onHomeDiscoverItemClickListener) {
        mOnHomeDiscoverItemClickListener = onHomeDiscoverItemClickListener;
    }

    public HomeDiscoverRecommendListAdapter(Context context) {
        super(context);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        if (i == RECOMMEND_LAST_READ_TYPE) {
            return new DiscoverLastReadViewHolder(initItemLayoutInflater(viewGroup,
                    R.layout.discover_item_recommend_last_read_layout));
        }
        return super.onCreateViewHolder(viewGroup, i);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        if (viewHolder instanceof DiscoverLastReadViewHolder) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnHomeDiscoverItemClickListener != null) {
                        mOnHomeDiscoverItemClickListener.onLastRecordLearnClick();
                    }
                }
            });
        } else {
            super.onBindViewHolder(viewHolder, i);
        }
    }

    protected class DiscoverLastReadViewHolder extends RecyclerView.ViewHolder {

        private TextView mLastReadView;

        public DiscoverLastReadViewHolder(View itemView) {
            super(itemView);

            mLastReadView = itemView.findViewById(R.id.item_recommend_last_read_view);

            SpannableString spannableString =
                    new SpannableString(mContext.getString(R.string.discover_last_read_notice));
            ForegroundColorSpan foregroundColorSpan =
                    new ForegroundColorSpan(mContext.getResources().getColor(R.color.primary_blue));
            spannableString.setSpan(foregroundColorSpan, 7, 11, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
            mLastReadView.setText(spannableString);
        }

    }

    @Override
    public int getItemViewType(int position) {
        //需要根据当前adapter所在页面 区分是否有咨询中间的点击刷新，且只有在下拉刷新过程中存在中间item
        if (!mIsHaveLastRead) {
            return super.getItemViewType(position);
        } else {
            if (mRefreshDataCount == position) {
                return RECOMMEND_LAST_READ_TYPE;
            } else {
                return super.getItemViewType(position);
            }
        }
    }

    @Override
    public HomeDiscoverArticleItemBean getItem(int position) {
        if (mIsHaveLastRead && position > mRefreshDataCount) {
            return super.getItem(position - 1);
        } else {
            return super.getItem(position);
        }
    }

    @Override
    public int getItemCount() {
        if (mIsHaveLastRead) {
            return super.getItemCount() + 1;
        }
        return super.getItemCount();
    }

    @Override
    public boolean isShowAttention() {
        return true;
    }

    @Override
    public boolean isShowMoreButton() {
        return true;
    }

}
