package com.edu24ol.newclass.discover.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.edu24ol.newclass.discover.adapter.LoadMorelAdapter;
import com.edu24ol.newclass.discover.base.DiscoverBaseFragment;
import com.edu24ol.newclass.discover.consts.DiscoverIntentFlag;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.model.Visitable;
import com.hqwx.android.platform.mvp.BaseLoadMorePresenter;
import com.hqwx.android.platform.mvp.IGetPageDataMvpView;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.platform.widgets.pullrefresh.HqwxRefreshLayout;
import com.hqwx.android.platform.widgets.pullrefresh.listener.OnRefreshLoadMoreListener;
import com.yy.android.educommon.log.YLog;
import com.yy.android.educommon.utils.NetworkUtil;

import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/11/22.
 *
 * @see com.edu24ol.newclass.cspro.fragment.BasePageDataFragment
 * @deprecated
 */
//onGetListVisitableData 方法默认实现用到了反射，如果子类没有覆写该方法，需要把对应的Presenter类和Model类加入混淆文件
public abstract class BaseLoadMoreFragment<P extends BaseLoadMorePresenter, T, M extends Visitable>
    extends DiscoverBaseFragment implements IGetPageDataMvpView<T> {
    private static final String TAG = "BaseLoadMoreFragment";

    protected RecyclerView mRecyclerView;
    protected HqwxRefreshLayout mHqwxRefreshLayout;

    P mPresenter;
    protected LoadMorelAdapter mAdapter;

    protected long mUid;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.discover_common_fragment_base_load_more, null);
        getFragmentArguments(getArguments());

        initView(view);
        initEvent();
        refreshData(false);
        return view;
    }

    protected void getFragmentArguments(Bundle bundle) {
        if (bundle != null) {
            mUid = bundle.getLong(DiscoverIntentFlag.INTENT_UID);
        }
    }

    private void initView(View view) {
        mHqwxRefreshLayout = view.findViewById(R.id.refresh_layout);
        mRecyclerView = mHqwxRefreshLayout.getRecyclerView();
        mLoadingStatusView = view.findViewById(R.id.status_view);
        mLoadingStatusView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                refreshData(false);
            }
        });
        mHqwxRefreshLayout.setOnRefreshLoadMoreListener(mOnRefreshLoadMoreListener);
        mHqwxRefreshLayout.setEnableRefresh(false);
        mHqwxRefreshLayout.setEnableLoadMore(false);
        RecyclerView.ItemDecoration itemItemDecoration = getItemItemDecoration();
        if (itemItemDecoration != null) {
            mRecyclerView.addItemDecoration(getItemItemDecoration());
        }
        mAdapter = getAdapter();
        mRecyclerView.setAdapter(mAdapter);
        mPresenter = getDataPresenter();
        mPresenter.onAttach(this);
    }

    @NotNull
    protected LoadMorelAdapter getAdapter() {
        return new LoadMorelAdapter(getActivity());
    }

    protected void initEvent() {

    }

    protected void setRecyclerViewMarginTop(int marginTop) {
        if (mRecyclerView != null) {
            ViewGroup.MarginLayoutParams layoutParams =
                (ViewGroup.MarginLayoutParams) mRecyclerView.getLayoutParams();
            if (layoutParams == null) {
                layoutParams = new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.MATCH_PARENT);
            }
            layoutParams.topMargin = marginTop;
        }
    }

    protected RecyclerView.ItemDecoration getItemItemDecoration() {
        return null;
    }

    public Class getGenericModelClass(Class clazz) {
        Type type = clazz.getGenericSuperclass();
        //ParameterizedType,代表一个泛型类型
        if (type instanceof ParameterizedType) {
            //parameterizedType:com.zhang.fanshe.bean.Point<java.lang.Integer>
            ParameterizedType parameterizedType = (ParameterizedType) type;
            //返回表示此类型实际类型参数的 Type 对象的数组
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (Type parameterArgType : actualTypeArguments) {
                //parameterArgClass:class java.lang.Integer
                Class parameterArgClass = (Class) parameterArgType;
//                Log.d(TAG, "填充类型为：" + parameterArgClass.getName());
                if (Visitable.class.isAssignableFrom(parameterArgClass)) {
                    return parameterArgClass;
                }

            }
        }
        return null;
    }

    public Class getGenericTClass(Class clazz) {
        Type type = clazz.getGenericSuperclass();
        //ParameterizedType,代表一个泛型类型
        if (type instanceof ParameterizedType) {
            //parameterizedType:com.zhang.fanshe.bean.Point<java.lang.Integer>
            ParameterizedType parameterizedType = (ParameterizedType) type;
            //返回表示此类型实际类型参数的 Type 对象的数组
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (Type parameterArgType : actualTypeArguments) {
                //parameterArgClass:class java.lang.Integer
                Class parameterArgClass = (Class) parameterArgType;
                if (!Visitable.class.isAssignableFrom(parameterArgClass) &&
                    !BaseLoadMorePresenter.class.isAssignableFrom(parameterArgClass)) {
                    return parameterArgClass;
                }
//                Log.e(TAG, "填充类型为：" + parameterArgClass.getName());
            }
        }
        return null;
    }

    protected abstract P getDataPresenter();

    public void refreshData(boolean showLoadingDialog) {
        mPresenter.getRefreshList(showLoadingDialog);
    }

    private OnRefreshLoadMoreListener mOnRefreshLoadMoreListener = new OnRefreshLoadMoreListener() {
        @Override
        public void onLoadMore(HqwxRefreshLayout refreshLayout) {
            if (NetworkUtil.isNetworkAvailable(getActivity())) {
                mPresenter.getNextPageList(false);
            } else {
                ToastUtil.showMessage(getActivity(),
                    getString(R.string.network_not_available));
                refreshLayout.finishLoadMore();
            }
        }

        @Override
        public void onRefresh(HqwxRefreshLayout refreshLayout) {
            if (NetworkUtil.isNetworkAvailable(getActivity())) {
                refreshData(false);
            } else {
                ToastUtil.showMessage(getActivity(),
                    getString(R.string.network_not_available));
                refreshLayout.finishRefresh();
            }
        }
    };

    protected void setNoDataView() {
        mLoadingStatusView.showEmptyView("暂无内容");
    }

    protected void setErrorView(Throwable e) {
        mLoadingStatusView.showErrorViewByThrowable(e);
    }

    @Override
    public boolean isActive() {
        return isAdded();
    }

    @Override
    public void onRefreshListData(List<T> data, boolean isNoMore) {
        mLoadingStatusView.setVisibility(View.GONE);
        mHqwxRefreshLayout.setEnableRefresh(true);
        mHqwxRefreshLayout.finishRefresh();
        mHqwxRefreshLayout.setEnableLoadMore(true);
        mAdapter.setData(onGetListVisitableData(data));
        mAdapter.notifyDataSetChanged();
        if (isNoMore) {
            handleNoMoreData(true);
        }
    }

    protected List<Visitable> onGetListVisitableData(List<T> list) {
        if (list != null && list.size() > 0) {
            ArrayList<Visitable> datas = new ArrayList<>();
            Class modleClass = null;
            Class tClass = null;
            Constructor declaredConstructor = null;
            for (T data : list) {
                try {
                    if (modleClass == null) {
                        modleClass = getGenericModelClass(this.getClass());
                    }
                    if (tClass == null) {
                        tClass = getGenericTClass(this.getClass());
                        declaredConstructor = modleClass.getDeclaredConstructor(tClass);
                        declaredConstructor.setAccessible(true);
                    }
                    Object o = declaredConstructor.newInstance(data);
                    if (o instanceof Visitable) {
                        datas.add((Visitable) o);
                    }
                } catch (Exception e) {
                    YLog.error(this, "BaseLoadMoreFragment onGetListVisitableData exception", e);
                }
            }
            return datas;
        }
        return null;
    }

    @Override
    public void onGetMoreListData(List<T> data, boolean isNoMore) {
        mAdapter.addData(onGetListVisitableData(data));
        mAdapter.notifyDataSetChanged();
        if (isNoMore) {
            handleNoMoreData(false);
        } else {
            mHqwxRefreshLayout.finishLoadMore();
        }
    }

    @Override
    public void onNoData() {
        mHqwxRefreshLayout.handleNoData();
        setNoDataView();
    }

    @Override
    public void showLoadingView() {
        if (mAdapter == null || mAdapter.isEmpty()) {
            super.showLoadingView();
        }
    }

    @Override
    public void onError(boolean isRefresh, Throwable e) {
        mHqwxRefreshLayout.handleErrorData(isRefresh);
        if (isRefresh) {
            if (mAdapter.getDatas() != null && mAdapter.getDatas().size() > 0) {
                ToastUtil.showMessage(getActivity(), "刷新失败，请重试");
            } else {
                setErrorView(e);
            }
        } else {
            if (mAdapter.getDatas() != null && mAdapter.getDatas().size() > 0) {
                ToastUtil.showMessage(getActivity(), "加载更多失败，请重试");
            } else {
                setErrorView(e);
            }
        }
    }

    @Override
    public void onNoMoreData() {
        handleNoMoreData(false);
    }


    protected void handleNoMoreData(boolean isFromRefresh) {
        if (isFromRefresh) {
            mHqwxRefreshLayout.handleFinishRefreshData(true);
        } else {
            mHqwxRefreshLayout.handleFinishLoadMoreData(true);
        }
    }

    @Override
    public void onDestroy() {
        if (mPresenter != null) {
            mPresenter.onDetach();
        }
        super.onDestroy();
    }
}
