package com.edu24ol.newclass.discover.base;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.edu24.data.DataApiFactory;
import com.edu24.data.server.discover.entity.ArticleAuthor;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.edu24.data.server.discover.entity.VideoScene;
import com.edu24.data.server.entity.GoodsGroupListBean;
import com.edu24.data.server.integration.share.NotifyShareCreditContract;
import com.edu24.data.server.integration.share.NotifyShareCreditPresenter;
import com.edu24.data.server.integration.share.ShareCrediteRes;
import com.edu24.data.server.wechatsale.entity.OfficialAccountDialogBean;
import com.edu24.data.server.wechatsale.entity.WechatSaleBean;
import com.edu24ol.newclass.discover.DiscoverEvent;
import com.edu24ol.newclass.discover.adapter.DiscoverBaseArticleListAdapter;
import com.edu24ol.newclass.discover.presenter.ArticleStatPresenter;
import com.edu24ol.newclass.discover.presenter.DiscoverArticlePresenter;
import com.edu24ol.newclass.discover.presenter.IArticleStatPresenter;
import com.edu24ol.newclass.discover.presenter.IDiscoverArticlePresenter;
import com.edu24ol.newclass.discover.presenter.published.PublishedContract;
import com.edu24ol.newclass.discover.presenter.published.PublishedImpl;
import com.edu24ol.newclass.discover.presenter.ui.IArticleStatMvpView;
import com.edu24ol.newclass.discover.stat.DiscoverStat;
import com.edu24ol.newclass.discover.util.DiscoverRouterUtils;
import com.edu24ol.newclass.discover.util.ItemExposureReportHelper;
import com.edu24ol.newclass.discover.util.ScrollCalculatorHelper;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleEvent;
import com.edu24ol.newclass.discover.widget.DiscoverRecommendItemDecoration;
import com.edu24ol.newclass.discover.widget.DiscoverReportDialog;
import com.ethanhua.skeleton.Skeleton;
import com.ethanhua.skeleton.SkeletonScreen;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.discovershare.OnDiscoverShareImpl;
import com.hqwx.android.platform.AppMessage;
import com.hqwx.android.platform.exception.HqException;
import com.hqwx.android.platform.model.ShareTypeModel;
import com.hqwx.android.platform.stat.StatAgent;
import com.hqwx.android.platform.stat.StatEvent;
import com.hqwx.android.platform.stat.StatParamStorage;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.ToastUtil;
import com.hqwx.android.platform.widgets.CommonDialog;
import com.hqwx.android.platform.widgets.LoadingDataStatusView;
import com.hqwx.android.platform.widgets.pullrefresh.HqwxRefreshLayout;
import com.hqwx.android.service.AppRouter;
import com.hqwx.android.service.ServiceFactory;
import com.hqwx.android.service.difference.DifferenceConfig;
import com.hqwx.android.service.mall.video.MallVideoExtra;
import com.hqwx.android.service.mall.video.MallVideoRouter;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.yy.android.educommon.log.YLog;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import de.greenrobot.event.EventBus;
import rx.subscriptions.CompositeSubscription;

/**
 * Created by zhanghong on 2019/4/22.
 * <p>
 * 发现tab列表fragment的基类 用于处理公共相应方法
 */

public abstract class BaseDiscoverArticleListFragment<A extends DiscoverBaseArticleListAdapter>
    extends DiscoverBaseFragment
    implements DiscoverArticleEvent.HeaderEventListener,
    DiscoverArticleEvent.FooterEventListener, DiscoverArticleEvent.MoreMenuEventListener,
    DiscoverArticleEvent.CommonEventListener,
    IDiscoverArticlePresenter.IDiscoverArticleView, IArticleStatMvpView,
    NotifyShareCreditContract.INotifyShareCreditMvpView, PublishedContract.View {
    private static final String TAG = "BaseDiscoverArticleList";
    protected DiscoverArticlePresenter mDiscoverArticlePresenter;
    protected A mAdapter;

    protected RecyclerView mRecyclerView;
    OnDiscoverShareImpl mOnDiscoverShareImpl;
    protected HqwxRefreshLayout mSmartRefreshLayout;
    protected LoadingDataStatusView mLoadingDataStatusView;
    private SkeletonScreen mSkeletonScreen;

    protected TextView mRefreshNoticeView;

    protected String mIntentIdString;

    protected int mChildFragmentType;   //判断子页面类型

    protected IArticleStatPresenter mArticleStatPresenter;

    public static final int CHILD_RECOMMEND_FRG_TYPE = 1;   //推荐列表fragment
    public static final int CHILD_ATTENTION_FRG_TYPE = 2; //关注列表fragment
    public static final int CHILD_TOPIC_HOT_FRG_TYPE = 3; //精选话题列表fragment
    public static final int CHILD_TOPIC_NEW_FRG_TYPE = 4; //最新话题fragment
    public static final int CHILD_SQUARE_FRG_TYPE = 5;   //广场列表fragment
    public static final int CHILD_AUTHOR_FRG_TYPE = 6;   //作者主页内容fragment
    public static final int CHILD_LEAVE_WORD_FRG_TYPE = 7;   //录播课学习页-留言fragment

    private ArticleInfo mShareArticleInfo;  //分享ArticleInfo
    NotifyShareCreditContract.INotifyShareCreditMvpPresenter mShareCreditMvpPresenter;

    protected long enterTime;
    /**
     * 是否在可交互状态
     */
    protected boolean mIsInteractiveState;

    public void setIntentIdString(String intentIdString) {
        mIntentIdString = intentIdString;
    }

    private ScrollCalculatorHelper mScrollCalculatorHelper;
    protected ItemExposureReportHelper mItemExposureReportHelper;

    protected StatParamStorage.StatParams mStatParams;

    public void setStatParams(StatParamStorage.StatParams statParams) {
        mStatParams = statParams;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mDiscoverArticlePresenter = new DiscoverArticlePresenter(this);
        mArticleStatPresenter = new ArticleStatPresenter();
        mArticleStatPresenter.onAttach(this);

        ServiceFactory.getAppService()
            .registerPreferenceChangeListener(mOnSharedPreferenceChangeListener);
    }

    protected void initAdapter() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(getActivity());
        linearLayoutManager.setAutoMeasureEnabled(true);
        mRecyclerView.setLayoutManager(linearLayoutManager);
        mRecyclerView.addItemDecoration(new DiscoverRecommendItemDecoration(getActivity(),
            Color.parseColor("#F4F6F9"), DisplayUtils.dip2px(getContext(), 7)));
        mAdapter = getAdapter();
        mRecyclerView.setAdapter(mAdapter);
        mAdapter.setCommonEventListener(this);
        mAdapter.setFooterEventListener(this);
        mAdapter.setHeaderEventListener(this);
        mAdapter.setMoreMenuEventListener(this);
    }

    protected abstract A getAdapter();

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        mArticleStatPresenter.onDetach();
        mItemExposureReportHelper.release();
    }

    @Override
    public void onDestroy() {
        if (mShareCreditMvpPresenter != null) {
            mShareCreditMvpPresenter.onDetach();
        }
        if (mPublishedPresenter != null) {
            mPublishedPresenter.onDetach();
        }
        ServiceFactory.getAppService()
            .unregisterPreferenceChangeListener(mOnSharedPreferenceChangeListener);
        super.onDestroy();
    }

    @Override
    public void onAuthorInfoClick(ArticleAuthor author) {
        switch (getChildFragmentType()) {
            case CHILD_RECOMMEND_FRG_TYPE: {
                StatAgent.onEvent(getContext(), "Discovery_RecommendedList_clickWriter");
            }
            break;
            case CHILD_ATTENTION_FRG_TYPE: {
                StatAgent.onEvent(getContext(), "Discovery_AttentionList_clickWriter");
            }
            break;
            default:
                break;
        }
        if (author != null) {
            AppRouter.startAuthorDetailAct(getActivity(), author.id);
        }
    }

    @Override
    public void onArticleItemClick(ArticleInfo articleInfo) {
        onArticleItemClick(articleInfo, getBelongSeat());
    }

    @Override
    public void onArticleItemClick(@NonNull @NotNull ArticleInfo articleInfo,
                                   @NonNull @NotNull String belongSeat) {
        pauseVideo();
        if (articleInfo.contentType == ArticleInfo.CONTENT_TYPE_VIDEO) {

            handleVideoArticleClick(articleInfo, belongSeat, 0);

        } else {
            AppRouter.startArticleDetailAct(getActivity(), articleInfo.id, getBelongPage(),
                belongSeat, (articleInfo.postion + 1) + "", false, 0);
        }
    }

    private void handleVideoArticleClick(ArticleInfo articleInfo, String belongSeat, long videoStartPlayPosition) {
        if (DifferenceConfig.discoverDifferenceService.isDiscoverVideoJumpToMallVideo()) {
            int secondCategoryId = 0;
            if (mIntentIdString != null) {
                try {
                    secondCategoryId = Integer.parseInt(mIntentIdString);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            MallVideoExtra mallVideoExtra = new MallVideoExtra(
                articleInfo.id,
                secondCategoryId,
                "发现社区", belongSeat,
                String.valueOf(0),
                0,
                0, MallVideoExtra.SCENE_DISCOVER
            );
            MallVideoRouter.startMallVideoHome(
                getActivity(),
                mallVideoExtra
            );
        } else {
            DiscoverRouterUtils.startVideoArticleDetail(
                getActivity(),
                articleInfo.id,
                false,
                articleInfo.getSecondCategoryId(),
                videoStartPlayPosition,
                VideoScene.SCENE_DISCOVER,
                -1,
                getBelongPage(),
                belongSeat,
                (articleInfo.postion + 1) + "",
                null);
        }
    }

    @Override
    public void onForwardArticleItemClick(@NonNull ArticleInfo articleInfo) {
        onArticleItemClick(articleInfo);
    }

    @Override
    public void onRecommendCourseClick(GoodsGroupListBean goodsGroupListBean) {
        if (goodsGroupListBean != null) {
            String belongPage = getBelongPage();
            String belongSeat = "内容课程推荐";
            AppRouter.startGoodsCourseDetailAct(getActivity(), goodsGroupListBean.id, belongPage,
                belongSeat);
        } else {
            ToastUtil.showMessage(getActivity(), "推荐课程信息异常");
        }
    }

    @Override
    public void onForwardArticleClick(ArticleInfo articleInfo) {
        handleForwardClick(articleInfo);
    }

    @Override
    public void onShareArticleClick(ArticleInfo articleInfo) {
        if (mOnDiscoverShareImpl != null && mOnDiscoverShareImpl.isShowing()) {
            return;
        }
        mShareArticleInfo = articleInfo;
        popShareWindow(mShareArticleInfo);
        StatAgent.onAppShare(getContext(), getBelongPage(), "转发",
            articleInfo.id, articleInfo.getShareStatContent(), "链接");
    }

    @Override
    public void onEvaluateArticleClick(ArticleInfo articleInfo) {
        pauseVideo();
        if (articleInfo.contentType == ArticleInfo.CONTENT_TYPE_VIDEO) {
            handleVideoArticleClick(articleInfo, getBelongSeat(), mScrollCalculatorHelper.getPlayPositionByArticleId(articleInfo.id));

        } else {
            AppRouter.startArticleDetailAct(getActivity(), articleInfo.id, getBelongPage(),
                getBelongSeat(), (articleInfo.postion + 1) + "", false,
                0);
        }
    }

    @Override
    public void onPraiseArticleClick(ArticleInfo articleInfo, int handlePosition) {
        if (!ServiceFactory.getAccountService().isLogin()) {
            AppRouter.startAccountPhoneLogin(getActivity());
            return;
        }
        String authorName = "";
        if (articleInfo.author != null) {
            authorName = articleInfo.author.name;
        }
        DiscoverStat.onAppContentLike(getContext(), getBelongPage(), getBelongSeat(),
            !articleInfo.isLikeArticle(),
            String.valueOf(articleInfo.id), articleInfo.title, authorName,
            null, null);
        mDiscoverArticlePresenter
            .handleArticleLikeState(!articleInfo.isLikeArticle(), articleInfo.id,
                handlePosition);
    }

    @Override
    public void onAttentionClick(CheckBox checkBox, ArticleAuthor author, boolean attention) {
        //子类实现
    }

    @Override
    public void onMenuShareClick(@NonNull @NotNull ArticleInfo articleInfo) {
        onShareArticleClick(articleInfo);
    }

    @Override
    public void onMenuReportClick(@NonNull @NotNull ArticleInfo articleInfo) {
        DiscoverReportDialog reportDialog =
            new DiscoverReportDialog(getActivity(), articleInfo.id);
        reportDialog.showAtBottom();
    }

    @Override
    public void onMenuDeleteClick(@NonNull @NotNull ArticleInfo articleInfo) {
        new CommonDialog.Builder(BaseDiscoverArticleListFragment.this.getActivity())
            .setMessage("是否删除动态").setLeftButton("删除", (dialog, which) -> {
                mDiscoverArticlePresenter
                    .deleteArticle(ServiceFactory.getAccountService().getHqToken(),
                        articleInfo.id);
            }).setRightButton(R.string.discover_cancel, null).show();
    }

// @Override
// public void onMoreClick(ArticleInfo articleInfo) {
//     DetailOptionListDialog detailOptionListDialog = new DetailOptionListDialog(getActivity());
//     detailOptionListDialog.setEventListener(new DetailOptionListDialog.EventListener() {
//         @Override
//         public void onDelete(View view) {
//
//         }
//
//         @Override
//         public void onReport(View view) {
//
//         }
//     });
//     detailOptionListDialog.showAtBottom();
// }

    @Override
    public CompositeSubscription getCompositeSubscription() {
        return mCompositeSubscription;
    }

    @Override
    public void onHandlerArticleLikeStateSuccess(boolean isToLike, int handlePosition) {
        //将目的数据刷新 并按照格式更新点赞adapter
        if (mRecyclerView != null && mRecyclerView.getAdapter() != null &&
            (mRecyclerView.getAdapter() instanceof DiscoverBaseArticleListAdapter)) {
            DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter =
                (DiscoverBaseArticleListAdapter) mRecyclerView.getAdapter();
            handleDoubleParise(isToLike, handlePosition, discoverBaseArticleListAdapter);
        }
    }

    protected void handleDoubleParise(boolean isToLike, int handlePosition,
                                      DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter) {
        if (discoverBaseArticleListAdapter == null) {
            return;
        }
        HomeDiscoverArticleItemBean homeDiscoverArticleItemBean =
            discoverBaseArticleListAdapter.getItem(handlePosition);
        if (homeDiscoverArticleItemBean != null) {
            if (isToLike) {
                //防止重复点赞
                if (!homeDiscoverArticleItemBean.isLikeArticle()) {
                    homeDiscoverArticleItemBean.isLike = 1;
                    homeDiscoverArticleItemBean.pointsCount++;
                    EventBus.getDefault().post(AppMessage.obtain(DiscoverEvent.ON_LIKE_ARTICLE,
                            homeDiscoverArticleItemBean.id)
                        .setObj2(homeDiscoverArticleItemBean.pointsCount));
                }

            } else {
                if (homeDiscoverArticleItemBean.isLikeArticle()) {
                    homeDiscoverArticleItemBean.isLike = 0;
                    homeDiscoverArticleItemBean.pointsCount--;
                    EventBus.getDefault().post(AppMessage
                        .obtain(DiscoverEvent.ON_UNLIKE_ARTICLE,
                            homeDiscoverArticleItemBean.id)
                        .setObj2(homeDiscoverArticleItemBean.pointsCount));

                }
            }
        }
    }

    private void popShareWindow(ArticleInfo articleInfo) {
        if (articleInfo == null) {
            return;
        }
        StatAgent.onEvent(getContext(), StatEvent.HOME_COURSEDETAIL_CLICKCOURSESHARE);
        if (mOnDiscoverShareImpl == null) {
            mOnDiscoverShareImpl = new OnDiscoverShareImpl(getActivity());
        }
        mOnDiscoverShareImpl.popShareWindow(articleInfo, mRecyclerView, getBelongPage(),
            new OnDiscoverShareImpl.OnShareStatAndSuccessListener() {
                @Override
                public void onHandleStat(ShareTypeModel shareTypeModel) {
                    mArticleStatPresenter.statArticleShare(mShareArticleInfo.id,
                        ServiceFactory.getAccountService().getHqToken());
                }

                @Override
                public void onShareSuccess(SHARE_MEDIA shareMedia) {
                    handleShareSuccess();
                }
            }
        );

    }

    private void handleForwardClick(ArticleInfo articleInfo) {
        mShareArticleInfo = articleInfo;
        DiscoverRouterUtils.startForwardDynamic(getActivity(),
            articleInfo);
        StatAgent.onAppShare(getContext(), getBelongPage(), "转发",
            articleInfo.id, articleInfo.getShareStatContent(), "链接");
    }

    protected void showNoticeView() {
        mRefreshNoticeView.setVisibility(View.VISIBLE);
        ViewGroup.MarginLayoutParams params =
            (ViewGroup.MarginLayoutParams) mRefreshNoticeView.getLayoutParams();
        params.topMargin = 0;
        mRefreshNoticeView.setLayoutParams(params);
        int totalMargin = DisplayUtils.dip2px(-33);
        ValueAnimator anim = ValueAnimator.ofFloat(0.0f, totalMargin);
        anim.setDuration(300);
        anim.setStartDelay(1500);
        anim.start();
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                if (animation.getAnimatedValue() instanceof Float) {
                    float cVal = (Float) animation.getAnimatedValue();
                    ViewGroup.MarginLayoutParams params =
                        (ViewGroup.MarginLayoutParams) mRefreshNoticeView.getLayoutParams();
                    params.topMargin = (int) cVal;
                    mRefreshNoticeView.setLayoutParams(params);
                }
            }
        });
        anim.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                mRefreshNoticeView.setVisibility(View.GONE);
            }

            @Override
            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
            }
        });
    }

    protected void refreshArticleList() {

    }

    protected SharedPreferences.OnSharedPreferenceChangeListener mOnSharedPreferenceChangeListener =
        new SharedPreferences.OnSharedPreferenceChangeListener() {
            @Override
            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences,
                                                  String key) {
                if (TextUtils.equals(key, "key_intent_exam_ids") &&
                    ServiceFactory.getAccountService().isLogin()) {
                    String newIntentIdString =
                        ServiceFactory.getAppService().getIntentIdString(getContext());
                    if (!TextUtils.isEmpty(mIntentIdString) &&
                        !TextUtils.isEmpty(newIntentIdString) &&
                        !mIntentIdString.equals(newIntentIdString)) {
                        mIntentIdString = newIntentIdString;
                        refreshArticleList();
                    }
                }
            }
        };

    @Override
    public void setPresenter(Object presenter) {

    }

    @Override
    public boolean isActive() {
        return isAdded();
    }

    @Override
    protected String onGetIntentId() {
        return mIntentIdString;
    }

    public void onEvent(AppMessage appMessage) {
        if (DiscoverEvent.ON_COMMENT_ARTICLE.equals(appMessage.getWhat())) {
            //这里Obj携带articleId
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (long) appMessage.getObj();
                int passRelayCount = -1;
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    passRelayCount = (int) appMessage.getObj2();
                }
                updateReplyCountByArticleId(mAdapter, passRelayCount, articleId);
            }
            return;
        } else if (DiscoverEvent.ON_LIKE_ARTICLE.equals(appMessage.getWhat()) ||
            DiscoverEvent.ON_UNLIKE_ARTICLE.equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (long) appMessage.getObj();
                Log.e("TAG",
                    "BaseDiscoverArticleListFragment onEvent updatePraiseAndPointCountByArticleId:");
                updatePraiseAndPointCountByArticleId(mAdapter, appMessage, articleId);
            }
            return;
        } else if (DiscoverEvent.ON_COMMENT_ARTICLE_COMMENT.equals(appMessage.getWhat())) {
            //这里Obj2携带articleId
            if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Long) {
                long articleId = (long) appMessage.getObj2();
                int passRelayCount = -1;
                if (appMessage.getObj3() != null && appMessage.getObj3() instanceof Integer) {
                    passRelayCount = (int) appMessage.getObj3();
                }
                updateReplyCountByArticleId(mAdapter, passRelayCount, articleId);
            }
            return;
        } else if (DiscoverEvent.ON_DELETE_ARTICLE.equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (long) appMessage.getObj();
                boolean isCurrentObject = false;
                if (appMessage.getFromObject() != null && appMessage.getFromObject().equals(this)) {
                    isCurrentObject = true;
                }
                updateArticleListByArticleId(articleId, isCurrentObject);
            }
            return;
        } else if (DiscoverEvent.ON_SHARE_ARTICLE.equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (long) appMessage.getObj();
                handleItemShareCount(mAdapter, appMessage, articleId);
            }
            return;
        } else if (DiscoverEvent.ON_TRANSMIT_ARTICLE.equals(appMessage.getWhat())) {
            if (appMessage.getObj() != null && appMessage.getObj() instanceof Long) {
                long articleId = (long) appMessage.getObj();
                handleItemTransmitCount(mAdapter, appMessage, articleId);
            }
            return;
        }
    }

    private void handleItemTransmitCount(
        DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter,
        AppMessage appMessage, long articleId) {
        try {
            int findIndex = findHandlePos(discoverBaseArticleListAdapter,
                articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem =
                    discoverBaseArticleListAdapter.getDatas().get(findIndex);
                int transmitCount = -1;
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    transmitCount = (int) appMessage.getObj2();
                }
                if (transmitCount != -1) {
                    findItem.transmitCount = transmitCount;
                } else {
                    findItem.transmitCount += 1;
                }
                Log.e("TAG", "BaseDiscoverArticleListFragment handleItemTransmitCount:");
                findIndex = needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(
                        findIndex + discoverBaseArticleListAdapter.getHeaderCount(),
                        "transmitCount");
                }
            }
        } catch (Exception e) {
            Log.e(TAG, "handleItemShareCount try catch error", e);
        }
    }

    private void handleItemShareCount(DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter,
                                      AppMessage appMessage, long articleId) {
        try {
            int findIndex = findHandlePos(discoverBaseArticleListAdapter,
                articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem =
                    discoverBaseArticleListAdapter.getDatas().get(findIndex);
                int shareCount = -1;
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    shareCount = (int) appMessage.getObj2();
                }
                if (shareCount != -1) {
                    findItem.shareCount = shareCount;
                } else {
                    findItem.shareCount += 1;
                }
                findIndex = needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(
                        findIndex + discoverBaseArticleListAdapter.getHeaderCount(),
                        "shareCount");
                }
            }
        } catch (Exception e) {
            Log.e(TAG, "handleItemShareCount try catch error", e);
        }
    }

    protected void updateReplyCountByArticleId(
        DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, int passReplyCount,
        long articleId) {
        try {
            int findIndex = findHandlePos(discoverBaseArticleListAdapter,
                articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem =
                    discoverBaseArticleListAdapter.getDatas().get(findIndex);

                if (passReplyCount != -1) {
                    findItem.replyCount = passReplyCount;
                } else {
                    findItem.replyCount += 1;
                }
                findIndex = needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(
                        findIndex + discoverBaseArticleListAdapter.getHeaderCount(),
                        "replayCount");
                }
            }
        } catch (Exception e) {
            Log.e(TAG, "updateReplyCountByArticleId try catch error", e);
        }

    }

    protected void updatePraiseAndPointCountByArticleId(
        DiscoverBaseArticleListAdapter discoverBaseArticleListAdapter, AppMessage appMessage,
        long articleId) {
        try {
            int findIndex = findHandlePos(discoverBaseArticleListAdapter,
                articleId);
            if (findIndex != -1 && discoverBaseArticleListAdapter != null) {
                HomeDiscoverArticleItemBean findItem =
                    discoverBaseArticleListAdapter.getDatas().get(findIndex);
                if (appMessage.getObj2() != null && appMessage.getObj2() instanceof Integer) {
                    findItem.pointsCount = (int) appMessage.getObj2();
                }
                if (DiscoverEvent.ON_LIKE_ARTICLE.equals(appMessage.getWhat())) {
                    findItem.isLike = 1;
                } else if (DiscoverEvent.ON_UNLIKE_ARTICLE.equals(appMessage.getWhat())) {
                    findItem.isLike = 0;
                }
                findIndex = needToDealFindIndex(findIndex);
                if (findIndex != -1) {
                    discoverBaseArticleListAdapter.notifyItemChanged(
                        findIndex + discoverBaseArticleListAdapter.getHeaderCount(), "praise");
                }
            }
        } catch (Exception e) {
            YLog.error(TAG, "updatePraiseAndPointCountByArticleId try catch error", e);
        }
    }

    protected int needToDealFindIndex(int findIndex) {
        return findIndex;
    }

    private int findHandlePos(DiscoverBaseArticleListAdapter
                                  discoverBaseArticleListAdapter,
                              long articleId) {
        int findIndex = -1;
        if (discoverBaseArticleListAdapter != null &&
            discoverBaseArticleListAdapter.getDatas() != null &&
            discoverBaseArticleListAdapter.getDatas().size() > 0) {
            {
                for (int i = 0; i < discoverBaseArticleListAdapter.getDatas().size(); i++) {
                    HomeDiscoverArticleItemBean homeDiscoverArticleItemBean =
                        discoverBaseArticleListAdapter.getDatas().get(i);
                    if (homeDiscoverArticleItemBean.id == articleId) {
                        findIndex = i;
                        break;
                    }
                }
            }
        }
        return findIndex;
    }

    @Override
    public void onDeleteArticleSuccess(long articleId) {
        EventBus.getDefault().post(AppMessage.obtain(DiscoverEvent.ON_DELETE_ARTICLE, articleId)
            .setFromObject(this));
    }

    protected void updateArticleListByArticleId(long articleId, boolean isCurrentObject) {
        if (isCurrentObject) {
            ToastUtil.showMessageWithSuccess(getActivity(), "操作成功");
        }
        if (mAdapter != null && mAdapter.getDatas() != null && mAdapter.getDatas().size() > 0) {
            List<HomeDiscoverArticleItemBean> datas = mAdapter.getDatas();
            List<Integer> deletedIndexList = new ArrayList<>();
            for (int i = 0; i < datas.size(); i++) {
                HomeDiscoverArticleItemBean discoverArticleItemBean = datas.get(i);
                if (discoverArticleItemBean.id == articleId) {
                    deletedIndexList.add(i);
                }
            }
            if (deletedIndexList.size() > 0) {
                for (int j = deletedIndexList.size() - 1; j >= 0; j--) {
                    datas.remove(deletedIndexList.get(j).intValue());
                }
                mAdapter.notifyDataSetChanged();
            }
        }
    }

    @Override
    public void onDeleteArticleFailure(Throwable e, long articleId) {
        YLog.error(this, "onDeleteArticleFailure: ", e);
        if (e instanceof HqException) {
            ToastUtil.showMessage(getActivity(), e.getMessage());
        } else {
            ToastUtil.showMessage(getActivity(), "删除失败，请重试");
        }
    }

    public void notifyAdapterDataSetChanged() {
        if (mAdapter != null && mAdapter.getDatas() != null && mAdapter.getDatas().size() > 0) {
            mAdapter.notifyDataSetChanged();
        }
    }

    public abstract int getChildFragmentType();

    public abstract String getBelongPage();

    protected String getBelongSeat() {
        return mStatParams != null ? mStatParams.getBelongSeat() : "";
    }

    protected void addScrollAutoPlayVideo() {
        if (mRecyclerView != null) {
            mScrollCalculatorHelper = new ScrollCalculatorHelper(getActivity());
            mItemExposureReportHelper = new ItemExposureReportHelper(mRecyclerView);
            mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
                @Override
                public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                    mScrollCalculatorHelper.onScrollStateChanged(recyclerView, newState);
                    mItemExposureReportHelper.onScrollStateChanged(recyclerView, newState);
                }

                @Override
                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    mScrollCalculatorHelper.onScrolled(recyclerView, dx, dy);
                }
            });
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        pauseVideo();
        uploadArticleExposureStat();
        handleAppStayStat();
        mIsInteractiveState = false;
    }

    /**
     * 上传item曝光量
     */
    protected void uploadArticleExposureStat() {
        SparseIntArray exposureDate = mItemExposureReportHelper.getData();
        if (exposureDate.size() > 0) {
            List<Long> articleIdList = new ArrayList<>();
            for (int i = 0; i < exposureDate.size(); i++) {
                int position = exposureDate.keyAt(i);
                int count = exposureDate.valueAt(i);
                int realPosition = mAdapter.getArticleRealPosition(position);
                if (realPosition >= 0) {
                    ArticleInfo articleInfo = mAdapter.getItem(realPosition);
                    if (articleInfo != null) {
                        long articleId = articleInfo.id;
                        for (int j = 0; j < count; j++) {
                            articleIdList.add(articleId);
                        }
                    }
                }
            }
            mItemExposureReportHelper.reset();
            mArticleStatPresenter
                .statArticleExposure(articleIdList.toArray(new Long[articleIdList.size()]),
                    ServiceFactory.getAccountService().getHqToken(), 2);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        resetEnterTime();
        mIsInteractiveState = true;
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (!isVisibleToUser) {
            pauseVideo();
            handleAppStayStat();
            mIsInteractiveState = false;
        } else {
            resetEnterTime();
            mIsInteractiveState = true;
        }
    }

    public void pauseVideo() {
        if (mScrollCalculatorHelper != null) {
            mScrollCalculatorHelper.pauseVideo();
        }
    }

    public void setEnableLoadMoreAndRefresh(boolean enable) {
        if (mSmartRefreshLayout != null) {
            mSmartRefreshLayout.setEnableLoadMore(enable);
            mSmartRefreshLayout.setEnableRefresh(enable);
        }
    }

    protected void finishFirstLoading() {
        finishFirstLoading(false);
    }

    protected void finishFirstLoading(boolean isNoMore) {
        hideSkeletonView();
        mSmartRefreshLayout.handleFinishRefreshData(isNoMore);
    }

    protected void showErrorView(Throwable throwable) {
        hideSkeletonView();
        mSmartRefreshLayout.handleErrorData(false);
        mRefreshNoticeView.setVisibility(View.GONE);
        mLoadingDataStatusView.setLoadingBackgroundColor(Color.parseColor("#ffffff"));
        mLoadingDataStatusView.showErrorViewByThrowable(throwable);

    }

    protected void showDataView() {
        // mSmartRefreshLayout.handleFinishRefreshData(true);
        mSmartRefreshLayout.setVisibility(View.VISIBLE);
        mLoadingDataStatusView.setVisibility(View.GONE);
    }

    protected void showEmptyView() {
        hideSkeletonView();
        mSmartRefreshLayout.handleNoData();
        mRefreshNoticeView.setVisibility(View.GONE);
    }

    protected void showSkeletonView() {
        try {
            //不能在onCreateView方法调用
            if (mSkeletonScreen == null) {
                mSkeletonScreen = Skeleton.bind(mRecyclerView)
                    .adapter(mAdapter)
                    .shimmer(true)
                    .color(R.color.discover_common_shimmer_color)
                    .angle(20)
                    .frozen(false)
                    .duration(1600)
                    .count(8)
                    .load(R.layout.discover_item_skeleton_discovers)
                    .show();
            } else {
                mSkeletonScreen.show();
            }
            setEnableLoadMoreAndRefresh(false);
        } catch (Exception e) {
            YLog.error(this, " BaseDiscoverArticleListFragment showSkeletonView ", e);
        }

    }

    protected void hideSkeletonView() {
        try {
            if (mSkeletonScreen != null) {
                mSkeletonScreen.hide();
                mSkeletonScreen.hide();
            }
        } catch (Exception e) {
            YLog.error(this, " BaseDiscoverArticleListFragment hideSkeletonView ", e);
        }

        setEnableLoadMoreAndRefresh(true);
    }

    protected boolean isEnableSkeletonLoading() {
        return true;
    }

    private void handleShareSuccess() {
        if (mShareCreditMvpPresenter == null) {
            mShareCreditMvpPresenter = new NotifyShareCreditPresenter();
            mShareCreditMvpPresenter.onAttach(this);
        }
        mShareCreditMvpPresenter.notifyShareCredit(ServiceFactory.getAccountService().getHqToken(),
            ShareCrediteRes.TYPE_SHARE, ShareCrediteRes.CONTENT_TYPE_DISCOVER,
            ShareCrediteRes.TASK_SAHRE,
            mShareArticleInfo != null ? mShareArticleInfo.id : 0);
    }

    @Override
    public void onNotifyShareCreditSuccess(int credit, long contentId) {
        ToastUtil.showCreiditMessage(getActivity(), "分享成功", credit);
        EventBus.getDefault().post(AppMessage.obtain(DiscoverEvent.ON_SHARE_ARTICLE, contentId)
            .setObj2(mShareArticleInfo != null ? mShareArticleInfo.shareCount + 1 : -1));

    }

    @Override
    public void onNotifyShareCreditFailed(Throwable throwable, long contentId) {
        ToastUtil.showCreiditMessage(getActivity(), "分享成功");
        EventBus.getDefault().post(AppMessage.obtain(DiscoverEvent.ON_SHARE_ARTICLE, contentId)
            .setObj2(mShareArticleInfo != null ? mShareArticleInfo.shareCount + 1 : -1));

    }

    //本地插入的文章item集合
    public List<HomeDiscoverArticleItemBean> mLocalMakeArticleItemBeans;

    public void addPublishArticleInfoToFirst(
        HomeDiscoverArticleItemBean homeDiscoverArticleItemBean) {
        if (homeDiscoverArticleItemBean == null) {
            return;
        }
        if (mAdapter != null) {
            if (mLocalMakeArticleItemBeans == null) {
                mLocalMakeArticleItemBeans = new ArrayList<>();
            }
            if (mSmartRefreshLayout != null && mLoadingDataStatusView != null &&
                mLoadingDataStatusView.getVisibility() == View.VISIBLE) {
                showDataView();
            }
            mAdapter.addData(0, homeDiscoverArticleItemBean);
            mLocalMakeArticleItemBeans.add(homeDiscoverArticleItemBean);
            mAdapter.notifyDataSetChanged();
        }
    }

    protected void filterAndDeleteLocalArticleItemBeans() {
        if (mLocalMakeArticleItemBeans != null && mLocalMakeArticleItemBeans.size() > 0 &&
                mAdapter != null && mAdapter.getDatas() != null && mAdapter.getDatas().size() > 0) {
            List<HomeDiscoverArticleItemBean> datas = mAdapter.getDatas();
            Iterator<HomeDiscoverArticleItemBean> iterator = datas.iterator();
            while (iterator.hasNext()) {
                HomeDiscoverArticleItemBean articleItemBean = iterator.next();
                for (HomeDiscoverArticleItemBean localMakeArticleItemBean : mLocalMakeArticleItemBeans) {
                    if (localMakeArticleItemBean != null && articleItemBean != null &&
                        articleItemBean.id == localMakeArticleItemBean.id) {
                        iterator.remove();
                        break;
                    }
                }
            }
            mLocalMakeArticleItemBeans.clear();
        }
    }

    /**
     * 是否开启App 停留时长埋点上报 ，false 不开启
     *
     * @return
     */
    protected boolean getOpenAppStayStat() {
        return false;
    }

    protected void resetEnterTime() {
        if (getOpenAppStayStat()) {
            enterTime = SystemClock.elapsedRealtime();
        }
    }

    protected void handleAppStayStat() {
        if (getOpenAppStayStat()) {
            long eventDuration = SystemClock.elapsedRealtime() - enterTime;
            long time = eventDuration / 1000;
            DiscoverStat.onAppStay(getActivity(), getBelongPage(), getBelongSeat(), time, null, null,
                null);
        }
    }

    /**
     * 手动是否标记还能加载更多
     */
    protected boolean canLoadMore = true;

    /**
     * *列表滑到距离最后几条，自动加载
     */
    protected void initAutoLoadMore() {
        if (mRecyclerView == null || mSmartRefreshLayout == null) {
            return;
        }
        mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                boolean smartCanLoadMore =
                    mSmartRefreshLayout.getmSmartRefreshLayout().canLoadMore();
                if ((!canLoadMore) || (!smartCanLoadMore)) {
                    return;
                }
                LinearLayoutManager layoutManager =
                    (LinearLayoutManager) recyclerView.getLayoutManager();
                int itemCount = layoutManager.getItemCount();
                int lastPosition = layoutManager.findLastVisibleItemPosition();
                //如果当前不是正在加载更多，并且到了该加载更多的位置，加载更多。
                if ((lastPosition >= (itemCount - 10))) {
                    if (mSmartRefreshLayout.getmSmartRefreshLayout().getState() ==
                        RefreshState.None) {
                        getNextPageDataList();
                    }
                }
            }
        });
    }

    protected void getNextPageDataList() {

    }

    /**
     * 是否弹出公众号导流弹窗
     *
     * @return
     */
    protected boolean isShowOfficialAccountDialog() {
        return false;
    }

    /**
     * 公众号导流已关注弹窗
     */
    protected void showFollowSuccessDialog(long authorId) {
        //页面可交互时再调用弹框，避免多个页面接收到通知，请求多次
        if (!mIsInteractiveState) {
            return;
        }
        WechatSaleBean wechatSaleBean = new WechatSaleBean();
        wechatSaleBean.setFromPage(
            WechatSaleBean.FROM_OFFICIAL_ACCOUNT_DIVERSION);
        OfficialAccountDialogBean officialAccountDialogBean = new OfficialAccountDialogBean();
        officialAccountDialogBean.setId(authorId);
        officialAccountDialogBean.setType(4);
        officialAccountDialogBean.setSuccessTips("已关注");
        officialAccountDialogBean.setObjId(authorId);
        StatParamStorage.StatParams statParams = StatParamStorage.getInstance()
            .getStatParams(StatParamStorage.KEY_WECHAT_SALE_OFFICIAL_ACCOUNT_DIVERSION);
        AppRouter.startOfficialAccountDiversionActivity(getActivity(),
            wechatSaleBean.getJsonString(),
            statParams.getBelongPage(), officialAccountDialogBean.getJsonString());

    }

    PublishedContract.Presenter<PublishedContract.View> mPublishedPresenter;

    @Override
    public void onGetPublishedArticleDetailSuccess(@NonNull HomeDiscoverArticleItemBean articleInfo) {
        if(mSmartRefreshLayout!=null){
            mSmartRefreshLayout.finishRefresh();
        }
        if(mRecyclerView!=null){
            mRecyclerView.scrollToPosition(0);
        }
        if(mAdapter!=null){
            mAdapter.addData(0, articleInfo);
            mAdapter.notifyDataSetChanged();
        }

    }

    @Override
    public void onGetPublishedArticleDetailFailure(@NonNull Throwable throwable) {
        if(mSmartRefreshLayout!=null){
            mSmartRefreshLayout.finishRefresh();
        }
    }


    public void getPublishArticleDetail(@Nullable String passport, long authorId, long articleId, HomeDiscoverArticleItemBean homeDiscoverArticleItemBean) {
        if(mSmartRefreshLayout!=null){
            mSmartRefreshLayout.getmSmartRefreshLayout().autoRefreshAnimationOnly();
        }

        if (mPublishedPresenter == null) {
            mPublishedPresenter = new PublishedImpl<PublishedContract.View>(DataApiFactory.getInstance().getDiscoverjApi());
            mPublishedPresenter.onAttach(this);
        }
        mPublishedPresenter.getPublishArticleDetail(passport, authorId, articleId, homeDiscoverArticleItemBean);
    }
}