package com.edu24ol.newclass.discover.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.model.DiscoverReportItemModel;
import com.edu24ol.newclass.discover.model.DiscoverReportType;
import com.edu24ol.newclass.discover.viewholder.DiscoverReportItemViewHolder;
import com.hqwx.android.platform.widgets.RadioGroupAdapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


public class ReportArticleAdapter extends
        RadioGroupAdapter<DiscoverReportItemModel, DiscoverReportType> {

    public ReportArticleAdapter(Context context) {
        super(context);
    }

    @Override
    protected int getCheckViewId() {
        return R.id.item_root_view;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new DiscoverReportItemViewHolder(LayoutInflater.from(mContext).inflate(R.layout.discover_common_item_report_type,
                parent, false));
    }
}
