package com.edu24ol.newclass.discover.adapter;

import android.content.Context;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.hqwx.android.platform.adapter.BaseViewHolder;
import com.hqwx.android.platform.model.Visitable;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;

public class LoadMorelAdapter extends AbstractBaseRecycleViewAdapter<Visitable> {
    public LoadMorelAdapter(Context context) {
        super(context);
    }



    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int itemType) {
        RecyclerView.ViewHolder noMoreViewHolderByType =
                getNoMoreViewHolderByType(viewGroup, itemType);
        if(noMoreViewHolderByType!=null){
            return noMoreViewHolderByType;
        }
        return null;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        boolean handleNoMoreViewHolder = handleNoMoreViewHolder(viewHolder);
        if(handleNoMoreViewHolder){
            return;
        }else{
            BaseViewHolder baseViewHolder = (BaseViewHolder) viewHolder;
            baseViewHolder.onBindViewHolder(mContext, getItem(position));
            baseViewHolder.onPosition(position);
        }
    }

    public int getItemViewType(int position) {
        return getItem(position).type();
    }



}
