package com.edu24ol.newclass.discover.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.edu24.data.server.discover.entity.ArticleImage;
import com.hqwx.android.discover.common.R;
import com.edu24ol.newclass.discover.widget.DefaultImageViewTarget;
import com.hqwx.android.platform.utils.DisplayUtils;
import com.hqwx.android.platform.utils.glide.tranform.SafeRoundedCorners;
import com.hqwx.android.service.AppRouter;
import com.yy.android.educommon.log.YLog;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by zhanghong on 2019/4/16.
 */

public class DiscoverShortPicListAdapter
        extends RecyclerView.Adapter<DiscoverShortPicListAdapter.DiscoverShortPicViewHolder> {

    private Context mContext;

    private List<ArticleImage> mPicList = new ArrayList<>();

    public static final int DISCOVER_IMG_WIDTH = 5;

    private final SafeRoundedCorners mRoundedCorners;

    private CenterCrop mCenterCrop;

    public void setDatas(List<ArticleImage> picList) {
        this.mPicList.clear();
        if (picList != null) {
            mPicList.addAll(picList);
        }
    }

    public DiscoverShortPicListAdapter(Context context) {
        mContext = context;
        mRoundedCorners = new SafeRoundedCorners(DisplayUtils.dip2px(mContext, 2));
        mCenterCrop = new CenterCrop();
    }

    @NonNull
    @Override
    public DiscoverShortPicViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup,
                                                         int viewType) {
        LinearLayout linearLayout = new LinearLayout(mContext);
        RecyclerView.LayoutParams layoutParams =
                new RecyclerView.LayoutParams(RecyclerView.LayoutParams.WRAP_CONTENT,
                        RecyclerView.LayoutParams.WRAP_CONTENT);
        linearLayout.setLayoutParams(layoutParams);
        return new DiscoverShortPicViewHolder(linearLayout);
    }

    @Override
    public void onBindViewHolder(
            @NonNull final DiscoverShortPicViewHolder discoverShortPicViewHolder,
            final int position) {
        if (getItemCount() == 1) {
            int oWidth = 0;
            int oHeight = 0;
            ArticleImage articleImage = mPicList.get(position);
            int width = articleImage.getWidth();
            int height = articleImage.getHeight();
            if (width > 0 && height > 0) {
                int maxWidth = DisplayUtils.getScreenWidth(mContext) - mContext.getResources()
                        .getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2;
                int maxHeight = maxWidth;
                float maxAspectRatio = (float) maxWidth / (float) maxHeight;
                float displayAspectRatio = (float) width / (float) height;
                boolean shouldBeWider = displayAspectRatio > maxAspectRatio;

                if (shouldBeWider) {
                    // too wide, fix width
                    width = Math.min(width, maxWidth);
                    height = (int) (width / displayAspectRatio);
                } else {
                    // too high, fix height
                    height = Math.min(height, maxHeight);
                    width = (int) (height * displayAspectRatio);
                }
                RecyclerView.LayoutParams layoutParams =
                        (RecyclerView.LayoutParams) discoverShortPicViewHolder.itemView
                                .getLayoutParams();
                layoutParams.width = width;
                layoutParams.height = height;

                discoverShortPicViewHolder.itemView.setLayoutParams(layoutParams);
                if (mOnGetSizeListener != null) {
                    mOnGetSizeListener
                            .onGetSize(layoutParams.width, layoutParams.height);
                }
                Glide.with(mContext).load(articleImage.getUrl())
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .transform(mRoundedCorners)
                        .override(oWidth, oHeight)
                        .into(new DefaultImageViewTarget(
                                discoverShortPicViewHolder.mImageView));
            } else {
                YLog.warn(this, "onBindViewHolder: Image width or height invalid.");
                Glide.with(mContext).load(articleImage.getUrl())
                        .diskCacheStrategy(DiskCacheStrategy.ALL)
                        .transform(mRoundedCorners)
                        .listener(new RequestListener<Drawable>() {
                            @Override
                            public boolean onLoadFailed(
                                    @Nullable @org.jetbrains.annotations.Nullable GlideException e,
                                    Object model, Target<Drawable> target,
                                    boolean isFirstResource) {
                                RecyclerView.LayoutParams layoutParams =
                                        (RecyclerView.LayoutParams) discoverShortPicViewHolder.itemView
                                                .getLayoutParams();
                                layoutParams.height = layoutParams.width =
                                        DisplayUtils.dip2px(mContext, 100);
                                if (mOnGetSizeListener != null) {
                                    mOnGetSizeListener
                                            .onGetSize(layoutParams.width, layoutParams.height);
                                }
                                return false;
                            }

                            @Override
                            public boolean onResourceReady(Drawable resource, Object model,
                                                           Target<Drawable> target,
                                                           DataSource dataSource,
                                                           boolean isFirstResource) {
                                RecyclerView.LayoutParams layoutParams =
                                        (RecyclerView.LayoutParams) discoverShortPicViewHolder.itemView
                                                .getLayoutParams();
                                layoutParams.width = resource.getIntrinsicWidth();
                                layoutParams.height = resource.getIntrinsicHeight();
                                if (mOnGetSizeListener != null) {
                                    mOnGetSizeListener
                                            .onGetSize(layoutParams.width, layoutParams.height);
                                }
                                return false;
                            }
                        })
                        .into(new DefaultImageViewTarget(
                                discoverShortPicViewHolder.mImageView));
            }
        } else {
            int mImageWidth = (DisplayUtils.getScreenWidth(mContext) -
                    mContext.getResources()
                            .getDimensionPixelSize(R.dimen.platform_common_margin_size) * 2 -
                    DisplayUtils.dip2px(mContext, DISCOVER_IMG_WIDTH) * 2) / 3;
            RecyclerView.LayoutParams layoutParams =
                    (RecyclerView.LayoutParams) discoverShortPicViewHolder.itemView
                            .getLayoutParams();
            layoutParams.width = RecyclerView.LayoutParams.MATCH_PARENT;
            layoutParams.height = mImageWidth;
            discoverShortPicViewHolder.itemView.setLayoutParams(layoutParams);
            Glide.with(mContext).load(mPicList.get(position).getUrl())
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .transform(mCenterCrop, mRoundedCorners)
                    .override(mImageWidth, mImageWidth)
                    .into(new DefaultImageViewTarget(discoverShortPicViewHolder.mImageView));
        }
        discoverShortPicViewHolder.mImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                ArrayList<String> pictureList =
                        new ArrayList<>(mPicList.size());
                for (ArticleImage articleImage : mPicList) {
                    pictureList.add(articleImage.getUrl());
                }

                AppRouter.startImageViewer(mContext, pictureList, position);
            }
        });
    }

    @Override
    public int getItemCount() {
        return mPicList == null ? 0 : mPicList.size();
    }

    class DiscoverShortPicViewHolder extends RecyclerView.ViewHolder {

        ImageView mImageView;

        public DiscoverShortPicViewHolder(View itemView) {
            super(itemView);

            mImageView = new ImageView(mContext);
            LinearLayout.LayoutParams layoutParams =
                    new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT,
                            LinearLayout.LayoutParams.MATCH_PARENT);
            mImageView.setLayoutParams(layoutParams);
            mImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            LinearLayout linearLayout = (LinearLayout) itemView;
            linearLayout.addView(mImageView);
        }
    }

    private OnGetSizeListener mOnGetSizeListener = null;

    public void setOnGetSizeListener(OnGetSizeListener onGetSizeListener) {
        mOnGetSizeListener = onGetSizeListener;
    }

    public interface OnGetSizeListener {
        void onGetSize(int parentWidth, int parentHeight);
    }

}
