package com.edu24ol.newclass.discover.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.edu24.data.server.discover.entity.ArticleInfo;
import com.edu24.data.server.discover.entity.HomeDiscoverArticleItemBean;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleEvent;
import com.edu24ol.newclass.discover.viewholder.DiscoverBaseArticleListItemViewHolder;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderComment;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderFAQ;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderComment;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderDelete;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderFAQ;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderLong;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderShort;
import com.edu24ol.newclass.discover.viewholder.DiscoverForwardArticleItemViewHolderVideo;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderLong;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderShort;
import com.edu24ol.newclass.discover.viewholder.DiscoverArticleItemViewHolderVideo;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.platform.adapter.BaseViewHolderNew;
import com.hqwx.android.platform.widgets.AbstractBaseRecycleViewAdapter;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by zhanghong on 2019/4/16.
 */

public class DiscoverBaseArticleListAdapter
    extends AbstractBaseRecycleViewAdapter<HomeDiscoverArticleItemBean> {

    public static final int RECOMMEND_LAST_READ_TYPE = -1;
    /**
     * 推荐列表活动推荐
     */
    public static final int RECOMMEND_HEADER_VIEW = -2;
    /**
     * 关注列表 关注话题
     */
    public static final int ITEM_TYPE_FOLLOW_TOPIC = -3;
    /**
     * 广场列表 话题推荐
     */
    public static final int ITEM_TYPE_RECOMMEND_TOPIC = -4;
    /**
     * 无关注人，有关注话题没有关注人的情况下用到
     */
    public static final int ITEM_TYPE_FOLLOW_EMPTY = -5;

    /**
     * 无关注人时，头部提示
     */
    public static final int ITEM_TYPE_FOLLOW_EMPTY_HEADER = -6;
    /**
     * 无关注人时，获取的推荐作者
     */
    public static final int ITEM_TYPE_FOLLOW_EMPTY_AUTHOR = -7;
    /**
     * 短图文动态样式
     */
    public static final int SHORT_DISCOVER_ART_TYPE = 0;
    /**
     * 长图文文章样式
     */
    public static final int LONG_DISCOVER_ART_TYPE = 1;
    /**
     * 视频动态样式
     */
    public static final int VIDEO_DISCOVER_ART_TYPE = 2;
    /**
     * 答疑动态
     */
    public static final int FAQ_DISCOVER_ART_TYPE = 3;
    /**
     * 评价动态
     */
    public static final int COMMENT_DISCOVER_ART_TYPE = 4;

    public static final int FORWARD_SHORT_ART_TYPE = 11;
    public static final int FORWARD_LONG_ART_TYPE = 12;
    public static final int FORWARD_VIDEO_ART_TYPE = 13;
    public static final int FORWARD_FAQ_ART_TYPE = 14;
    public static final int FORWARD_COMMENT_ART_TYPE = 15;
    public static final int FORWARD_DELETE_ART_TYPE = 19;

    protected boolean mIsHaveLastRead = false;

    protected int mRefreshDataCount = 0;

    protected List<HomeDiscoverArticleItemBean> mStickRecommendList;

    public boolean isHaveLastRead() {
        return mIsHaveLastRead;
    }

    public void setHaveLastRead(boolean haveLastRead) {
        mIsHaveLastRead = haveLastRead;
    }

    public int getRefreshDataCount() {
        return mRefreshDataCount;
    }

    public void setRefreshDataCount(int refreshDataCount) {
        mRefreshDataCount = refreshDataCount;
    }

    public void setStickRecommendList(
        List<HomeDiscoverArticleItemBean> homeDiscoverArticleItemBeans) {
        mStickRecommendList = homeDiscoverArticleItemBeans;
    }

    public boolean hasStickArticleList(){
        return mStickRecommendList != null && mStickRecommendList.size() > 0;
    }

    public List<HomeDiscoverArticleItemBean> getStickRecommendList() {
        return mStickRecommendList;
    }

    /**
     * 是否显示热门标签
     */
    private boolean isShowTag = true;

    public boolean isShowTag() {
        return isShowTag;
    }

    public void setShowTag(boolean showTag) {
        isShowTag = showTag;
    }

    //是否显示右边的关注
    public boolean isShowAttention() {
        return false;
    }

    //是否显示右边的更多按钮
    public boolean isShowMoreButton() {
        return true;
    }

    protected DiscoverArticleEvent.HeaderEventListener mHeaderEventListener;

    public void setHeaderEventListener(
            DiscoverArticleEvent.HeaderEventListener headerEventListener) {
        mHeaderEventListener = headerEventListener;
    }

    protected DiscoverArticleEvent.MoreMenuEventListener mMoreMenuEventListener;

    public void setMoreMenuEventListener(
            DiscoverArticleEvent.MoreMenuEventListener moreMenuEventListener) {
        mMoreMenuEventListener = moreMenuEventListener;
    }

    protected DiscoverArticleEvent.CommonEventListener mCommonEventListener;

    public void setCommonEventListener(
            DiscoverArticleEvent.CommonEventListener commonEventListener) {
        mCommonEventListener = commonEventListener;
    }

    protected DiscoverArticleEvent.FooterEventListener mFooterEventListener;

    public void setFooterEventListener(
            DiscoverArticleEvent.FooterEventListener footerEventListener) {
        mFooterEventListener = footerEventListener;
    }

    public DiscoverBaseArticleListAdapter(Context context) {
        super(context);
    }

    protected View initItemLayoutInflater(ViewGroup parent, int resource) {
        return LayoutInflater.from(parent.getContext()).inflate(resource, parent, false);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        DiscoverBaseArticleListItemViewHolder holder = null;
        if (viewType == SHORT_DISCOVER_ART_TYPE) {
            holder = new DiscoverArticleItemViewHolderShort(mContext,
                initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_short));
        } else if (viewType == LONG_DISCOVER_ART_TYPE) {
            holder = new DiscoverArticleItemViewHolderLong(mContext,
                initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_long));
        } else if (viewType == VIDEO_DISCOVER_ART_TYPE) {
            holder = new DiscoverArticleItemViewHolderVideo(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_article_layout_video, viewGroup,
                        false));
        } else if (viewType == FAQ_DISCOVER_ART_TYPE) {
            holder = new DiscoverArticleItemViewHolderFAQ(mContext,
                initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_faq));
        } else if (viewType == COMMENT_DISCOVER_ART_TYPE) {
            holder = new DiscoverArticleItemViewHolderComment(mContext,
                initItemLayoutInflater(viewGroup, R.layout.discover_item_article_layout_comment));
        } else if (viewType == FORWARD_SHORT_ART_TYPE) {
            holder = new DiscoverForwardArticleItemViewHolderShort(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_forward_article_short, viewGroup,
                        false));
        } else if (viewType == FORWARD_LONG_ART_TYPE) {
            holder = new DiscoverForwardArticleItemViewHolderLong(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_forward_article_long, viewGroup,
                        false));
        } else if (viewType == FORWARD_VIDEO_ART_TYPE) {
            holder = new DiscoverForwardArticleItemViewHolderVideo(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_forward_article_video, viewGroup,
                        false));
        } else if (viewType == FORWARD_COMMENT_ART_TYPE) {
            holder = new DiscoverForwardArticleItemViewHolderComment(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_forward_article_comment, viewGroup,
                        false));
        } else if (viewType == FORWARD_FAQ_ART_TYPE) {
            holder = new DiscoverForwardArticleItemViewHolderFAQ(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_forward_article_faq, viewGroup,
                        false));
        } else if (viewType == FORWARD_DELETE_ART_TYPE) {
            holder = new DiscoverForwardArticleItemViewHolderDelete(mContext,
                LayoutInflater.from(viewGroup.getContext())
                    .inflate(R.layout.discover_item_forward_delete_layout, viewGroup,
                        false));
        }
        if (holder != null) {
            holder.setShowTag(isShowTag());
            holder.setShowAttention(isShowAttention());
            holder.setShowMoreButton(isShowMoreButton());
            holder.setHeaderEventListener(mHeaderEventListener);
            holder.setFooterEventListener(mFooterEventListener);
            holder.setCommonEventListener(mCommonEventListener);
            holder.setMoreMenuEventListener(mMoreMenuEventListener);
        }
        return holder;
    }

//    protected HomeDiscoverArticleItemBean getRealDiscoverItemByPos(int type, int position) {
//        if (type == SHORT_DISCOVER_ART_TYPE) {
//            if (mIsHaveLastRead && position > mRefreshDataCount) {
//                return getItem(position - 1);
//            } else {
//                return getItem(position);
//            }
//        } else {
//            return getItem(position);
//        }
//    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position,
                                 @NonNull List<Object> payloads) {
        if (payloads.isEmpty()) {
            onBindViewHolder(holder, position);
        } else {
            final HomeDiscoverArticleItemBean bean = getItem(position);
            if (bean == null) {
                return;
            }
            if (holder instanceof BaseViewHolderNew) {
                ((BaseViewHolderNew) holder).onBindViewHolder(mContext, bean, payloads, position);
            }
        }
    }

    /**
     * 获取真实位置
     *
     * @param position
     * @return 返回扣除头部数量的真实位置，没有头部返回position
     */
    public int getArticleRealPosition(int position) {
        return position;
    }

    public int getHeaderCount() {
        return 0;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, final int position) {
        final HomeDiscoverArticleItemBean bean = getItem(position);
        if (bean == null) {
            return;
        }
        if (viewHolder instanceof BaseViewHolderNew) {
            ((BaseViewHolderNew) viewHolder).onBindViewHolder(mContext, bean, position);
        }
    }

    @Override
    public int getItemViewType(int position) {
        super.getItemViewType(position);
        HomeDiscoverArticleItemBean articleInfo = getItem(position);
        if (articleInfo == null) {
            return SHORT_DISCOVER_ART_TYPE;
        }
        if (articleInfo.getRootId() > 0) {
            ArticleInfo forwardArticleInfo = articleInfo.getRootParentArticle();
            if (forwardArticleInfo == null) {
                return FORWARD_DELETE_ART_TYPE;
            } else if (forwardArticleInfo.isShortArticle() || forwardArticleInfo.isMessageArticle()) {
                return FORWARD_SHORT_ART_TYPE;
            } else if (forwardArticleInfo.isLongArticle()) {
                return FORWARD_LONG_ART_TYPE;
            } else if (forwardArticleInfo.isVideoArticle()) {
                return FORWARD_VIDEO_ART_TYPE;
            } else if (forwardArticleInfo.isFAQArticle()) {
                return FORWARD_FAQ_ART_TYPE;
            } else if (forwardArticleInfo.isCommentArticle()) {
                return FORWARD_COMMENT_ART_TYPE;
            }
        } else {
            if (articleInfo.isShortArticle() || articleInfo.isMessageArticle()) {
                return SHORT_DISCOVER_ART_TYPE;
            } else if (articleInfo.isLongArticle()) {
                return LONG_DISCOVER_ART_TYPE;
            } else if (articleInfo.isVideoArticle()) {
                return VIDEO_DISCOVER_ART_TYPE;
            } else if (articleInfo.isFAQArticle()) {
                return FAQ_DISCOVER_ART_TYPE;
            } else if (articleInfo.isCommentArticle()) {
                return COMMENT_DISCOVER_ART_TYPE;
            }
        }
        return 0;
    }


}