package com.edu24ol.newclass.discover;

import android.os.Bundle;
import android.view.LayoutInflater;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.hqwx.android.base.module.ModuleBaseActivity;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.discover.common.databinding.DiscoverCommonActivityFragmentContainerBinding;

/**
 * 粉丝列表页面
 */
public abstract class FragmentContainerActivity extends ModuleBaseActivity {

    protected DiscoverCommonActivityFragmentContainerBinding binding;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getIntentParams();
        binding = DiscoverCommonActivityFragmentContainerBinding.inflate(LayoutInflater.from(this));
        setContentView(binding.getRoot());
        initView();
        FragmentManager supportFragmentManager = getSupportFragmentManager();
        FragmentTransaction transaction = supportFragmentManager.beginTransaction();
        transaction.add(R.id.fl_container, getFragment());
        transaction.commit();
    }


    protected void initView() {

    }

    protected void getIntentParams() {

    }

    protected abstract Fragment getFragment();

}
