package com.edu24ol.newclass.base;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;

import androidx.viewpager.widget.ViewPager;

import com.hqwx.android.base.module.ModuleBaseActivity;
import com.hqwx.android.discover.common.R;
import com.hqwx.android.discover.common.databinding.DiscoverCommonActivityCommonViewpagerBinding;

import java.util.List;


public abstract class CommonViewpagerActivity extends ModuleBaseActivity {

    private CommonViewPagerAdapter mViewPagerAdapter;
    protected DiscoverCommonActivityCommonViewpagerBinding binding;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = DiscoverCommonActivityCommonViewpagerBinding.inflate(LayoutInflater.from(this));
        setContentView(binding.getRoot());
        getIntentArgs(getIntent());
        binding.titleBar.setTitle(getActivityTitle());
        initViewPager();

    }

    protected void getIntentArgs(Intent intent) {

    }

    protected abstract String getActivityTitle();

    private void initViewPager() {
        mViewPagerAdapter =
                new CommonViewPagerAdapter(getSupportFragmentManager(), getFragmentPageList());
        binding.commonViewPager.setOffscreenPageLimit(3);
        binding.commonViewPager.setAdapter(mViewPagerAdapter);
        binding.commonTabLayout.setupWithViewPager(binding.commonViewPager);
    }

    abstract protected List<FragmentPage> getFragmentPageList();

    public ViewPager getViewPager() {
        return binding.commonViewPager;
    }
}
