package com.edu24ol.newclass.base;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.fragment.app.FragmentTransaction;

import java.util.List;

public class CommonViewPagerAdapter extends FragmentPagerAdapter {

    private List<FragmentPage> mFragmentPages;
    private FragmentManager mFragmentManager;
    private long baseId = 0;

    private FragmentTransaction mCurTransaction;

    public CommonViewPagerAdapter(FragmentManager fragmentManager,
                                  List<FragmentPage> fragmentPages) {
        super(fragmentManager);
        mFragmentManager = fragmentManager;
        mFragmentPages = fragmentPages;
    }

    public void setFragmentPages(List<FragmentPage> fragmentPages){
        this.mFragmentPages = fragmentPages;
        notifyDataSetChanged();
    }

    @Override
    public Fragment getItem(int position) {
        if (mFragmentPages != null && mFragmentPages.size() > 0) {
            return mFragmentPages.get(position).getFragment();
        }
        return null;
    }

    @Override
    public CharSequence getPageTitle(int position) {
        if (mFragmentPages != null && mFragmentPages.size() > 0) {
            FragmentPage fragmentPage = mFragmentPages.get(position);
            if (fragmentPage != null) {
                return fragmentPage.getTitle();
            }
        }
        return "";
    }

    @Override
    public int getCount() {
        return mFragmentPages != null ? mFragmentPages.size() : 0;
    }

    @Override
    public long getItemId(int position) {
        // give an ID different from position when position has been changed
        return baseId + position;
    }

    public void changeId(int n) {
        // shift the ID returned by getItemId outside the range of all previous fragments
        baseId += getCount() + n;
    }
    /**
     * 清除缓存fragment
     */
    public void clear(){
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }

        for (int i = 0; mFragmentPages != null && i < mFragmentPages.size(); i++) {
            // long itemId = this.getItemId(i);
            // String name = makeFragmentName(container.getId(), itemId);
            Fragment fragment = mFragmentPages.get(i).mFragment;

            if (fragment != null) {//根据对应的ID，找到fragment，删除
                mCurTransaction.remove(fragment);
            }
        }
        mCurTransaction.commitNowAllowingStateLoss();
    }

}