/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends FilterInputStream {
    private long remaining;

    public LimitInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.remaining = l;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.remaining, (long)this.in.available());
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int n = this.in.read();
        if (n >= 0) {
            --this.remaining;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2 = (int)Math.min((long)n2, this.remaining));
        if (n3 >= 0) {
            this.remaining -= (long)n3;
        }
        return n3;
    }
}

