/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AbstractDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressParsedResult;
import java.util.regex.Pattern;

public final class EmailDoCoMoResultParser
extends AbstractDoCoMoResultParser {
    private static final String EMAIL_LOCAL = "[^:]+";
    private static final String EMAIL_DOMAIN = "([0-9a-zA-Z]+[0-9a-zA-Z\\-]+[0-9a-zA-Z]+\\.)+[a-zA-Z]{2,}";
    private static final Pattern EMAIL = Pattern.compile("^[^:]+@([0-9a-zA-Z]+[0-9a-zA-Z\\-]+[0-9a-zA-Z]+\\.)+[a-zA-Z]{2,}$");

    @Override
    public EmailAddressParsedResult parse(Result result) {
        String rawText = EmailDoCoMoResultParser.getMassagedText(result);
        if (!rawText.startsWith("MATMSG:")) {
            return null;
        }
        String[] tos = EmailDoCoMoResultParser.matchDoCoMoPrefixedField("TO:", rawText);
        if (tos == null) {
            return null;
        }
        for (String to : tos) {
            if (EmailDoCoMoResultParser.isBasicallyValidEmailAddress(to)) continue;
            return null;
        }
        String subject = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("SUB:", rawText, false);
        String body = EmailDoCoMoResultParser.matchSingleDoCoMoPrefixedField("BODY:", rawText, false);
        return new EmailAddressParsedResult(tos, null, null, subject, body);
    }

    static boolean isBasicallyValidEmailAddress(String email) {
        return email != null && EMAIL.matcher(email).matches();
    }
}

