/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.GrayscaleLuminanceSource;

public final class RGBLuminanceSource
extends GrayscaleLuminanceSource {
    public RGBLuminanceSource(int width, int height, int[] pixels) {
        super(width, height, RGBLuminanceSource.toGrayscale(width, height, pixels));
    }

    private static byte[] toGrayscale(int width, int height, int[] pixels) {
        int size = width * height;
        if (pixels == null || pixels.length < size) {
            throw new IllegalArgumentException("Pixel array length is less than width * height");
        }
        byte[] luminances = new byte[size];
        for (int offset = 0; offset < size; ++offset) {
            int pixel = pixels[offset];
            int r = pixel >> 16 & 0xFF;
            int g2 = pixel >> 7 & 0x1FE;
            int b = pixel & 0xFF;
            luminances[offset] = (byte)((r + g2 + b) / 4);
        }
        return luminances;
    }
}

