/*
 * Decompiled with CFR 0.152.
 */
package org.angmarch.views;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import org.angmarch.views.PopUpTextAlignment;
import org.angmarch.views.R;
import org.angmarch.views.SpinnerTextFormatter;

public abstract class NiceSpinnerBaseAdapter<T>
extends BaseAdapter {
    private final PopUpTextAlignment horizontalAlignment;
    private final SpinnerTextFormatter spinnerTextFormatter;
    private int textColor;
    private int backgroundSelector;
    int selectedIndex;

    NiceSpinnerBaseAdapter(Context context, int textColor, int backgroundSelector, SpinnerTextFormatter spinnerTextFormatter, PopUpTextAlignment horizontalAlignment) {
        this.spinnerTextFormatter = spinnerTextFormatter;
        this.backgroundSelector = backgroundSelector;
        this.textColor = textColor;
        this.horizontalAlignment = horizontalAlignment;
    }

    public View getView(int position, @Nullable View convertView, ViewGroup parent) {
        TextView textView;
        Context context = parent.getContext();
        if (convertView == null) {
            convertView = View.inflate((Context)context, (int)R.layout.spinner_list_item, null);
            textView = (TextView)convertView.findViewById(R.id.text_view_spinner);
            if (Build.VERSION.SDK_INT >= 16) {
                textView.setBackground(ContextCompat.getDrawable((Context)context, (int)this.backgroundSelector));
            }
            convertView.setTag((Object)new ViewHolder(textView));
        } else {
            textView = ((ViewHolder)convertView.getTag()).textView;
        }
        textView.setText((CharSequence)this.spinnerTextFormatter.format(this.getItem(position).toString()));
        textView.setTextColor(this.textColor);
        this.setTextHorizontalAlignment(textView);
        return convertView;
    }

    private void setTextHorizontalAlignment(TextView textView) {
        switch (this.horizontalAlignment) {
            case START: {
                textView.setGravity(0x800003);
                break;
            }
            case END: {
                textView.setGravity(0x800005);
                break;
            }
            case CENTER: {
                textView.setGravity(1);
            }
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public abstract T getItemInDataset(int var1);

    public long getItemId(int position) {
        return position;
    }

    public abstract T getItem(int var1);

    public abstract int getCount();

    static class ViewHolder {
        TextView textView;

        ViewHolder(TextView textView) {
            this.textView = textView;
        }
    }
}

