/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.virtualview;

import android.graphics.Rect;
import androidx.annotation.VisibleForTesting;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.virtualview.ModeChangeEmitter;
import com.facebook.react.views.virtualview.VirtualViewMode;
import com.facebook.react.views.virtualview.VirtualViewModeChangeEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/virtualview/VirtualViewEventEmitter;", "Lcom/facebook/react/views/virtualview/ModeChangeEmitter;", "viewId", "", "surfaceId", "dispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "<init>", "(IILcom/facebook/react/uimanager/events/EventDispatcher;)V", "emitModeChange", "", "mode", "Lcom/facebook/react/views/virtualview/VirtualViewMode;", "targetRect", "Landroid/graphics/Rect;", "thresholdRect", "synchronous", "", "ReactAndroid_release"})
@VisibleForTesting
public final class VirtualViewEventEmitter
implements ModeChangeEmitter {
    private final int viewId;
    private final int surfaceId;
    @NotNull
    private final EventDispatcher dispatcher;

    public VirtualViewEventEmitter(int viewId, int surfaceId, @NotNull EventDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.viewId = viewId;
        this.surfaceId = surfaceId;
        this.dispatcher = dispatcher;
    }

    @Override
    public void emitModeChange(@NotNull VirtualViewMode mode, @NotNull Rect targetRect, @NotNull Rect thresholdRect, boolean synchronous) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)targetRect, (String)"targetRect");
        Intrinsics.checkNotNullParameter((Object)thresholdRect, (String)"thresholdRect");
        this.dispatcher.dispatchEvent(new VirtualViewModeChangeEvent(this.surfaceId, this.viewId, mode, targetRect, thresholdRect, synchronous));
    }
}

