/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.text.Spannable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.common.annotations.LegacyArchitectureShadowNodeWithCxxImpl;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.textinput.ReactTextInputLocalData;
import com.facebook.react.views.view.MeasureUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@LegacyArchitectureShadowNodeWithCxxImpl
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\"H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020 H\u0016J\b\u00104\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u00066"}, d2={"Lcom/facebook/react/views/textinput/ReactTextInputShadowNode;", "Lcom/facebook/react/views/text/ReactBaseTextShadowNode;", "Lcom/facebook/yoga/YogaMeasureFunction;", "reactTextViewManagerCallback", "Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "<init>", "(Lcom/facebook/react/views/text/ReactTextViewManagerCallback;)V", "mostRecentEventCount", "", "internalEditText", "Landroid/widget/EditText;", "localData", "Lcom/facebook/react/views/textinput/ReactTextInputLocalData;", "value", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "placeholder", "getPlaceholder", "setPlaceholder", "setThemedContext", "", "themedContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "measure", "", "node", "Lcom/facebook/yoga/YogaNode;", "width", "", "widthMode", "Lcom/facebook/yoga/YogaMeasureMode;", "height", "heightMode", "isVirtualAnchor", "", "isYogaLeafNode", "setLocalData", "data", "", "setMostRecentEventCount", "setTextBreakStrategy", "textBreakStrategy", "onCollectExtraUpdates", "uiViewOperationQueue", "Lcom/facebook/react/uimanager/UIViewOperationQueue;", "setPadding", "spacingType", "padding", "createInternalEditText", "Companion", "ReactAndroid_release"})
public final class ReactTextInputShadowNode
extends ReactBaseTextShadowNode
implements YogaMeasureFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mostRecentEventCount;
    @Nullable
    private EditText internalEditText;
    @Nullable
    private ReactTextInputLocalData localData;
    @Nullable
    private String text;
    @Nullable
    private String placeholder;
    @NotNull
    public static final String PROP_TEXT = "text";
    @NotNull
    public static final String PROP_PLACEHOLDER = "placeholder";

    @JvmOverloads
    public ReactTextInputShadowNode(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        super(reactTextViewManagerCallback);
        this.mostRecentEventCount = -1;
        this.mTextBreakStrategy = 1;
        this.setMeasureFunction(this);
    }

    public /* synthetic */ ReactTextInputShadowNode(ReactTextViewManagerCallback reactTextViewManagerCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reactTextViewManagerCallback = null;
        }
        this(reactTextViewManagerCallback);
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    @ReactProp(name="text")
    public final void setText(@Nullable String value) {
        this.text = value;
        this.markUpdated();
    }

    @Nullable
    public final String getPlaceholder() {
        return this.placeholder;
    }

    @ReactProp(name="placeholder")
    public final void setPlaceholder(@Nullable String value) {
        this.placeholder = value;
        this.markUpdated();
    }

    @Override
    public void setThemedContext(@NotNull ThemedReactContext themedContext) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)themedContext), (String)"themedContext");
            super.setThemedContext(themedContext);
            EditText editText = this.createInternalEditText();
            this.setDefaultPadding(4, ViewCompat.getPaddingStart((View)((View)editText)));
            this.setDefaultPadding(1, editText.getPaddingTop());
            this.setDefaultPadding(5, ViewCompat.getPaddingEnd((View)((View)editText)));
            this.setDefaultPadding(3, editText.getPaddingBottom());
            EditText editText2 = this.internalEditText = editText;
            if (editText2 != null) {
                editText2.setPadding(0, 0, 0, 0);
            }
            EditText editText3 = this.internalEditText;
            if (editText3 == null) break block1;
            editText3.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        }
    }

    @Override
    public long measure(@NotNull YogaNode node, float width, @NotNull YogaMeasureMode widthMode, float height, @NotNull YogaMeasureMode heightMode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)widthMode), (String)"widthMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightMode), (String)"heightMode");
        EditText editText = this.internalEditText;
        if (editText == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        EditText editText2 = editText;
        if (this.localData != null) {
            ReactTextInputLocalData reactTextInputLocalData = this.localData;
            if (reactTextInputLocalData != null) {
                reactTextInputLocalData.apply(editText2);
            }
        } else {
            editText2.setTextSize(0, (float)this.mTextAttributes.getEffectiveFontSize());
            if (this.mNumberOfLines != -1) {
                editText2.setLines(this.mNumberOfLines);
            }
            if (editText2.getBreakStrategy() != this.mTextBreakStrategy) {
                editText2.setBreakStrategy(this.mTextBreakStrategy);
            }
        }
        editText2.setHint((CharSequence)this.placeholder);
        editText2.measure(MeasureUtil.getMeasureSpec(width, widthMode), MeasureUtil.getMeasureSpec(height, heightMode));
        return YogaMeasureOutput.make(editText2.getMeasuredWidth(), editText2.getMeasuredHeight());
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public boolean isYogaLeafNode() {
        return true;
    }

    @Override
    public void setLocalData(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Assertions.assertCondition((boolean)(data instanceof ReactTextInputLocalData));
        this.localData = (ReactTextInputLocalData)data;
        this.dirty();
    }

    @ReactProp(name="mostRecentEventCount")
    public final void setMostRecentEventCount(int mostRecentEventCount) {
        this.mostRecentEventCount = mostRecentEventCount;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        var2_2 = textBreakStrategy;
        if (var2_2 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var2_2.hashCode()) {
            case 336871677: {
                if (var2_2.equals("highQuality")) {
                    tmp = 1;
                }
                break;
            }
            case -902286926: {
                if (var2_2.equals("simple")) {
                    tmp = 2;
                }
                break;
            }
            case -1924829944: {
                if (var2_2.equals("balanced")) {
                    tmp = 3;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: lbl-1000:
            // 2 sources

            {
                this.mTextBreakStrategy = 0;
                break;
            }
            case 1: {
                this.mTextBreakStrategy = 1;
                break;
            }
            case 3: {
                this.mTextBreakStrategy = 2;
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid textBreakStrategy: " + textBreakStrategy));
                this.mTextBreakStrategy = 0;
            }
        }
    }

    @Override
    public void onCollectExtraUpdates(@NotNull UIViewOperationQueue uiViewOperationQueue) {
        Intrinsics.checkNotNullParameter((Object)uiViewOperationQueue, (String)"uiViewOperationQueue");
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mostRecentEventCount != -1) {
            Spannable spannable = this.spannedFromShadowNode(this, this.text, false, null);
            Intrinsics.checkNotNullExpressionValue((Object)spannable, (String)"spannedFromShadowNode(...)");
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(spannable, this.mostRecentEventCount, this.mContainsImages, this.getPadding(0), this.getPadding(1), this.getPadding(2), this.getPadding(3), this.mTextAlign, this.mTextBreakStrategy, this.mJustificationMode);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.markUpdated();
    }

    private final EditText createInternalEditText() {
        ContextThemeWrapper context = new ContextThemeWrapper((Context)this.getThemedContext(), R.style.Theme_ReactNative_TextInput_DefaultBackground);
        return new EditText((Context)context);
    }

    @JvmOverloads
    public ReactTextInputShadowNode() {
        this(null, 1, null);
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("ReactTextInputShadowNode", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/views/textinput/ReactTextInputShadowNode$Companion;", "", "<init>", "()V", "PROP_TEXT", "", "PROP_PLACEHOLDER", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

