/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.text.FontMetricsUtil;
import com.facebook.react.views.text.PreparedLayout;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextTransform;
import com.facebook.react.views.text.internal.span.CustomLetterSpacingSpan;
import com.facebook.react.views.text.internal.span.CustomLineHeightSpan;
import com.facebook.react.views.text.internal.span.CustomStyleSpan;
import com.facebook.react.views.text.internal.span.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.internal.span.ReactBackgroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactClickableSpan;
import com.facebook.react.views.text.internal.span.ReactForegroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactOpacitySpan;
import com.facebook.react.views.text.internal.span.ReactStrikethroughSpan;
import com.facebook.react.views.text.internal.span.ReactTagSpan;
import com.facebook.react.views.text.internal.span.ReactTextPaintHolderSpan;
import com.facebook.react.views.text.internal.span.ReactUnderlineSpan;
import com.facebook.react.views.text.internal.span.SetSpanOperation;
import com.facebook.react.views.text.internal.span.ShadowStyleSpan;
import com.facebook.react.views.text.internal.span.TextInlineViewPlaceholderSpan;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002yzB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020#J\u000e\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+J\u0012\u0010,\u001a\u0004\u0018\u00010\u001a2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020+2\u0006\u00101\u001a\u00020#2\b\u0010.\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u00102\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+2\u0006\u00101\u001a\u00020#H\u0007J.\u00103\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020+2\u0006\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0018\u0010<\u001a\u00020#2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020+H\u0002J \u0010=\u001a\u00020#2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+2\b\u0010>\u001a\u0004\u0018\u00010?J\"\u0010@\u001a\u00020#2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002Jl\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020#2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020\u00052\b\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u001dH\u0002J \u0010S\u001a\u00020%2\u0006\u0010R\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020U2\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010V\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020U2\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010W\u001a\u00020\u001d2\u0006\u0010T\u001a\u00020U2\u0006\u00104\u001a\u000205H\u0002JJ\u0010X\u001a\u00020B2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+2\u0006\u0010Y\u001a\u00020+2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020I2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002JH\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020#2\u0006\u0010R\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010Y\u001a\u00020+2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020IH\u0002JJ\u0010\\\u001a\u00020]2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020^2\u0006\u0010Y\u001a\u00020^2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020I2\b\u0010>\u001a\u0004\u0018\u00010?H\u0007Jp\u0010_\u001a\u00020%2\u0006\u0010C\u001a\u00020#2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020I2\u0006\u0010`\u001a\u00020G2\u0006\u0010a\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u001dH\u0007JT\u0010b\u001a\u00020c2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+2\u0006\u0010Y\u001a\u00020+2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020I2\b\u0010>\u001a\u0004\u0018\u00010?2\b\u0010d\u001a\u0004\u0018\u00010eH\u0007J0\u0010f\u001a\u00020e2\u0006\u0010g\u001a\u00020]2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020IH\u0007J0\u0010h\u001a\u00020G2\u0006\u0010i\u001a\u00020B2\u0006\u0010Y\u001a\u00020^2\u0006\u0010Z\u001a\u00020G2\u0006\u0010j\u001a\u00020I2\u0006\u0010a\u001a\u00020\u0005H\u0002J\u0018\u0010k\u001a\u00020\u00052\u0006\u0010i\u001a\u00020B2\u0006\u0010a\u001a\u00020\u0005H\u0002J0\u0010l\u001a\u00020G2\u0006\u0010i\u001a\u00020B2\u0006\u0010C\u001a\u00020m2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010n\u001a\u00020\u0005H\u0002J(\u0010o\u001a\u00020G2\u0006\u0010i\u001a\u00020B2\u0006\u0010Z\u001a\u00020G2\u0006\u0010[\u001a\u00020I2\u0006\u0010n\u001a\u00020\u0005H\u0002J@\u0010p\u001a\u00020\u00052\u0006\u0010i\u001a\u00020B2\u0006\u0010C\u001a\u00020m2\u0006\u0010q\u001a\u00020G2\u0006\u0010n\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\u00052\u0006\u0010s\u001a\u00020G2\u0006\u0010t\u001a\u00020uH\u0002J:\u0010v\u001a\u00020w2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020+2\u0006\u0010Y\u001a\u00020+2\u0006\u0010F\u001a\u00020G2\u0006\u0010Z\u001a\u00020G2\b\u0010>\u001a\u0004\u0018\u00010?H\u0007J\u001a\u0010x\u001a\u0004\u0018\u00010E2\u0006\u0010C\u001a\u00020#2\u0006\u0010R\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lcom/facebook/react/views/text/TextLayoutManager;", "", "<init>", "()V", "AS_KEY_HASH", "", "AS_KEY_STRING", "AS_KEY_FRAGMENTS", "AS_KEY_CACHE_ID", "AS_KEY_BASE_ATTRIBUTES", "FR_KEY_STRING", "FR_KEY_REACT_TAG", "FR_KEY_IS_ATTACHMENT", "FR_KEY_WIDTH", "FR_KEY_HEIGHT", "FR_KEY_TEXT_ATTRIBUTES", "PA_KEY_MAX_NUMBER_OF_LINES", "PA_KEY_ELLIPSIZE_MODE", "PA_KEY_TEXT_BREAK_STRATEGY", "PA_KEY_ADJUST_FONT_SIZE_TO_FIT", "PA_KEY_INCLUDE_FONT_PADDING", "PA_KEY_HYPHENATION_FREQUENCY", "PA_KEY_MINIMUM_FONT_SIZE", "PA_KEY_MAXIMUM_FONT_SIZE", "PA_KEY_TEXT_ALIGN_VERTICAL", "TAG", "", "textPaintInstance", "Ljava/lang/ThreadLocal;", "Landroid/text/TextPaint;", "DEFAULT_INCLUDE_FONT_PADDING", "", "DEFAULT_ADJUST_FONT_SIZE_TO_FIT", "tagToSpannableCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Landroid/text/Spannable;", "setCachedSpannableForTag", "", "reactTag", "sp", "deleteCachedSpannableForTag", "isRTL", "attributedString", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "getTextAlignmentAttr", "getTextJustificationMode", "alignmentAttr", "getTextAlignment", "Landroid/text/Layout$Alignment;", "spanned", "getTextGravity", "buildSpannableFromFragments", "context", "Landroid/content/Context;", "fragments", "sb", "Landroid/text/SpannableStringBuilder;", "ops", "", "Lcom/facebook/react/views/text/internal/span/SetSpanOperation;", "buildSpannableFromFragmentsOptimized", "getOrCreateSpannableForText", "reactTextViewManagerCallback", "Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "createSpannableFromAttributedString", "createLayout", "Landroid/text/Layout;", "text", "boring", "Landroid/text/BoringLayout$Metrics;", "width", "", "widthYogaMeasureMode", "Lcom/facebook/yoga/YogaMeasureMode;", "includeFontPadding", "textBreakStrategy", "hyphenationFrequency", "alignment", "justificationMode", "ellipsizeMode", "Landroid/text/TextUtils$TruncateAt;", "maxNumberOfLines", "paint", "updateTextPaint", "baseTextAttributes", "Lcom/facebook/react/views/text/TextAttributeProps;", "scratchPaintWithAttributes", "newPaintWithAttributes", "createLayoutForMeasurement", "paragraphAttributes", "height", "heightYogaMeasureMode", "createPreparedLayout", "Lcom/facebook/react/views/text/PreparedLayout;", "Lcom/facebook/react/common/mapbuffer/ReadableMapBuffer;", "adjustSpannableFontToFit", "minimumFontSizeAttr", "maximumNumberOfLines", "measureText", "", "attachmentsPositions", "", "measurePreparedLayout", "preparedLayout", "getVerticalOffset", "layout", "heightMeasureMode", "calculateLineCount", "calculateWidth", "Landroid/text/Spanned;", "calculatedLineCount", "calculateHeight", "nextAttachmentMetrics", "calculatedWidth", "i", "verticalOffset", "metrics", "Lcom/facebook/react/views/text/TextLayoutManager$AttachmentMetrics;", "measureLines", "Lcom/facebook/react/bridge/WritableArray;", "isBoring", "FragmentAttributes", "AttachmentMetrics", "ReactAndroid_release"})
public final class TextLayoutManager {
    @NotNull
    public static final TextLayoutManager INSTANCE = new TextLayoutManager();
    public static final int AS_KEY_HASH = 0;
    public static final int AS_KEY_STRING = 1;
    public static final int AS_KEY_FRAGMENTS = 2;
    public static final int AS_KEY_CACHE_ID = 3;
    public static final int AS_KEY_BASE_ATTRIBUTES = 4;
    public static final int FR_KEY_STRING = 0;
    public static final int FR_KEY_REACT_TAG = 1;
    public static final int FR_KEY_IS_ATTACHMENT = 2;
    public static final int FR_KEY_WIDTH = 3;
    public static final int FR_KEY_HEIGHT = 4;
    public static final int FR_KEY_TEXT_ATTRIBUTES = 5;
    public static final int PA_KEY_MAX_NUMBER_OF_LINES = 0;
    public static final int PA_KEY_ELLIPSIZE_MODE = 1;
    public static final int PA_KEY_TEXT_BREAK_STRATEGY = 2;
    public static final int PA_KEY_ADJUST_FONT_SIZE_TO_FIT = 3;
    public static final int PA_KEY_INCLUDE_FONT_PADDING = 4;
    public static final int PA_KEY_HYPHENATION_FREQUENCY = 5;
    public static final int PA_KEY_MINIMUM_FONT_SIZE = 6;
    public static final int PA_KEY_MAXIMUM_FONT_SIZE = 7;
    public static final int PA_KEY_TEXT_ALIGN_VERTICAL = 8;
    @NotNull
    private static final String TAG;
    @NotNull
    private static final ThreadLocal<TextPaint> textPaintInstance;
    private static final boolean DEFAULT_INCLUDE_FONT_PADDING = true;
    private static final boolean DEFAULT_ADJUST_FONT_SIZE_TO_FIT = false;
    @NotNull
    private static final ConcurrentHashMap<Integer, Spannable> tagToSpannableCache;

    private TextLayoutManager() {
    }

    public final void setCachedSpannableForTag(int reactTag, @NotNull Spannable sp) {
        Intrinsics.checkNotNullParameter((Object)sp, (String)"sp");
        Integer n = reactTag;
        ((Map)tagToSpannableCache).put(n, sp);
    }

    public final void deleteCachedSpannableForTag(int reactTag) {
        tagToSpannableCache.remove(reactTag);
    }

    public final boolean isRTL(@NotNull MapBuffer attributedString) {
        Intrinsics.checkNotNullParameter((Object)attributedString, (String)"attributedString");
        if (!attributedString.contains(2)) {
            return false;
        }
        MapBuffer fragments = attributedString.getMapBuffer(2);
        if (fragments.getCount() == 0) {
            return false;
        }
        MapBuffer fragment = fragments.getMapBuffer(0);
        MapBuffer textAttributes = fragment.getMapBuffer(5);
        if (!textAttributes.contains(23)) {
            return false;
        }
        return TextAttributeProps.getLayoutDirection(textAttributes.getString(23)) == 1;
    }

    private final String getTextAlignmentAttr(MapBuffer attributedString) {
        MapBuffer fragment;
        MapBuffer textAttributes;
        if (!attributedString.contains(2)) {
            return null;
        }
        MapBuffer fragments = attributedString.getMapBuffer(2);
        if (fragments.getCount() != 0 && (textAttributes = (fragment = fragments.getMapBuffer(0)).getMapBuffer(5)).contains(12)) {
            return textAttributes.getString(12);
        }
        return null;
    }

    private final int getTextJustificationMode(String alignmentAttr) {
        if (Build.VERSION.SDK_INT < 26) {
            return -1;
        }
        if (alignmentAttr != null && Intrinsics.areEqual((Object)alignmentAttr, (Object)"justified")) {
            return 1;
        }
        return 0;
    }

    private final Layout.Alignment getTextAlignment(MapBuffer attributedString, Spannable spanned, String alignmentAttr) {
        Layout.Alignment alignment;
        boolean isScriptRTL;
        boolean isParagraphRTL = this.isRTL(attributedString);
        boolean swapNormalAndOpposite = isParagraphRTL != (isScriptRTL = TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl((CharSequence)spanned, 0, spanned.length()));
        Layout.Alignment alignment2 = alignment = swapNormalAndOpposite ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL;
        if (alignmentAttr == null) {
            return alignment;
        }
        if (Intrinsics.areEqual((Object)alignmentAttr, (Object)"center")) {
            alignment = Layout.Alignment.ALIGN_CENTER;
        } else if (Intrinsics.areEqual((Object)alignmentAttr, (Object)"right")) {
            alignment = swapNormalAndOpposite ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_OPPOSITE;
        }
        return alignment;
    }

    @JvmStatic
    public static final int getTextGravity(@NotNull MapBuffer attributedString, @NotNull Spannable spanned) {
        Intrinsics.checkNotNullParameter((Object)attributedString, (String)"attributedString");
        Intrinsics.checkNotNullParameter((Object)spanned, (String)"spanned");
        String alignmentAttr = INSTANCE.getTextAlignmentAttr(attributedString);
        Layout.Alignment alignment = INSTANCE.getTextAlignment(attributedString, spanned, alignmentAttr);
        boolean swapLeftAndRight = TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl((CharSequence)spanned, 0, spanned.length());
        return switch (WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
            case 1 -> {
                if (swapLeftAndRight) {
                    yield 5;
                }
                yield 3;
            }
            case 2 -> {
                if (swapLeftAndRight) {
                    yield 3;
                }
                yield 5;
            }
            case 3 -> 1;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void buildSpannableFromFragments(Context context, MapBuffer fragments, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int n = fragments.getCount();
        for (int i = 0; i < n; ++i) {
            boolean roleIsLink;
            int reactTag;
            TextAttributeProps textAttributes;
            MapBuffer fragment = fragments.getMapBuffer(i);
            int start = sb.length();
            Intrinsics.checkNotNullExpressionValue((Object)TextAttributeProps.fromMapBuffer(fragment.getMapBuffer(5)), (String)"fromMapBuffer(...)");
            sb.append((CharSequence)TextTransform.Companion.apply(fragment.getString(0), textAttributes.mTextTransform));
            int end = sb.length();
            int n2 = reactTag = fragment.contains(1) ? fragment.getInt(1) : -1;
            if (fragment.contains(2) && fragment.getBoolean(2)) {
                float width = PixelUtil.toPixelFromSP(fragment.getDouble(3));
                float height = PixelUtil.toPixelFromSP(fragment.getDouble(4));
                ops.add(new SetSpanOperation(sb.length() - 1, sb.length(), new TextInlineViewPlaceholderSpan(reactTag, (int)width, (int)height)));
                continue;
            }
            if (end < start) continue;
            boolean bl = textAttributes.mRole != null ? textAttributes.mRole == ReactAccessibilityDelegate.Role.LINK : (roleIsLink = textAttributes.mAccessibilityRole == ReactAccessibilityDelegate.AccessibilityRole.LINK);
            if (roleIsLink) {
                ops.add(new SetSpanOperation(start, end, new ReactClickableSpan(reactTag)));
            }
            if (textAttributes.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactForegroundColorSpan(textAttributes.mColor)));
            }
            if (textAttributes.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactBackgroundColorSpan(textAttributes.mBackgroundColor)));
            }
            if (!Float.isNaN(textAttributes.getOpacity())) {
                ops.add(new SetSpanOperation(start, end, new ReactOpacitySpan(textAttributes.getOpacity())));
            }
            if (!Float.isNaN(textAttributes.getLetterSpacing())) {
                ops.add(new SetSpanOperation(start, end, new CustomLetterSpacingSpan(textAttributes.getLetterSpacing())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactAbsoluteSizeSpan(textAttributes.mFontSize)));
            if (textAttributes.mFontStyle != -1 || textAttributes.mFontWeight != -1 || textAttributes.mFontFamily != null) {
                int n3 = textAttributes.mFontStyle;
                int n4 = textAttributes.mFontWeight;
                String string2 = textAttributes.mFontFeatureSettings;
                String string3 = textAttributes.mFontFamily;
                AssetManager assetManager = context.getAssets();
                Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
                ops.add(new SetSpanOperation(start, end, new CustomStyleSpan(n3, n4, string2, string3, assetManager)));
            }
            if (textAttributes.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactUnderlineSpan()));
            }
            if (textAttributes.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactStrikethroughSpan()));
            }
            if (!(textAttributes.mTextShadowOffsetDx == 0.0f && textAttributes.mTextShadowOffsetDy == 0.0f && textAttributes.mTextShadowRadius == 0.0f || Color.alpha((int)textAttributes.mTextShadowColor) == 0)) {
                ops.add(new SetSpanOperation(start, end, new ShadowStyleSpan(textAttributes.mTextShadowOffsetDx, textAttributes.mTextShadowOffsetDy, textAttributes.mTextShadowRadius, textAttributes.mTextShadowColor)));
            }
            if (!Float.isNaN(textAttributes.getEffectiveLineHeight())) {
                ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(textAttributes.getEffectiveLineHeight())));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(reactTag)));
        }
    }

    private final Spannable buildSpannableFromFragmentsOptimized(Context context, MapBuffer fragments) {
        StringBuilder text = new StringBuilder();
        ArrayList<FragmentAttributes> parsedFragments = new ArrayList<FragmentAttributes>(fragments.getCount());
        int n = fragments.getCount();
        for (int i = 0; i < n; ++i) {
            TextAttributeProps props;
            MapBuffer fragment = fragments.getMapBuffer(i);
            Intrinsics.checkNotNullExpressionValue((Object)TextAttributeProps.fromMapBuffer(fragment.getMapBuffer(5)), (String)"fromMapBuffer(...)");
            String fragmentText = TextTransform.Companion.apply(fragment.getString(0), props.getTextTransform());
            text.append(fragmentText);
            parsedFragments.add(new FragmentAttributes(props, fragmentText.length(), fragment.contains(1) ? fragment.getInt(1) : -1, fragment.contains(2) && fragment.getBoolean(2), fragment.contains(3) ? fragment.getDouble(3) : Double.NaN, fragment.contains(4) ? fragment.getDouble(4) : Double.NaN));
        }
        SpannableString spannable = new SpannableString((CharSequence)text);
        int start = 0;
        Iterator iterator2 = parsedFragments.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            int spanFlags;
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FragmentAttributes fragment = (FragmentAttributes)e;
            int end = start + fragment.getLength();
            int n2 = spanFlags = start == 0 ? 18 : 34;
            if (fragment.isAttachment()) {
                spannable.setSpan((Object)new TextInlineViewPlaceholderSpan(fragment.getReactTag(), (int)PixelUtil.toPixelFromSP(fragment.getWidth()), (int)PixelUtil.toPixelFromSP(fragment.getHeight())), start, end, spanFlags);
            } else {
                boolean roleIsLink;
                boolean bl = fragment.getProps().getRole() != null ? fragment.getProps().getRole() == ReactAccessibilityDelegate.Role.LINK : (roleIsLink = fragment.getProps().getAccessibilityRole() == ReactAccessibilityDelegate.AccessibilityRole.LINK);
                if (roleIsLink) {
                    spannable.setSpan((Object)new ReactClickableSpan(fragment.getReactTag()), start, end, spanFlags);
                }
                if (fragment.getProps().isColorSet()) {
                    spannable.setSpan((Object)new ReactForegroundColorSpan(fragment.getProps().getColor()), start, end, spanFlags);
                }
                if (fragment.getProps().isBackgroundColorSet()) {
                    spannable.setSpan((Object)new ReactBackgroundColorSpan(fragment.getProps().getBackgroundColor()), start, end, spanFlags);
                }
                if (!Float.isNaN(fragment.getProps().getOpacity())) {
                    spannable.setSpan((Object)new ReactOpacitySpan(fragment.getProps().getOpacity()), start, end, spanFlags);
                }
                if (!Float.isNaN(fragment.getProps().getLetterSpacing())) {
                    spannable.setSpan((Object)new CustomLetterSpacingSpan(fragment.getProps().getLetterSpacing()), start, end, spanFlags);
                }
                spannable.setSpan((Object)new ReactAbsoluteSizeSpan(fragment.getProps().mFontSize), start, end, spanFlags);
                if (fragment.getProps().getFontStyle() != -1 || fragment.getProps().getFontWeight() != -1 || fragment.getProps().getFontFamily() != null) {
                    int n3 = fragment.getProps().getFontStyle();
                    int n4 = fragment.getProps().getFontWeight();
                    String string2 = fragment.getProps().getFontFeatureSettings();
                    String string3 = fragment.getProps().getFontFamily();
                    AssetManager assetManager = context.getAssets();
                    Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
                    spannable.setSpan((Object)new CustomStyleSpan(n3, n4, string2, string3, assetManager), start, end, spanFlags);
                }
                if (fragment.getProps().isUnderlineTextDecorationSet()) {
                    spannable.setSpan((Object)new ReactUnderlineSpan(), start, end, spanFlags);
                }
                if (fragment.getProps().isLineThroughTextDecorationSet()) {
                    spannable.setSpan((Object)new ReactStrikethroughSpan(), start, end, spanFlags);
                }
                if (!(fragment.getProps().getTextShadowOffsetDx() == 0.0f && fragment.getProps().getTextShadowOffsetDy() == 0.0f && fragment.getProps().getTextShadowRadius() == 0.0f || Color.alpha((int)fragment.getProps().getTextShadowColor()) == 0)) {
                    spannable.setSpan((Object)new ShadowStyleSpan(fragment.getProps().getTextShadowOffsetDx(), fragment.getProps().getTextShadowOffsetDy(), fragment.getProps().getTextShadowRadius(), fragment.getProps().getTextShadowColor()), start, end, spanFlags);
                }
                if (!Float.isNaN(fragment.getProps().getEffectiveLineHeight())) {
                    spannable.setSpan((Object)new CustomLineHeightSpan(fragment.getProps().getEffectiveLineHeight()), start, end, spanFlags);
                }
                spannable.setSpan((Object)new ReactTagSpan(fragment.getReactTag()), start, end, spanFlags);
            }
            start = end;
        }
        return (Spannable)spannable;
    }

    @NotNull
    public final Spannable getOrCreateSpannableForText(@NotNull Context context, @NotNull MapBuffer attributedString, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributedString, (String)"attributedString");
        Spannable text = null;
        if (attributedString.contains(3)) {
            int cacheId = attributedString.getInt(3);
            Spannable spannable = tagToSpannableCache.get(cacheId);
            if (spannable == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            text = spannable;
        } else {
            text = this.createSpannableFromAttributedString(context, attributedString, reactTextViewManagerCallback);
        }
        return text;
    }

    private final Spannable createSpannableFromAttributedString(Context context, MapBuffer attributedString, ReactTextViewManagerCallback reactTextViewManagerCallback) {
        SpannableStringBuilder sb;
        block3: {
            if (ReactNativeFeatureFlags.enableAndroidTextMeasurementOptimizations()) {
                Spannable spannable = this.buildSpannableFromFragmentsOptimized(context, attributedString.getMapBuffer(2));
                ReactTextViewManagerCallback reactTextViewManagerCallback2 = reactTextViewManagerCallback;
                if (reactTextViewManagerCallback2 != null) {
                    reactTextViewManagerCallback2.onPostProcessSpannable(spannable);
                }
                return spannable;
            }
            sb = new SpannableStringBuilder();
            List ops = new ArrayList();
            this.buildSpannableFromFragments(context, attributedString.getMapBuffer(2), sb, ops);
            int n = ((Collection)ops).size();
            for (int priorityIndex = 0; priorityIndex < n; ++priorityIndex) {
                SetSpanOperation op = (SetSpanOperation)ops.get(ops.size() - priorityIndex - 1);
                op.execute(sb, priorityIndex);
            }
            ReactTextViewManagerCallback reactTextViewManagerCallback3 = reactTextViewManagerCallback;
            if (reactTextViewManagerCallback3 == null) break block3;
            reactTextViewManagerCallback3.onPostProcessSpannable((Spannable)sb);
        }
        return (Spannable)sb;
    }

    private final Layout createLayout(Spannable text, BoringLayout.Metrics boring, float width, YogaMeasureMode widthYogaMeasureMode, boolean includeFontPadding, int textBreakStrategy, int hyphenationFrequency, Layout.Alignment alignment, int justificationMode, TextUtils.TruncateAt ellipsizeMode, int maxNumberOfLines, TextPaint paint) {
        if (boring != null && (widthYogaMeasureMode == YogaMeasureMode.UNDEFINED || (float)boring.width <= (float)Math.floor(width))) {
            int layoutWidth = widthYogaMeasureMode == YogaMeasureMode.EXACTLY ? (int)Math.floor(width) : boring.width;
            BoringLayout boringLayout = BoringLayout.make((CharSequence)((CharSequence)text), (TextPaint)paint, (int)layoutWidth, (Layout.Alignment)alignment, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)includeFontPadding);
            Intrinsics.checkNotNullExpressionValue((Object)boringLayout, (String)"make(...)");
            return (Layout)boringLayout;
        }
        int desiredWidth = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)((CharSequence)text), (TextPaint)paint));
        int layoutWidth = switch (WhenMappings.$EnumSwitchMapping$1[widthYogaMeasureMode.ordinal()]) {
            case 1 -> (int)Math.floor(width);
            case 2 -> Math.min(desiredWidth, (int)Math.floor(width));
            default -> desiredWidth;
        };
        StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)((CharSequence)text), (int)0, (int)text.length(), (TextPaint)paint, (int)layoutWidth).setAlignment(alignment).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(textBreakStrategy).setHyphenationFrequency(hyphenationFrequency);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setHyphenationFrequency(...)");
        StaticLayout.Builder builder2 = builder;
        if (maxNumberOfLines != -1 && maxNumberOfLines != 0) {
            builder2.setEllipsize(ellipsizeMode).setMaxLines(maxNumberOfLines);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            builder2.setJustificationMode(justificationMode);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            builder2.setUseLineSpacingFromFallbacks(true);
        }
        StaticLayout staticLayout = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)staticLayout, (String)"build(...)");
        return (Layout)staticLayout;
    }

    private final void updateTextPaint(TextPaint paint, TextAttributeProps baseTextAttributes, Context context) {
        if (baseTextAttributes.getEffectiveFontSize() != -1) {
            paint.setTextSize((float)baseTextAttributes.getEffectiveFontSize());
        }
        if (baseTextAttributes.getFontStyle() != -1 || baseTextAttributes.getFontWeight() != -1 || baseTextAttributes.getFontFamily() != null) {
            int n = baseTextAttributes.getFontStyle();
            int n2 = baseTextAttributes.getFontWeight();
            String string2 = baseTextAttributes.getFontFamily();
            AssetManager assetManager = context.getAssets();
            Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
            Typeface typeface = ReactTypefaceUtils.applyStyles(null, n, n2, string2, assetManager);
            paint.setTypeface(typeface);
            if (baseTextAttributes.getFontStyle() != -1 && baseTextAttributes.getFontStyle() != typeface.getStyle()) {
                int missingStyle = baseTextAttributes.getFontStyle() & ~typeface.getStyle();
                paint.setFakeBoldText((missingStyle & 1) != 0);
                paint.setTextSkewX((missingStyle & 2) != 0 ? -0.25f : 0.0f);
            }
        }
    }

    private final TextPaint scratchPaintWithAttributes(TextAttributeProps baseTextAttributes, Context context) {
        TextPaint textPaint = textPaintInstance.get();
        if (textPaint == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        TextPaint paint = textPaint;
        paint.setTypeface(null);
        paint.setTextSize(12.0f);
        paint.setFakeBoldText(false);
        paint.setTextSkewX(0.0f);
        this.updateTextPaint(paint, baseTextAttributes, context);
        return paint;
    }

    private final TextPaint newPaintWithAttributes(TextAttributeProps baseTextAttributes, Context context) {
        TextPaint paint = new TextPaint(1);
        this.updateTextPaint(paint, baseTextAttributes, context);
        return paint;
    }

    private final Layout createLayoutForMeasurement(Context context, MapBuffer attributedString, MapBuffer paragraphAttributes, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode, ReactTextViewManagerCallback reactTextViewManagerCallback) {
        Spannable text = this.getOrCreateSpannableForText(context, attributedString, reactTextViewManagerCallback);
        TextPaint paint = null;
        if (attributedString.contains(3)) {
            paint = ((ReactTextPaintHolderSpan[])text.getSpans(0, 0, ReactTextPaintHolderSpan.class))[0].getTextPaint();
        } else {
            TextAttributeProps textAttributeProps = TextAttributeProps.fromMapBuffer(attributedString.getMapBuffer(4));
            Intrinsics.checkNotNullExpressionValue((Object)textAttributeProps, (String)"fromMapBuffer(...)");
            TextAttributeProps baseTextAttributes = textAttributeProps;
            paint = this.scratchPaintWithAttributes(baseTextAttributes, context);
        }
        return this.createLayout(text, paint, attributedString, paragraphAttributes, width, widthYogaMeasureMode, height, heightYogaMeasureMode);
    }

    private final Layout createLayout(Spannable text, TextPaint paint, MapBuffer attributedString, MapBuffer paragraphAttributes, float width, YogaMeasureMode widthYogaMeasureMode, float height, YogaMeasureMode heightYogaMeasureMode) {
        BoringLayout.Metrics boring = this.isBoring(text, paint);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        boolean includeFontPadding = paragraphAttributes.contains(4) ? paragraphAttributes.getBoolean(4) : true;
        int hyphenationFrequency = TextAttributeProps.getHyphenationFrequency(paragraphAttributes.getString(5));
        boolean adjustFontSizeToFit = paragraphAttributes.contains(3) ? paragraphAttributes.getBoolean(3) : false;
        int maximumNumberOfLines = paragraphAttributes.contains(0) ? paragraphAttributes.getInt(0) : -1;
        TextUtils.TruncateAt ellipsizeMode = paragraphAttributes.contains(1) ? TextAttributeProps.getEllipsizeMode(paragraphAttributes.getString(1)) : null;
        String alignmentAttr = this.getTextAlignmentAttr(attributedString);
        Layout.Alignment alignment = this.getTextAlignment(attributedString, text, alignmentAttr);
        int justificationMode = this.getTextJustificationMode(alignmentAttr);
        if (adjustFontSizeToFit) {
            float minimumFontSize = paragraphAttributes.contains(6) ? (float)paragraphAttributes.getDouble(6) : Float.NaN;
            TextLayoutManager.adjustSpannableFontToFit(text, width, YogaMeasureMode.EXACTLY, height, heightYogaMeasureMode, minimumFontSize, maximumNumberOfLines, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, paint);
        }
        return this.createLayout(text, boring, width, widthYogaMeasureMode, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, ellipsizeMode, maximumNumberOfLines, paint);
    }

    @JvmStatic
    @NotNull
    public static final PreparedLayout createPreparedLayout(@NotNull Context context, @NotNull ReadableMapBuffer attributedString, @NotNull ReadableMapBuffer paragraphAttributes, float width, @NotNull YogaMeasureMode widthYogaMeasureMode, float height, @NotNull YogaMeasureMode heightYogaMeasureMode, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributedString, (String)"attributedString");
        Intrinsics.checkNotNullParameter((Object)paragraphAttributes, (String)"paragraphAttributes");
        Intrinsics.checkNotNullParameter((Object)((Object)widthYogaMeasureMode), (String)"widthYogaMeasureMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightYogaMeasureMode), (String)"heightYogaMeasureMode");
        Spannable text = INSTANCE.getOrCreateSpannableForText(context, attributedString, reactTextViewManagerCallback);
        TextAttributeProps textAttributeProps = TextAttributeProps.fromMapBuffer(attributedString.getMapBuffer(4));
        Intrinsics.checkNotNullExpressionValue((Object)textAttributeProps, (String)"fromMapBuffer(...)");
        TextAttributeProps baseTextAttributes = textAttributeProps;
        Layout layout2 = INSTANCE.createLayout(text, INSTANCE.newPaintWithAttributes(baseTextAttributes, context), attributedString, paragraphAttributes, width, widthYogaMeasureMode, height, heightYogaMeasureMode);
        int maximumNumberOfLines = paragraphAttributes.contains(0) ? paragraphAttributes.getInt(0) : -1;
        float verticalOffset = INSTANCE.getVerticalOffset(layout2, paragraphAttributes, height, heightYogaMeasureMode, maximumNumberOfLines);
        return new PreparedLayout(layout2, maximumNumberOfLines, verticalOffset);
    }

    @JvmStatic
    public static final void adjustSpannableFontToFit(@NotNull Spannable text, float width, @NotNull YogaMeasureMode widthYogaMeasureMode, float height, @NotNull YogaMeasureMode heightYogaMeasureMode, float minimumFontSizeAttr, int maximumNumberOfLines, boolean includeFontPadding, int textBreakStrategy, int hyphenationFrequency, @NotNull Layout.Alignment alignment, int justificationMode, @NotNull TextPaint paint) {
        int minimumFontSize;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)widthYogaMeasureMode), (String)"widthYogaMeasureMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightYogaMeasureMode), (String)"heightYogaMeasureMode");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        BoringLayout.Metrics boring = INSTANCE.isBoring(text, paint);
        Layout layout2 = INSTANCE.createLayout(text, boring, width, widthYogaMeasureMode, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, null, -1, paint);
        int currentFontSize = minimumFontSize = (int)(Float.isNaN(minimumFontSizeAttr) ? PixelUtil.INSTANCE.dpToPx(4) : minimumFontSizeAttr);
        Object[] spans = (ReactAbsoluteSizeSpan[])text.getSpans(0, text.length(), ReactAbsoluteSizeSpan.class);
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])spans);
        while (iterator2.hasNext()) {
            ReactAbsoluteSizeSpan span = (ReactAbsoluteSizeSpan)iterator2.next();
            currentFontSize = Math.max(currentFontSize, span.getSize());
        }
        int initialFontSize = currentFontSize;
        while (currentFontSize > minimumFontSize && (maximumNumberOfLines != -1 && maximumNumberOfLines != 0 && layout2.getLineCount() > maximumNumberOfLines || heightYogaMeasureMode != YogaMeasureMode.UNDEFINED && (float)layout2.getHeight() > height || text.length() == 1 && layout2.getLineWidth(0) > width)) {
            float ratio = (float)(currentFontSize -= Math.max(1, (int)PixelUtil.INSTANCE.dpToPx(1))) / (float)initialFontSize;
            paint.setTextSize((float)Math.max((int)(paint.getTextSize() * ratio), minimumFontSize));
            Object[] sizeSpans = (ReactAbsoluteSizeSpan[])text.getSpans(0, text.length(), ReactAbsoluteSizeSpan.class);
            Iterator iterator3 = ArrayIteratorKt.iterator((Object[])sizeSpans);
            while (iterator3.hasNext()) {
                ReactAbsoluteSizeSpan span = (ReactAbsoluteSizeSpan)iterator3.next();
                text.setSpan((Object)new ReactAbsoluteSizeSpan(Math.max((int)((float)span.getSize() * ratio), minimumFontSize)), text.getSpanStart((Object)span), text.getSpanEnd((Object)span), text.getSpanFlags((Object)span));
                text.removeSpan((Object)span);
            }
            if (boring != null) {
                boring = INSTANCE.isBoring(text, paint);
            }
            layout2 = INSTANCE.createLayout(text, boring, width, widthYogaMeasureMode, includeFontPadding, textBreakStrategy, hyphenationFrequency, alignment, justificationMode, null, -1, paint);
        }
    }

    @JvmStatic
    public static final long measureText(@NotNull Context context, @NotNull MapBuffer attributedString, @NotNull MapBuffer paragraphAttributes, float width, @NotNull YogaMeasureMode widthYogaMeasureMode, float height, @NotNull YogaMeasureMode heightYogaMeasureMode, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback, @Nullable float[] attachmentsPositions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributedString, (String)"attributedString");
        Intrinsics.checkNotNullParameter((Object)paragraphAttributes, (String)"paragraphAttributes");
        Intrinsics.checkNotNullParameter((Object)((Object)widthYogaMeasureMode), (String)"widthYogaMeasureMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightYogaMeasureMode), (String)"heightYogaMeasureMode");
        Layout layout2 = INSTANCE.createLayoutForMeasurement(context, attributedString, paragraphAttributes, width, widthYogaMeasureMode, height, heightYogaMeasureMode, reactTextViewManagerCallback);
        int maximumNumberOfLines = paragraphAttributes.contains(0) ? paragraphAttributes.getInt(0) : -1;
        CharSequence charSequence = layout2.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        Spanned text = (Spanned)charSequence;
        int calculatedLineCount = INSTANCE.calculateLineCount(layout2, maximumNumberOfLines);
        float calculatedWidth = INSTANCE.calculateWidth(layout2, text, width, widthYogaMeasureMode, calculatedLineCount);
        float calculatedHeight = INSTANCE.calculateHeight(layout2, height, heightYogaMeasureMode, calculatedLineCount);
        if (attachmentsPositions != null) {
            int attachmentIndex = 0;
            int lastAttachmentFoundInSpan = 0;
            AttachmentMetrics metrics = new AttachmentMetrics();
            int i = 0;
            while (i < text.length()) {
                lastAttachmentFoundInSpan = INSTANCE.nextAttachmentMetrics(layout2, text, calculatedWidth, calculatedLineCount, i, 0.0f, metrics);
                if (metrics.getWasFound()) {
                    attachmentsPositions[attachmentIndex] = PixelUtil.INSTANCE.pxToDp(metrics.getTop());
                    attachmentsPositions[attachmentIndex + 1] = PixelUtil.INSTANCE.pxToDp(metrics.getLeft());
                    attachmentIndex += 2;
                }
                i = lastAttachmentFoundInSpan;
            }
        }
        float widthInSP = PixelUtil.INSTANCE.pxToDp(calculatedWidth);
        float heightInSP = PixelUtil.INSTANCE.pxToDp(calculatedHeight);
        return YogaMeasureOutput.make(widthInSP, heightInSP);
    }

    @JvmStatic
    @NotNull
    public static final float[] measurePreparedLayout(@NotNull PreparedLayout preparedLayout, float width, @NotNull YogaMeasureMode widthYogaMeasureMode, float height, @NotNull YogaMeasureMode heightYogaMeasureMode) {
        Intrinsics.checkNotNullParameter((Object)preparedLayout, (String)"preparedLayout");
        Intrinsics.checkNotNullParameter((Object)((Object)widthYogaMeasureMode), (String)"widthYogaMeasureMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightYogaMeasureMode), (String)"heightYogaMeasureMode");
        Layout layout2 = preparedLayout.getLayout();
        CharSequence charSequence = layout2.getText();
        Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
        Spanned text = (Spanned)charSequence;
        int maximumNumberOfLines = preparedLayout.getMaximumNumberOfLines();
        int calculatedLineCount = INSTANCE.calculateLineCount(layout2, maximumNumberOfLines);
        float calculatedWidth = INSTANCE.calculateWidth(layout2, text, width, widthYogaMeasureMode, calculatedLineCount);
        float calculatedHeight = INSTANCE.calculateHeight(layout2, height, heightYogaMeasureMode, calculatedLineCount);
        ArrayList<Float> retList = new ArrayList<Float>();
        retList.add(Float.valueOf(PixelUtil.INSTANCE.pxToDp(calculatedWidth)));
        retList.add(Float.valueOf(PixelUtil.INSTANCE.pxToDp(calculatedHeight)));
        AttachmentMetrics metrics = new AttachmentMetrics();
        int lastAttachmentFoundInSpan = 0;
        TextLayoutManager $this$measurePreparedLayout_u24lambda_u240 = INSTANCE;
        boolean bl = false;
        int i = 0;
        while (i < text.length()) {
            lastAttachmentFoundInSpan = $this$measurePreparedLayout_u24lambda_u240.nextAttachmentMetrics(layout2, text, calculatedWidth, calculatedLineCount, i, preparedLayout.getVerticalOffset(), metrics);
            if (metrics.getWasFound()) {
                retList.add(Float.valueOf(PixelUtil.INSTANCE.pxToDp(metrics.getTop())));
                retList.add(Float.valueOf(PixelUtil.INSTANCE.pxToDp(metrics.getLeft())));
                retList.add(Float.valueOf(PixelUtil.INSTANCE.pxToDp(metrics.getWidth())));
                retList.add(Float.valueOf(PixelUtil.INSTANCE.pxToDp(metrics.getHeight())));
            }
            i = lastAttachmentFoundInSpan;
        }
        float[] ret = new float[retList.size()];
        int n = ((Collection)retList).size();
        for (int i2 = 0; i2 < n; ++i2) {
            Object e = retList.get(i2);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            ret[i2] = ((Number)e).floatValue();
        }
        return ret;
    }

    private final float getVerticalOffset(Layout layout2, ReadableMapBuffer paragraphAttributes, float height, YogaMeasureMode heightMeasureMode, int maximumNumberOfLines) {
        int calculatedLineCount;
        float boxHeight;
        String textAlignVertical;
        String string2 = textAlignVertical = paragraphAttributes.contains(8) ? paragraphAttributes.getString(8) : null;
        if (textAlignVertical == null) {
            return 0.0f;
        }
        int textHeight = layout2.getHeight();
        if ((float)textHeight > (boxHeight = this.calculateHeight(layout2, height, heightMeasureMode, calculatedLineCount = this.calculateLineCount(layout2, maximumNumberOfLines)))) {
            return 0.0f;
        }
        switch (textAlignVertical) {
            case "auto": 
            case "top": {
                return 0.0f;
            }
            case "center": {
                return (boxHeight - (float)textHeight) / 2.0f;
            }
            case "bottom": {
                return boxHeight - (float)textHeight;
            }
        }
        FLog.w((String)"ReactNative", (String)("Invalid textAlignVertical: " + textAlignVertical));
        return 0.0f;
    }

    private final int calculateLineCount(Layout layout2, int maximumNumberOfLines) {
        return switch (maximumNumberOfLines) {
            case -1, 0 -> layout2.getLineCount();
            default -> Math.min(maximumNumberOfLines, layout2.getLineCount());
        };
    }

    private final float calculateWidth(Layout layout2, Spanned text, float width, YogaMeasureMode widthYogaMeasureMode, int calculatedLineCount) {
        if (widthYogaMeasureMode == YogaMeasureMode.EXACTLY) {
            return width;
        }
        return layout2.getWidth();
    }

    private final float calculateHeight(Layout layout2, float height, YogaMeasureMode heightYogaMeasureMode, int calculatedLineCount) {
        float calculatedHeight = height;
        if (heightYogaMeasureMode != YogaMeasureMode.EXACTLY) {
            calculatedHeight = layout2.getLineBottom(calculatedLineCount - 1);
            if (heightYogaMeasureMode == YogaMeasureMode.AT_MOST && calculatedHeight > height) {
                calculatedHeight = height;
            }
        }
        return calculatedHeight;
    }

    private final int nextAttachmentMetrics(Layout layout2, Spanned text, float calculatedWidth, int calculatedLineCount, int i, float verticalOffset, AttachmentMetrics metrics) {
        boolean isAttachmentTruncated;
        int lastAttachmentFoundInSpan = text.nextSpanTransition(i, text.length(), TextInlineViewPlaceholderSpan.class);
        TextInlineViewPlaceholderSpan[] placeholders = (TextInlineViewPlaceholderSpan[])text.getSpans(i, lastAttachmentFoundInSpan, TextInlineViewPlaceholderSpan.class);
        if (placeholders.length == 0) {
            metrics.setWasFound(false);
            return lastAttachmentFoundInSpan;
        }
        Assertions.assertCondition((placeholders.length == 1 ? 1 : 0) != 0);
        TextInlineViewPlaceholderSpan placeholder = placeholders[0];
        int start = text.getSpanStart((Object)placeholder);
        int line = layout2.getLineForOffset(start);
        boolean isLineTruncated = layout2.getEllipsisCount(line) > 0;
        boolean bl = isAttachmentTruncated = line > calculatedLineCount || isLineTruncated && start >= layout2.getLineStart(line) + layout2.getEllipsisStart(line);
        if (isAttachmentTruncated) {
            metrics.setTop(Float.NaN);
            metrics.setLeft(Float.NaN);
        } else {
            float placeholderWidth = placeholder.getWidth();
            float placeholderHeight = placeholder.getHeight();
            boolean isRtlChar = layout2.isRtlCharAt(start);
            boolean isRtlParagraph = layout2.getParagraphDirection(line) == -1;
            float placeholderLeftPosition = 0.0f;
            if (start == text.length() - 1) {
                boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(line) - 1) == '\n';
                float lineWidth = endsWithNewLine ? layout2.getLineMax(line) : layout2.getLineWidth(line);
                placeholderLeftPosition = isRtlParagraph ? calculatedWidth - lineWidth : layout2.getLineRight(line) - placeholderWidth;
            } else {
                boolean characterAndParagraphDirectionMatch = isRtlParagraph == isRtlChar;
                float f = placeholderLeftPosition = characterAndParagraphDirectionMatch ? layout2.getPrimaryHorizontal(start) : layout2.getSecondaryHorizontal(start);
                if (isRtlParagraph && !isRtlChar) {
                    placeholderLeftPosition = calculatedWidth - (layout2.getLineRight(line) - placeholderLeftPosition);
                }
                if (isRtlChar) {
                    placeholderLeftPosition -= placeholderWidth;
                }
            }
            float placeholderTopPosition = (float)layout2.getLineBaseline(line) - placeholderHeight;
            metrics.setTop(placeholderTopPosition);
            metrics.setLeft(placeholderLeftPosition);
        }
        metrics.setTop(metrics.getTop() + verticalOffset);
        metrics.setWasFound(true);
        metrics.setWidth(placeholder.getWidth());
        metrics.setHeight(placeholder.getHeight());
        return lastAttachmentFoundInSpan;
    }

    @JvmStatic
    @NotNull
    public static final WritableArray measureLines(@NotNull Context context, @NotNull MapBuffer attributedString, @NotNull MapBuffer paragraphAttributes, float width, float height, @Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributedString, (String)"attributedString");
        Intrinsics.checkNotNullParameter((Object)paragraphAttributes, (String)"paragraphAttributes");
        Layout layout2 = INSTANCE.createLayoutForMeasurement(context, attributedString, paragraphAttributes, width, YogaMeasureMode.EXACTLY, height, YogaMeasureMode.EXACTLY, reactTextViewManagerCallback);
        CharSequence charSequence = layout2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getText(...)");
        return FontMetricsUtil.getFontMetrics(charSequence, layout2, context);
    }

    private final BoringLayout.Metrics isBoring(Spannable text, TextPaint paint) {
        return Build.VERSION.SDK_INT < 33 ? BoringLayout.isBoring((CharSequence)((CharSequence)text), (TextPaint)paint) : BoringLayout.isBoring((CharSequence)((CharSequence)text), (TextPaint)paint, (TextDirectionHeuristic)TextDirectionHeuristics.FIRSTSTRONG_LTR, (boolean)true, null);
    }

    static {
        String string2 = TextLayoutManager.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
        textPaintInstance = new ThreadLocal<TextPaint>(){

            protected TextPaint initialValue() {
                return new TextPaint(1);
            }
        };
        tagToSpannableCache = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/views/text/TextLayoutManager$AttachmentMetrics;", "", "<init>", "()V", "wasFound", "", "getWasFound", "()Z", "setWasFound", "(Z)V", "top", "", "getTop", "()F", "setTop", "(F)V", "left", "getLeft", "setLeft", "width", "getWidth", "setWidth", "height", "getHeight", "setHeight", "ReactAndroid_release"})
    private static final class AttachmentMetrics {
        private boolean wasFound;
        private float top;
        private float left;
        private float width;
        private float height;

        public final boolean getWasFound() {
            return this.wasFound;
        }

        public final void setWasFound(boolean bl) {
            this.wasFound = bl;
        }

        public final float getTop() {
            return this.top;
        }

        public final void setTop(float f) {
            this.top = f;
        }

        public final float getLeft() {
            return this.left;
        }

        public final void setLeft(float f) {
            this.left = f;
        }

        public final float getWidth() {
            return this.width;
        }

        public final void setWidth(float f) {
            this.width = f;
        }

        public final float getHeight() {
            return this.height;
        }

        public final void setHeight(float f) {
            this.height = f;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/views/text/TextLayoutManager$FragmentAttributes;", "", "props", "Lcom/facebook/react/views/text/TextAttributeProps;", "length", "", "reactTag", "isAttachment", "", "width", "", "height", "<init>", "(Lcom/facebook/react/views/text/TextAttributeProps;IIZDD)V", "getProps", "()Lcom/facebook/react/views/text/TextAttributeProps;", "getLength", "()I", "getReactTag", "()Z", "getWidth", "()D", "getHeight", "ReactAndroid_release"})
    private static final class FragmentAttributes {
        @NotNull
        private final TextAttributeProps props;
        private final int length;
        private final int reactTag;
        private final boolean isAttachment;
        private final double width;
        private final double height;

        public FragmentAttributes(@NotNull TextAttributeProps props, int length, int reactTag, boolean isAttachment, double width, double height) {
            Intrinsics.checkNotNullParameter((Object)props, (String)"props");
            this.props = props;
            this.length = length;
            this.reactTag = reactTag;
            this.isAttachment = isAttachment;
            this.width = width;
            this.height = height;
        }

        @NotNull
        public final TextAttributeProps getProps() {
            return this.props;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getReactTag() {
            return this.reactTag;
        }

        public final boolean isAttachment() {
            return this.isAttachment;
        }

        public final double getWidth() {
            return this.width;
        }

        public final double getHeight() {
            return this.height;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Layout.Alignment.values().length];
            try {
                nArray[Layout.Alignment.ALIGN_NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layout.Alignment.ALIGN_OPPOSITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Layout.Alignment.ALIGN_CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[YogaMeasureMode.values().length];
            try {
                nArray[YogaMeasureMode.EXACTLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[YogaMeasureMode.AT_MOST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

