/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.assets.ReactFontManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J4\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/views/text/ReactTypefaceUtils;", "", "<init>", "()V", "parseFontWeight", "", "fontWeightString", "", "parseFontStyle", "fontStyleString", "parseFontVariant", "fontVariantArray", "Lcom/facebook/react/bridge/ReadableArray;", "applyStyles", "Landroid/graphics/Typeface;", "typeface", "style", "weight", "fontFamilyName", "assetManager", "Landroid/content/res/AssetManager;", "ReactAndroid_release"})
public final class ReactTypefaceUtils {
    @NotNull
    public static final ReactTypefaceUtils INSTANCE = new ReactTypefaceUtils();

    private ReactTypefaceUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final int parseFontWeight(@Nullable String fontWeightString) {
        String string2 = fontWeightString;
        if (string2 == null) return -1;
        int n = -1;
        switch (string2.hashCode()) {
            case 48625: {
                if (string2.equals("100")) {
                    n = 1;
                }
                break;
            }
            case -1039745817: {
                if (string2.equals("normal")) {
                    n = 2;
                }
                break;
            }
            case 49586: {
                if (string2.equals("200")) {
                    n = 3;
                }
                break;
            }
            case 50547: {
                if (string2.equals("300")) {
                    n = 4;
                }
                break;
            }
            case 51508: {
                if (string2.equals("400")) {
                    n = 2;
                }
                break;
            }
            case 52469: {
                if (string2.equals("500")) {
                    n = 5;
                }
                break;
            }
            case 53430: {
                if (string2.equals("600")) {
                    n = 6;
                }
                break;
            }
            case 54391: {
                if (string2.equals("700")) {
                    n = 7;
                }
                break;
            }
            case 55352: {
                if (string2.equals("800")) {
                    n = 8;
                }
                break;
            }
            case 56313: {
                if (string2.equals("900")) {
                    n = 9;
                }
                break;
            }
            case 3029637: {
                if (string2.equals("bold")) {
                    n = 7;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                return 100;
            }
            case 3: {
                return 200;
            }
            case 4: {
                return 300;
            }
            case 2: {
                return 400;
            }
            case 5: {
                return 500;
            }
            case 6: {
                return 600;
            }
            case 7: {
                return 700;
            }
            case 8: {
                return 800;
            }
            case 9: {
                return 900;
            }
            default: {
                return -1;
            }
        }
    }

    @JvmStatic
    public static final int parseFontStyle(@Nullable String fontStyleString) {
        String string2 = fontStyleString;
        return Intrinsics.areEqual((Object)string2, (Object)"italic") ? 2 : (Intrinsics.areEqual((Object)string2, (Object)"normal") ? 0 : -1);
    }

    @JvmStatic
    @Nullable
    public static final String parseFontVariant(@Nullable ReadableArray fontVariantArray) {
        if (fontVariantArray == null || fontVariantArray.size() == 0) {
            return null;
        }
        List features = new ArrayList();
        int n = fontVariantArray.size();
        block70: for (int i = 0; i < n; ++i) {
            String fontVariant = fontVariantArray.getString(i);
            String string2 = fontVariant;
            if (string2 == null) continue;
            int n2 = -1;
            switch (string2.hashCode()) {
                case 273808209: {
                    if (string2.equals("contextual")) {
                        n2 = 1;
                    }
                    break;
                }
                case 309330544: {
                    if (string2.equals("stylistic-seven")) {
                        n2 = 2;
                    }
                    break;
                }
                case -1933522176: {
                    if (string2.equals("stylistic-fifteen")) {
                        n2 = 3;
                    }
                    break;
                }
                case 979432035: {
                    if (string2.equals("stylistic-four")) {
                        n2 = 4;
                    }
                    break;
                }
                case 249095901: {
                    if (string2.equals("no-contextual")) {
                        n2 = 5;
                    }
                    break;
                }
                case 915975441: {
                    if (string2.equals("no-historical-ligatures")) {
                        n2 = 6;
                    }
                    break;
                }
                case 979664367: {
                    if (string2.equals("stylistic-nine")) {
                        n2 = 7;
                    }
                    break;
                }
                case 979426287: {
                    if (string2.equals("stylistic-five")) {
                        n2 = 8;
                    }
                    break;
                }
                case 1223989350: {
                    if (string2.equals("common-ligatures")) {
                        n2 = 9;
                    }
                    break;
                }
                case -1534462052: {
                    if (string2.equals("stylistic-eighteen")) {
                        n2 = 10;
                    }
                    break;
                }
                case 0x3E3B33EE: {
                    if (string2.equals("stylistic-twenty")) {
                        n2 = 11;
                    }
                    break;
                }
                case -659678800: {
                    if (string2.equals("oldstyle-nums")) {
                        n2 = 12;
                    }
                    break;
                }
                case 296506098: {
                    if (string2.equals("stylistic-eight")) {
                        n2 = 13;
                    }
                    break;
                }
                case 1001439599: {
                    if (string2.equals("stylistic-two")) {
                        n2 = 14;
                    }
                    break;
                }
                case -771984547: {
                    if (string2.equals("tabular-nums")) {
                        n2 = 15;
                    }
                    break;
                }
                case -672279417: {
                    if (string2.equals("discretionary-ligatures")) {
                        n2 = 16;
                    }
                    break;
                }
                case -899039099: {
                    if (string2.equals("historical-ligatures")) {
                        n2 = 17;
                    }
                    break;
                }
                case 1044065430: {
                    if (string2.equals("stylistic-twelve")) {
                        n2 = 18;
                    }
                    break;
                }
                case 1183323111: {
                    if (string2.equals("small-caps")) {
                        n2 = 19;
                    }
                    break;
                }
                case 1001439040: {
                    if (string2.equals("stylistic-ten")) {
                        n2 = 20;
                    }
                    break;
                }
                case 1030714463: {
                    if (string2.equals("stylistic-sixteen")) {
                        n2 = 21;
                    }
                    break;
                }
                case -1061392823: {
                    if (string2.equals("lining-nums")) {
                        n2 = 22;
                    }
                    break;
                }
                case -1195362251: {
                    if (string2.equals("proportional-nums")) {
                        n2 = 23;
                    }
                    break;
                }
                case 289909490: {
                    if (string2.equals("no-common-ligatures")) {
                        n2 = 24;
                    }
                    break;
                }
                case 1001438213: {
                    if (string2.equals("stylistic-six")) {
                        n2 = 25;
                    }
                    break;
                }
                case 2097122634: {
                    if (string2.equals("stylistic-seventeen")) {
                        n2 = 26;
                    }
                    break;
                }
                case 1463562569: {
                    if (string2.equals("stylistic-nineteen")) {
                        n2 = 27;
                    }
                    break;
                }
                case 1001434505: {
                    if (string2.equals("stylistic-one")) {
                        n2 = 28;
                    }
                    break;
                }
                case 604478526: {
                    if (string2.equals("stylistic-eleven")) {
                        n2 = 29;
                    }
                    break;
                }
                case 1082592379: {
                    if (string2.equals("no-discretionary-ligatures")) {
                        n2 = 30;
                    }
                    break;
                }
                case 1648446397: {
                    if (string2.equals("stylistic-fourteen")) {
                        n2 = 31;
                    }
                    break;
                }
                case 310339585: {
                    if (string2.equals("stylistic-three")) {
                        n2 = 32;
                    }
                    break;
                }
                case -1983120972: {
                    if (string2.equals("stylistic-thirteen")) {
                        n2 = 33;
                    }
                    break;
                }
            }
            switch (n2) {
                case 19: {
                    features.add("'smcp'");
                    continue block70;
                }
                case 12: {
                    features.add("'onum'");
                    continue block70;
                }
                case 22: {
                    features.add("'lnum'");
                    continue block70;
                }
                case 15: {
                    features.add("'tnum'");
                    continue block70;
                }
                case 23: {
                    features.add("'pnum'");
                    continue block70;
                }
                case 9: {
                    features.add("'liga'");
                    features.add("'clig'");
                    continue block70;
                }
                case 24: {
                    features.add("'liga' off");
                    features.add("'clig' off");
                    continue block70;
                }
                case 16: {
                    features.add("'dlig'");
                    continue block70;
                }
                case 30: {
                    features.add("'dlig' off");
                    continue block70;
                }
                case 17: {
                    features.add("'hlig'");
                    continue block70;
                }
                case 6: {
                    features.add("'hlig' off");
                    continue block70;
                }
                case 1: {
                    features.add("'calt'");
                    continue block70;
                }
                case 5: {
                    features.add("'calt' off");
                    continue block70;
                }
                case 28: {
                    features.add("'ss01'");
                    continue block70;
                }
                case 14: {
                    features.add("'ss02'");
                    continue block70;
                }
                case 32: {
                    features.add("'ss03'");
                    continue block70;
                }
                case 4: {
                    features.add("'ss04'");
                    continue block70;
                }
                case 8: {
                    features.add("'ss05'");
                    continue block70;
                }
                case 25: {
                    features.add("'ss06'");
                    continue block70;
                }
                case 2: {
                    features.add("'ss07'");
                    continue block70;
                }
                case 13: {
                    features.add("'ss08'");
                    continue block70;
                }
                case 7: {
                    features.add("'ss09'");
                    continue block70;
                }
                case 20: {
                    features.add("'ss10'");
                    continue block70;
                }
                case 29: {
                    features.add("'ss11'");
                    continue block70;
                }
                case 18: {
                    features.add("'ss12'");
                    continue block70;
                }
                case 33: {
                    features.add("'ss13'");
                    continue block70;
                }
                case 31: {
                    features.add("'ss14'");
                    continue block70;
                }
                case 3: {
                    features.add("'ss15'");
                    continue block70;
                }
                case 21: {
                    features.add("'ss16'");
                    continue block70;
                }
                case 26: {
                    features.add("'ss17'");
                    continue block70;
                }
                case 10: {
                    features.add("'ss18'");
                    continue block70;
                }
                case 27: {
                    features.add("'ss19'");
                    continue block70;
                }
                case 11: {
                    features.add("'ss20'");
                }
            }
        }
        return TextUtils.join((CharSequence)", ", (Iterable)features);
    }

    @JvmStatic
    @NotNull
    public static final Typeface applyStyles(@Nullable Typeface typeface, int style2, int weight, @Nullable String fontFamilyName, @NotNull AssetManager assetManager) {
        Typeface typeface2;
        Intrinsics.checkNotNullParameter((Object)assetManager, (String)"assetManager");
        ReactFontManager.TypefaceStyle typefaceStyle = new ReactFontManager.TypefaceStyle(style2, weight);
        if (fontFamilyName == null) {
            Typeface typeface3 = typeface;
            if (typeface3 == null) {
                typeface3 = Typeface.DEFAULT;
            }
            typeface2 = typefaceStyle.apply(typeface3);
        } else {
            typeface2 = ReactFontManager.Companion.getInstance().getTypeface(fontFamilyName, typefaceStyle, assetManager);
        }
        return typeface2;
    }
}

