/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.graphics.Rect;
import android.os.Bundle;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.TextView;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityNodeProviderCompat;
import com.facebook.react.R;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.text.PreparedLayout;
import com.facebook.react.views.text.PreparedLayoutTextView;
import com.facebook.react.views.text.internal.span.ReactClickableSpan;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 22\u00020\u0001:\u000223B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\r2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J5\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u000e\u0010!\u001a\n\u0012\u0004\u0012\u0002H\u001e\u0018\u00010\"H\u0004\u00a2\u0006\u0002\u0010#J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010+\u001a\u00020)H\u0014J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010'\u001a\u00020\u0003H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate;", "Lcom/facebook/react/uimanager/ReactAccessibilityDelegate;", "view", "Landroid/view/View;", "originalFocus", "", "originalImportantForAccessibility", "", "<init>", "(Landroid/view/View;ZI)V", "accessibilityLinks", "Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks;", "onVirtualViewKeyboardFocusChanged", "", "virtualViewId", "hasFocus", "onPerformActionForVirtualView", "action", "arguments", "Landroid/os/Bundle;", "getVisibleVirtualViews", "virtualViewIds", "", "getVirtualViewAt", "x", "", "y", "getLayoutFromHost", "Landroid/text/Layout;", "getFirstSpan", "T", "start", "end", "classType", "Ljava/lang/Class;", "(IILjava/lang/Class;)Ljava/lang/Object;", "getSpannedFromHost", "Landroid/text/Spanned;", "onInitializeAccessibilityNodeInfo", "host", "info", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "onPopulateNodeForVirtualView", "node", "getBoundsInParent", "Landroid/graphics/Rect;", "accessibleLink", "Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks$AccessibleLink;", "getAccessibilityNodeProvider", "Landroidx/core/view/accessibility/AccessibilityNodeProviderCompat;", "Companion", "AccessibilityLinks", "ReactAndroid_release"})
public final class ReactTextViewAccessibilityDelegate
extends ReactAccessibilityDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AccessibilityLinks accessibilityLinks;

    public ReactTextViewAccessibilityDelegate(@NotNull View view, boolean originalFocus, int originalImportantForAccessibility) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view, originalFocus, originalImportantForAccessibility);
        this.accessibilityLinks = (AccessibilityLinks)this.getHostView().getTag(R.id.accessibility_links);
    }

    protected void onVirtualViewKeyboardFocusChanged(int virtualViewId, boolean hasFocus) {
        if (this.accessibilityLinks == null) {
            return;
        }
        Object object = this.accessibilityLinks;
        if (object == null || (object = ((AccessibilityLinks)object).getLinkById(virtualViewId)) == null) {
            return;
        }
        Object link = object;
        ClickableSpan clickableSpan = this.getFirstSpan(((AccessibilityLinks.AccessibleLink)link).getStart(), ((AccessibilityLinks.AccessibleLink)link).getEnd(), ClickableSpan.class);
        if (clickableSpan == null) {
            return;
        }
        ClickableSpan span = clickableSpan;
        if (span instanceof ReactClickableSpan && this.getHostView() instanceof TextView) {
            ((ReactClickableSpan)span).setKeyboardFocused(hasFocus);
            ReactClickableSpan reactClickableSpan = (ReactClickableSpan)span;
            View view = this.getHostView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
            reactClickableSpan.setFocusBgColor(((TextView)view).getHighlightColor());
            this.getHostView().invalidate();
        } else if (this.getHostView() instanceof PreparedLayoutTextView) {
            if (hasFocus) {
                View view = this.getHostView();
                Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type com.facebook.react.views.text.PreparedLayoutTextView");
                ((PreparedLayoutTextView)view).setSelection(((AccessibilityLinks.AccessibleLink)link).getStart(), ((AccessibilityLinks.AccessibleLink)link).getEnd());
            } else {
                View view = this.getHostView();
                Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type com.facebook.react.views.text.PreparedLayoutTextView");
                ((PreparedLayoutTextView)view).clearSelection();
            }
        }
    }

    @Override
    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, @Nullable Bundle arguments) {
        if (this.accessibilityLinks == null) {
            return false;
        }
        Object object = this.accessibilityLinks;
        if (object == null || (object = ((AccessibilityLinks)object).getLinkById(virtualViewId)) == null) {
            return false;
        }
        Object link = object;
        ClickableSpan clickableSpan = this.getFirstSpan(((AccessibilityLinks.AccessibleLink)link).getStart(), ((AccessibilityLinks.AccessibleLink)link).getEnd(), ClickableSpan.class);
        if (clickableSpan == null) {
            return false;
        }
        ClickableSpan span = clickableSpan;
        if (action == 16) {
            span.onClick(this.getHostView());
            return true;
        }
        return false;
    }

    @Override
    protected void getVisibleVirtualViews(@NotNull List<Integer> virtualViewIds) {
        Intrinsics.checkNotNullParameter(virtualViewIds, (String)"virtualViewIds");
        AccessibilityLinks accessibilityLinks = this.accessibilityLinks;
        if (accessibilityLinks == null) {
            return;
        }
        AccessibilityLinks accessibilityLinks2 = accessibilityLinks;
        int n = accessibilityLinks2.size();
        for (int i = 0; i < n; ++i) {
            virtualViewIds.add(i);
        }
    }

    @Override
    protected int getVirtualViewAt(float x, float y) {
        AccessibilityLinks.AccessibleLink link;
        AccessibilityLinks accessibilityLinks = this.accessibilityLinks;
        if (accessibilityLinks == null) {
            return Integer.MIN_VALUE;
        }
        AccessibilityLinks accessibilityLinks2 = accessibilityLinks;
        if (accessibilityLinks2.size() == 0 || !(this.getHostView() instanceof TextView) && !(this.getHostView() instanceof PreparedLayoutTextView)) {
            return Integer.MIN_VALUE;
        }
        float localX = x;
        float localY = y;
        localX -= (float)this.getHostView().getPaddingLeft();
        localY -= (float)this.getHostView().getPaddingTop();
        localX += (float)this.getHostView().getScrollX();
        localY += (float)this.getHostView().getScrollY();
        Layout layout2 = this.getLayoutFromHost();
        if (layout2 == null) {
            return Integer.MIN_VALUE;
        }
        Layout layout3 = layout2;
        int line = layout3.getLineForVertical((int)localY);
        int charOffset = layout3.getOffsetForHorizontal(line, localX);
        ClickableSpan clickableSpan = this.getFirstSpan(charOffset, charOffset, ClickableSpan.class);
        if (clickableSpan == null) {
            return Integer.MIN_VALUE;
        }
        ClickableSpan clickableSpan2 = clickableSpan;
        Spanned spanned = this.getSpannedFromHost();
        if (spanned == null) {
            return Integer.MIN_VALUE;
        }
        Spanned spanned2 = spanned;
        int start = spanned2.getSpanStart((Object)clickableSpan2);
        int end = spanned2.getSpanEnd((Object)clickableSpan2);
        AccessibilityLinks.AccessibleLink accessibleLink = link = accessibilityLinks2.getLinkBySpanPos(start, end);
        return accessibleLink != null ? accessibleLink.getId() : Integer.MIN_VALUE;
    }

    private final Layout getLayoutFromHost() {
        Object object;
        if (this.getHostView() instanceof PreparedLayoutTextView) {
            View view = this.getHostView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type com.facebook.react.views.text.PreparedLayoutTextView");
            PreparedLayout preparedLayout = ((PreparedLayoutTextView)view).getPreparedLayout();
            object = preparedLayout != null ? preparedLayout.getLayout() : null;
        } else if (this.getHostView() instanceof TextView) {
            View view = this.getHostView();
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
            object = ((TextView)view).getLayout();
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    protected final <T> T getFirstSpan(int start, int end, @Nullable Class<T> classType) {
        Spanned spanned = this.getSpannedFromHost();
        if (spanned == null) {
            return null;
        }
        Spanned spanned2 = spanned;
        Object[] spans = spanned2.getSpans(start, end, classType);
        Intrinsics.checkNotNull((Object)spans);
        return (T)(!(spans.length == 0) ? spans[0] : null);
    }

    private final Spanned getSpannedFromHost() {
        Spanned spanned;
        View host = this.getHostView();
        if (host instanceof PreparedLayoutTextView) {
            CharSequence charSequence;
            PreparedLayout preparedLayout = ((PreparedLayoutTextView)host).getPreparedLayout();
            CharSequence charSequence2 = preparedLayout != null && (preparedLayout = preparedLayout.getLayout()) != null ? preparedLayout.getText() : (charSequence = null);
            spanned = charSequence instanceof Spanned ? (Spanned)charSequence : null;
        } else {
            CharSequence charSequence;
            spanned = host instanceof TextView ? ((charSequence = ((TextView)host).getText()) instanceof Spanned ? (Spanned)charSequence : null) : null;
        }
        return spanned;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        super.onInitializeAccessibilityNodeInfo(host, info);
        if (host instanceof PreparedLayoutTextView) {
            info.setText(((PreparedLayoutTextView)host).getText());
        }
    }

    @Override
    protected void onPopulateNodeForVirtualView(int virtualViewId, @NotNull AccessibilityNodeInfoCompat node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AccessibilityLinks accessibilityLinks = this.accessibilityLinks;
        if (accessibilityLinks == null) {
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(new Rect(0, 0, 1, 1));
            return;
        }
        AccessibilityLinks.AccessibleLink accessibleTextSpan = accessibilityLinks.getLinkById(virtualViewId);
        if (accessibleTextSpan == null) {
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(new Rect(0, 0, 1, 1));
            return;
        }
        Rect bounds = this.getBoundsInParent(accessibleTextSpan);
        if (bounds == null) {
            node.setContentDescription((CharSequence)"");
            node.setBoundsInParent(new Rect(0, 0, 1, 1));
            return;
        }
        node.setContentDescription((CharSequence)accessibleTextSpan.getDescription());
        node.addAction(16);
        node.setBoundsInParent(bounds);
        node.setRoleDescription((CharSequence)this.getHostView().getResources().getString(R.string.link_description));
        node.setClassName((CharSequence)ReactAccessibilityDelegate.AccessibilityRole.getValue(ReactAccessibilityDelegate.AccessibilityRole.BUTTON));
    }

    private final Rect getBoundsInParent(AccessibilityLinks.AccessibleLink accessibleLink) {
        if (!(this.getHostView() instanceof TextView) && !(this.getHostView() instanceof PreparedLayoutTextView)) {
            return new Rect(0, 0, this.getHostView().getWidth(), this.getHostView().getHeight());
        }
        Layout layout2 = this.getLayoutFromHost();
        if (layout2 == null) {
            return new Rect(0, 0, this.getHostView().getWidth(), this.getHostView().getHeight());
        }
        Layout textViewLayout = layout2;
        int startOffset = accessibleLink.getStart();
        int endOffset = accessibleLink.getEnd();
        int startOffsetLineNumber = textViewLayout.getLineForOffset(startOffset);
        int startLineEndOffset = textViewLayout.getLineEnd(startOffsetLineNumber);
        int endOffsetLineNumber = textViewLayout.getLineForOffset(endOffset);
        int endLineEndOffset = textViewLayout.getLineEnd(endOffsetLineNumber);
        if (startOffset > startLineEndOffset || endOffset > endLineEndOffset) {
            return null;
        }
        Rect rootRect = new Rect();
        double startXCoordinates = textViewLayout.getPrimaryHorizontal(startOffset);
        boolean isMultiline = startOffsetLineNumber != endOffsetLineNumber;
        textViewLayout.getLineBounds(startOffsetLineNumber, rootRect);
        int verticalOffset = this.getHostView().getScrollY() + this.getHostView().getPaddingTop();
        rootRect.top += verticalOffset;
        rootRect.bottom += verticalOffset;
        rootRect.left = (int)((double)rootRect.left + (startXCoordinates + (double)this.getHostView().getPaddingLeft() - (double)this.getHostView().getScrollX()));
        if (isMultiline) {
            return new Rect(rootRect.left, rootRect.top, rootRect.right, rootRect.bottom);
        }
        double endXCoordinates = textViewLayout.getPrimaryHorizontal(endOffset);
        return new Rect(rootRect.left, rootRect.top, (int)endXCoordinates, rootRect.bottom);
    }

    @Override
    @Nullable
    public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(@NotNull View host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (this.accessibilityLinks != null) {
            return this.superGetAccessibilityNodeProvider(host);
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks;", "", "text", "Landroid/text/Spanned;", "<init>", "(Landroid/text/Spanned;)V", "links", "", "Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks$AccessibleLink;", "getLinkById", "id", "", "getLinkBySpanPos", "start", "end", "size", "AccessibleLink", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nReactTextViewAccessibilityDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactTextViewAccessibilityDelegate.kt\ncom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,333:1\n6181#2,2:334\n*S KotlinDebug\n*F\n+ 1 ReactTextViewAccessibilityDelegate.kt\ncom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks\n*L\n281#1:334,2\n*E\n"})
    public static final class AccessibilityLinks {
        @NotNull
        private final List<AccessibleLink> links;

        public AccessibilityLinks(@NotNull Spanned text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            List accessibleLinks = new ArrayList();
            Object[] spans = (ClickableSpan[])text.getSpans(0, text.length(), ClickableSpan.class);
            Intrinsics.checkNotNull((Object)spans);
            Object[] $this$sortBy$iv = spans;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.length > 1) {
                ArraysKt.sortWith((Object[])$this$sortBy$iv, (Comparator)new Comparator(text){
                    final /* synthetic */ Spanned $text$inlined;
                    {
                        this.$text$inlined = spanned;
                    }

                    public final int compare(T a, T b) {
                        ClickableSpan it = (ClickableSpan)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(this.$text$inlined.getSpanStart((Object)it));
                        it = (ClickableSpan)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$text$inlined.getSpanStart((Object)it)));
                    }
                });
            }
            int n = spans.length;
            for (int i = 0; i < n; ++i) {
                int end;
                Object span = spans[i];
                int start = text.getSpanStart(span);
                if (start == (end = text.getSpanEnd(span)) || start < 0 || end < 0 || start > text.length() || end > text.length()) continue;
                AccessibleLink link = new AccessibleLink();
                link.setDescription(((Object)text.subSequence(start, end)).toString());
                link.setStart(start);
                link.setEnd(end);
                link.setId(i);
                accessibleLinks.add(link);
            }
            this.links = accessibleLinks;
        }

        @Nullable
        public final AccessibleLink getLinkById(int id2) {
            for (AccessibleLink link : this.links) {
                if (link.getId() != id2) continue;
                return link;
            }
            return null;
        }

        @Nullable
        public final AccessibleLink getLinkBySpanPos(int start, int end) {
            for (AccessibleLink link : this.links) {
                if (link.getStart() != start || link.getEnd() != end) continue;
                return link;
            }
            return null;
        }

        public final int size() {
            return this.links.size();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$AccessibilityLinks$AccessibleLink;", "", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "start", "", "getStart", "()I", "setStart", "(I)V", "end", "getEnd", "setEnd", "id", "getId", "setId", "ReactAndroid_release"})
        public static final class AccessibleLink {
            @Nullable
            private String description;
            private int start;
            private int end;
            private int id;

            @Nullable
            public final String getDescription() {
                return this.description;
            }

            public final void setDescription(@Nullable String string2) {
                this.description = string2;
            }

            public final int getStart() {
                return this.start;
            }

            public final void setStart(int n) {
                this.start = n;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            public final int getId() {
                return this.id;
            }

            public final void setId(int n) {
                this.id = n;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/facebook/react/views/text/ReactTextViewAccessibilityDelegate$Companion;", "", "<init>", "()V", "setDelegate", "", "view", "Landroid/view/View;", "originalFocus", "", "originalImportantForAccessibility", "", "resetDelegate", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void setDelegate(@NotNull View view, boolean originalFocus, int originalImportantForAccessibility) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (!(ViewCompat.hasAccessibilityDelegate((View)view) || view.getTag(R.id.accessibility_role) == null && view.getTag(R.id.accessibility_state) == null && view.getTag(R.id.accessibility_actions) == null && view.getTag(R.id.react_test_id) == null && view.getTag(R.id.accessibility_collection_item) == null && view.getTag(R.id.accessibility_links) == null && view.getTag(R.id.role) == null)) {
                ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)((AccessibilityDelegateCompat)new ReactTextViewAccessibilityDelegate(view, originalFocus, originalImportantForAccessibility)));
            }
        }

        public final void resetDelegate(@NotNull View view, boolean originalFocus, int originalImportantForAccessibility) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)((AccessibilityDelegateCompat)new ReactTextViewAccessibilityDelegate(view, originalFocus, originalImportantForAccessibility)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

