/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.PreparedLayout;
import com.facebook.react.views.text.ReactTextViewAccessibilityDelegate;
import com.facebook.react.views.text.internal.span.ReactTagSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0001\u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0003MNOB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020%J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0014J0\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0014J\u0016\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001aJ\u0006\u00104\u001a\u00020%J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u000207H\u0016J3\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u001a2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H90=H\u0002\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u001aH\u0002J\u0010\u0010@\u001a\u00020,2\u0006\u00106\u001a\u000207H\u0016J\"\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u00020\u001a2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010F\u001a\u00020,2\u0006\u00106\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020,H\u0016J\u0018\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0013\u0010 \u001a\u0004\u0018\u00010!8G\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006P"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView;", "Landroid/view/ViewGroup;", "Lcom/facebook/react/uimanager/ReactCompoundView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "clickableSpans", "", "Landroid/text/style/ClickableSpan;", "selection", "Lcom/facebook/react/views/text/PreparedLayoutTextView$TextSelection;", "value", "Lcom/facebook/react/views/text/PreparedLayout;", "preparedLayout", "getPreparedLayout", "()Lcom/facebook/react/views/text/PreparedLayout;", "setPreparedLayout", "(Lcom/facebook/react/views/text/PreparedLayout;)V", "Lcom/facebook/react/uimanager/style/Overflow;", "overflow", "getOverflow", "()Lcom/facebook/react/uimanager/style/Overflow;", "setOverflow", "(Lcom/facebook/react/uimanager/style/Overflow;)V", "selectionColor", "", "getSelectionColor", "()Ljava/lang/Integer;", "setSelectionColor", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "text", "", "getText", "()Ljava/lang/CharSequence;", "initView", "", "recycleView", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "l", "t", "r", "b", "setSelection", "start", "end", "clearSelection", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "getSpanInCoords", "T", "x", "y", "clazz", "Ljava/lang/Class;", "(IILjava/lang/Class;)Ljava/lang/Object;", "getTextOffsetAt", "dispatchHoverEvent", "onFocusChanged", "gainFocus", "direction", "previouslyFocusedRect", "Landroid/graphics/Rect;", "dispatchKeyEvent", "Landroid/view/KeyEvent;", "hasOverlappingRendering", "reactTagForTouch", "touchX", "", "touchY", "Api34Utils", "TextSelection", "Companion", "ReactAndroid_release"})
@DoNotStrip
@SourceDebugExtension(value={"SMAP\nPreparedLayoutTextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreparedLayoutTextView.kt\ncom/facebook/react/views/text/PreparedLayoutTextView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n1#2:364\n*E\n"})
public final class PreparedLayoutTextView
extends ViewGroup
implements ReactCompoundView {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends ClickableSpan> clickableSpans;
    @Nullable
    private TextSelection selection;
    @Nullable
    private PreparedLayout preparedLayout;
    @NotNull
    private Overflow overflow;
    @ColorInt
    @Nullable
    private Integer selectionColor;
    @NotNull
    private static final Paint selectionPaint = new Paint();

    public PreparedLayoutTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.clickableSpans = CollectionsKt.emptyList();
        this.overflow = Overflow.HIDDEN;
        this.initView();
        this.setWillNotDraw(false);
    }

    @Nullable
    public final PreparedLayout getPreparedLayout() {
        return this.preparedLayout;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPreparedLayout(@Nullable PreparedLayout value) {
        block6: {
            Object object;
            block8: {
                block7: {
                    void it;
                    if (Intrinsics.areEqual((Object)this.preparedLayout, (Object)value)) break block6;
                    TextSelection lastSelection = this.selection;
                    if (lastSelection != null) {
                        PreparedLayout preparedLayout;
                        if (value != null && Intrinsics.areEqual((Object)String.valueOf((preparedLayout = this.preparedLayout) != null && (preparedLayout = preparedLayout.getLayout()) != null ? preparedLayout.getText() : null), (Object)((Object)value.getLayout().getText()).toString())) {
                            value.getLayout().getSelectionPath(lastSelection.getStart(), lastSelection.getEnd(), lastSelection.getPath());
                        } else {
                            this.clearSelection();
                        }
                    }
                    PreparedLayoutTextView preparedLayoutTextView = this;
                    object = value;
                    if (object == null || (object = ((PreparedLayout)object).getLayout()) == null || (object = object.getText()) == null) break block7;
                    Object object2 = object;
                    PreparedLayoutTextView preparedLayoutTextView2 = preparedLayoutTextView;
                    boolean bl = false;
                    List list = PreparedLayoutTextView.Companion.filterClickableSpans((CharSequence)it);
                    preparedLayoutTextView = preparedLayoutTextView2;
                    object = list;
                    if (list != null) break block8;
                }
                object = CollectionsKt.emptyList();
            }
            preparedLayoutTextView.clickableSpans = object;
            this.preparedLayout = value;
            this.invalidate();
        }
    }

    @NotNull
    public final Overflow getOverflow() {
        return this.overflow;
    }

    public final void setOverflow(@NotNull Overflow value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.overflow != value) {
            this.overflow = value;
            this.invalidate();
        }
    }

    @Nullable
    public final Integer getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(@Nullable Integer n) {
        this.selectionColor = n;
    }

    @DoNotStrip
    @Nullable
    public final CharSequence getText() {
        PreparedLayout preparedLayout = this.preparedLayout;
        return preparedLayout != null && (preparedLayout = preparedLayout.getLayout()) != null ? preparedLayout.getText() : null;
    }

    private final void initView() {
        this.clickableSpans = CollectionsKt.emptyList();
        this.selection = null;
        this.setPreparedLayout(null);
    }

    public final void recycleView() {
        this.initView();
        BackgroundStyleApplicator.reset((View)this);
        this.setOverflow(Overflow.HIDDEN);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Layout layout2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.overflow != Overflow.VISIBLE) {
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
        }
        super.onDraw(canvas);
        PreparedLayout preparedLayout = this.preparedLayout;
        canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop() + (preparedLayout != null ? preparedLayout.getVerticalOffset() : 0.0f));
        PreparedLayout preparedLayout2 = this.preparedLayout;
        Object object = layout2 = preparedLayout2 != null ? preparedLayout2.getLayout() : null;
        if (layout2 != null) {
            if (this.selection != null) {
                int n;
                Integer n2 = this.selectionColor;
                if (n2 != null) {
                    n = n2;
                } else {
                    Context context = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    n = DefaultStyleValuesUtil.getDefaultTextColorHighlight(context);
                }
                selectionPaint.setColor(n);
            }
            if (Build.VERSION.SDK_INT >= 34) {
                TextSelection textSelection = this.selection;
                Api34Utils.INSTANCE.draw(layout2, canvas, (Path)(textSelection != null ? textSelection.getPath() : null), selectionPaint);
            } else {
                TextSelection textSelection = this.selection;
                layout2.draw(canvas, (Path)(textSelection != null ? textSelection.getPath() : null), selectionPaint, 0);
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public final void setSelection(int start, int end) {
        PreparedLayout preparedLayout = this.preparedLayout;
        if (preparedLayout == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        Layout layout2 = preparedLayout.getLayout();
        if (start < 0 || end > layout2.getText().length() || start >= end) {
            throw new IllegalArgumentException("setSelection start and end are not in valid range. start: " + start + ", end: " + end + ", text length: " + layout2.getText().length());
        }
        TextSelection textSelection = this.selection;
        if (textSelection == null) {
            Path selectionPath = new Path();
            layout2.getSelectionPath(start, end, selectionPath);
            this.selection = new TextSelection(start, end, selectionPath);
        } else {
            textSelection.setStart(start);
            textSelection.setEnd(end);
            layout2.getSelectionPath(start, end, textSelection.getPath());
        }
        this.invalidate();
    }

    public final void clearSelection() {
        this.selection = null;
        this.invalidate();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        int y;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled() || this.clickableSpans.isEmpty()) {
            return super.onTouchEvent(event);
        }
        int action = event.getActionMasked();
        if (action == 3) {
            this.clearSelection();
            return false;
        }
        int x = (int)event.getX();
        ClickableSpan clickableSpan = this.getSpanInCoords(x, y = (int)event.getY(), ClickableSpan.class);
        if (clickableSpan == null) {
            this.clearSelection();
            return super.onTouchEvent(event);
        }
        switch (action) {
            case 1: {
                this.clearSelection();
                clickableSpan.onClick((View)this);
                break;
            }
            case 0: {
                PreparedLayout preparedLayout = this.preparedLayout;
                if (preparedLayout == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                Layout layout2 = preparedLayout.getLayout();
                CharSequence charSequence = layout2.getText();
                Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
                int start = ((Spanned)charSequence).getSpanStart((Object)clickableSpan);
                CharSequence charSequence2 = layout2.getText();
                Intrinsics.checkNotNull((Object)charSequence2, (String)"null cannot be cast to non-null type android.text.Spanned");
                int end = ((Spanned)charSequence2).getSpanEnd((Object)clickableSpan);
                this.setSelection(start, end);
            }
        }
        return true;
    }

    private final <T> T getSpanInCoords(int x, int y, Class<T> clazz) {
        int offset = this.getTextOffsetAt(x, y);
        if (offset < 0) {
            return null;
        }
        Object object = this.getText();
        Spanned spanned = object instanceof Spanned ? (Spanned)object : null;
        if (spanned == null) {
            return null;
        }
        Spanned spanned2 = spanned;
        Object[] spans = spanned2.getSpans(offset, offset, clazz);
        Intrinsics.checkNotNull((Object)spans);
        if (spans.length == 0) {
            return null;
        }
        if (!(spans.length <= 2)) {
            throw new IllegalStateException("Check failed.");
        }
        object = ArrayIteratorKt.iterator((Object[])spans);
        while (object.hasNext()) {
            int inclusiveEnd;
            Object span = object.next();
            int spanFlags = spanned2.getSpanFlags(span);
            int inclusiveStart = (spanFlags & 0x12) != 0 || (spanFlags & 0x11) != 0 ? spanned2.getSpanStart(span) : spanned2.getSpanStart(span) + 1;
            int n = inclusiveEnd = (spanFlags & 0x12) != 0 || (spanFlags & 0x22) != 0 ? spanned2.getSpanEnd(span) : spanned2.getSpanEnd(span) - 1;
            if (offset < inclusiveStart || offset > inclusiveEnd) continue;
            return (T)span;
        }
        return null;
    }

    private final int getTextOffsetAt(int x, int y) {
        int n;
        int layoutX = x - this.getPaddingLeft();
        PreparedLayout preparedLayout = this.preparedLayout;
        int layoutY = y - (this.getPaddingTop() + (preparedLayout != null ? MathKt.roundToInt((float)preparedLayout.getVerticalOffset()) : 0));
        PreparedLayout preparedLayout2 = this.preparedLayout;
        if (preparedLayout2 == null || (preparedLayout2 = preparedLayout2.getLayout()) == null) {
            return -1;
        }
        PreparedLayout layout2 = preparedLayout2;
        int line = layout2.getLineForVertical(layoutY);
        float left = 0.0f;
        float right = 0.0f;
        if (layout2.getAlignment() == Layout.Alignment.ALIGN_CENTER) {
            left = layout2.getLineLeft(line);
            right = layout2.getLineRight(line);
        } else {
            boolean rtl = layout2.getParagraphDirection(line) == -1;
            left = rtl ? (float)layout2.getWidth() - layout2.getLineMax(line) : (float)layout2.getParagraphLeft(line);
            float f = right = rtl ? (float)layout2.getParagraphRight(line) : layout2.getLineMax(line);
        }
        if ((float)layoutX < left || (float)layoutX > right) {
            return -1;
        }
        try {
            n = layout2.getOffsetForHorizontal(line, layoutX);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            n = -1;
        }
        return n;
    }

    public boolean dispatchHoverEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return super.dispatchHoverEvent(event);
    }

    public void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        if (!((Collection)this.clickableSpans).isEmpty() && !gainFocus) {
            this.clearSelection();
        }
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        AccessibilityDelegateCompat accessibilityDelegateCompat = ViewCompat.getAccessibilityDelegate((View)((View)this));
        if (accessibilityDelegateCompat != null && accessibilityDelegateCompat instanceof ReactTextViewAccessibilityDelegate) {
            ((ReactTextViewAccessibilityDelegate)accessibilityDelegateCompat).onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        }
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AccessibilityDelegateCompat accessibilityDelegateCompat = ViewCompat.getAccessibilityDelegate((View)((View)this));
        boolean delegateHandled = accessibilityDelegateCompat instanceof ReactTextViewAccessibilityDelegate && ((ReactTextViewAccessibilityDelegate)accessibilityDelegateCompat).dispatchKeyEvent(event);
        return delegateHandled || super.dispatchKeyEvent(event);
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        ReactTagSpan reactTagSpan = this.getSpanInCoords(MathKt.roundToInt((float)touchX), MathKt.roundToInt((float)touchY), ReactTagSpan.class);
        return reactTagSpan != null ? reactTagSpan.getReactTag() : this.getId();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c3\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView$Api34Utils;", "", "<init>", "()V", "highlightPaths", "", "Landroid/graphics/Path;", "highlightPaints", "Landroid/graphics/Paint;", "draw", "", "layout", "Landroid/text/Layout;", "canvas", "Landroid/graphics/Canvas;", "selectionPath", "selectionPaint", "ReactAndroid_release"})
    @RequiresApi(api=34)
    private static final class Api34Utils {
        @NotNull
        public static final Api34Utils INSTANCE = new Api34Utils();
        @Nullable
        private static List<? extends Path> highlightPaths;
        @Nullable
        private static List<? extends Paint> highlightPaints;

        private Api34Utils() {
        }

        @DoNotInline
        public final void draw(@NotNull Layout layout2, @NotNull Canvas canvas, @Nullable Path selectionPath, @Nullable Paint selectionPaint) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (selectionPath != null) {
                if (highlightPaths == null) {
                    highlightPaths = new ArrayList();
                }
                if (highlightPaints == null) {
                    highlightPaints = new ArrayList();
                }
            }
            layout2.draw(canvas, highlightPaths, highlightPaints, selectionPath, selectionPaint, 0);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView$Companion;", "", "<init>", "()V", "selectionPaint", "Landroid/graphics/Paint;", "filterClickableSpans", "", "Landroid/text/style/ClickableSpan;", "text", "", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        private final List<ClickableSpan> filterClickableSpans(CharSequence text) {
            if (!(text instanceof Spanned)) {
                return CollectionsKt.emptyList();
            }
            ArrayList spans = new ArrayList();
            int i = 0;
            while (i < text.length()) {
                int next2 = ((Spanned)text).nextSpanTransition(i, text.length(), ClickableSpan.class);
                Collection collection = spans;
                Object[] objectArray = ((Spanned)text).getSpans(i, next2, ClickableSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(...)");
                CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
                i = next2;
            }
            return spans;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextView$TextSelection;", "", "start", "", "end", "path", "Landroid/graphics/Path;", "<init>", "(IILandroid/graphics/Path;)V", "getStart", "()I", "setStart", "(I)V", "getEnd", "setEnd", "getPath", "()Landroid/graphics/Path;", "setPath", "(Landroid/graphics/Path;)V", "ReactAndroid_release"})
    private static final class TextSelection {
        private int start;
        private int end;
        @NotNull
        private Path path;

        public TextSelection(int start, int end, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.start = start;
            this.end = end;
            this.path = path;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final void setPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
            this.path = path;
        }
    }
}

