/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.core.content.res.ResourcesCompat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\r\u0010\u0016\u001a\u00020\u0000H\u0007\u00a2\u0006\u0002\b\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00008FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/views/imagehelper/ResourceDrawableIdHelper;", "", "<init>", "()V", "resourceDrawableIdMap", "", "", "", "clear", "", "getResourceDrawableId", "context", "Landroid/content/Context;", "name", "addDrawableId", "normalizedName", "getResourceDrawable", "Landroid/graphics/drawable/Drawable;", "getResourceDrawableUri", "Landroid/net/Uri;", "instance", "getInstance$annotations", "getInstance", "()Lcom/facebook/react/views/imagehelper/ResourceDrawableIdHelper;", "LOCAL_RESOURCE_SCHEME", "DEPRECATED$getInstance", "ReactAndroid_release"})
@ThreadSafe
public final class ResourceDrawableIdHelper {
    @NotNull
    public static final ResourceDrawableIdHelper INSTANCE = new ResourceDrawableIdHelper();
    @NotNull
    private static final Map<String, Integer> resourceDrawableIdMap = new HashMap();
    @NotNull
    private static final String LOCAL_RESOURCE_SCHEME = "res";

    private ResourceDrawableIdHelper() {
    }

    @JvmStatic
    public static final synchronized void clear() {
        resourceDrawableIdMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int getResourceDrawableId(@NotNull Context context, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            return 0;
        }
        String string2 = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String normalizedName = StringsKt.replace$default((String)string2, (String)"-", (String)"_", (boolean)false, (int)4, null);
        try {
            return Integer.parseInt(normalizedName);
        }
        catch (NumberFormatException numberFormatException) {
            ResourceDrawableIdHelper resourceDrawableIdHelper = INSTANCE;
            synchronized (resourceDrawableIdHelper) {
                boolean bl = false;
                Integer n = resourceDrawableIdMap.get(normalizedName);
                int n2 = n != null ? n.intValue() : INSTANCE.addDrawableId(context, normalizedName);
                return n2;
            }
        }
    }

    private final int addDrawableId(Context context, String normalizedName) {
        int newId = context.getResources().getIdentifier(normalizedName, "drawable", context.getPackageName());
        Integer n = newId;
        resourceDrawableIdMap.put(normalizedName, n);
        return newId;
    }

    @JvmStatic
    @Nullable
    public static final Drawable getResourceDrawable(@NotNull Context context, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resId = ResourceDrawableIdHelper.getResourceDrawableId(context, name);
        return resId > 0 ? ResourcesCompat.getDrawable((Resources)context.getResources(), (int)resId, null) : null;
    }

    @JvmStatic
    @NotNull
    public static final Uri getResourceDrawableUri(@NotNull Context context, @Nullable String name) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resId = ResourceDrawableIdHelper.getResourceDrawableId(context, name);
        if (resId > 0) {
            Uri uri2 = new Uri.Builder().scheme(LOCAL_RESOURCE_SCHEME).path(String.valueOf(resId)).build();
            Intrinsics.checkNotNull((Object)uri2);
            uri = uri2;
        } else {
            Uri uri3 = Uri.EMPTY;
            Intrinsics.checkNotNull((Object)uri3);
            uri = uri3;
        }
        return uri;
    }

    @NotNull
    public static final ResourceDrawableIdHelper getInstance() {
        return INSTANCE;
    }

    @JvmStatic
    @Deprecated(message="Use object methods instead, this API is for backward compat")
    public static /* synthetic */ void getInstance$annotations() {
    }

    @Deprecated(message="Use .instance instead, this API is for backward compat", replaceWith=@ReplaceWith(expression="instance", imports={}))
    @JvmName(name="DEPRECATED$getInstance")
    @NotNull
    public final ResourceDrawableIdHelper DEPRECATED$getInstance() {
        return this;
    }
}

