/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.controller.ForwardingControllerListener;
import com.facebook.drawee.drawable.AutoRotateDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.DownsampleMode;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.postprocessors.IterativeBoxBlurPostProcessor;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.modules.fresco.ImageCacheControl;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.util.RNLog;
import com.facebook.react.views.image.GlobalImageLoadListener;
import com.facebook.react.views.image.ImageLoadEvent;
import com.facebook.react.views.image.ImageResizeMethod;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.image.MultiPostprocessor;
import com.facebook.react.views.image.ReactImageDownloadListener;
import com.facebook.react.views.imagehelper.ImageSource;
import com.facebook.react.views.imagehelper.MultiSourceHelper;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 p2\u00020\u0001:\u0002opB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u00101\u001a\u0002022\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u001fJ\u000e\u00105\u001a\u0002022\u0006\u00106\u001a\u00020.J\u0010\u00107\u001a\u0002022\u0006\u00108\u001a\u00020\u0019H\u0016J\u000e\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020\u0019J\u000e\u0010;\u001a\u0002022\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020.J\u000e\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020.J\u0016\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020\u0019J\u000e\u0010A\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010B\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010C\u001a\u0002022\u0006\u0010/\u001a\u000200J\u000e\u0010D\u001a\u0002022\u0006\u0010E\u001a\u00020.J\u0010\u0010F\u001a\u0002022\b\u0010\f\u001a\u0004\u0018\u00010GJ\u0012\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010J\u001a\u00020IH\u0002J\u0010\u0010N\u001a\u0002022\b\u0010O\u001a\u0004\u0018\u00010KJ\u0010\u0010P\u001a\u0002022\b\u0010O\u001a\u0004\u0018\u00010KJ\u000e\u0010Q\u001a\u0002022\u0006\u0010R\u001a\u00020\u001fJ\u000e\u0010S\u001a\u0002022\u0006\u0010T\u001a\u00020\u0019J\u0010\u0010U\u001a\u0002022\b\u0010+\u001a\u0004\u0018\u00010,J\b\u0010V\u001a\u00020\u001fH\u0016J\u0010\u0010W\u001a\u0002022\u0006\u0010X\u001a\u00020YH\u0016J\u0006\u0010Z\u001a\u000202J\u0010\u0010[\u001a\u0002022\u0006\u0010\\\u001a\u00020\u001fH\u0002J\u0018\u0010]\u001a\u0002022\u000e\u0010^\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010(H\u0007J(\u0010_\u001a\u0002022\u0006\u0010`\u001a\u00020\u00192\u0006\u0010a\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\u00192\u0006\u0010c\u001a\u00020\u0019H\u0014J\b\u0010d\u001a\u00020\u001fH\u0002J\b\u0010g\u001a\u000202H\u0002J\u0010\u0010h\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0012\u0010m\u001a\u0002022\b\u0010n\u001a\u0004\u0018\u00010KH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0018\u00010!R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010e\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0016\u0010i\u001a\u0004\u0018\u00010j8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bk\u0010l\u00a8\u0006q"}, d2={"Lcom/facebook/react/views/image/ReactImageView;", "Lcom/facebook/drawee/view/GenericDraweeView;", "context", "Landroid/content/Context;", "draweeControllerBuilder", "Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;", "globalImageLoadListener", "Lcom/facebook/react/views/image/GlobalImageLoadListener;", "callerContext", "", "<init>", "(Landroid/content/Context;Lcom/facebook/drawee/controller/AbstractDraweeControllerBuilder;Lcom/facebook/react/views/image/GlobalImageLoadListener;Ljava/lang/Object;)V", "sources", "", "Lcom/facebook/react/views/imagehelper/ImageSource;", "imageSource", "getImageSource$ReactAndroid_release", "()Lcom/facebook/react/views/imagehelper/ImageSource;", "setImageSource$ReactAndroid_release", "(Lcom/facebook/react/views/imagehelper/ImageSource;)V", "cachedImageSource", "defaultImageDrawable", "Landroid/graphics/drawable/Drawable;", "loadingImageDrawable", "overlayColor", "", "scaleType", "Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "tileMode", "Landroid/graphics/Shader$TileMode;", "isDirty", "", "tilePostprocessor", "Lcom/facebook/react/views/image/ReactImageView$TilePostprocessor;", "iterativeBoxBlurPostProcessor", "Lcom/facebook/imagepipeline/postprocessors/IterativeBoxBlurPostProcessor;", "downloadListener", "Lcom/facebook/react/views/image/ReactImageDownloadListener;", "Lcom/facebook/imagepipeline/image/ImageInfo;", "controllerForTesting", "Lcom/facebook/drawee/controller/ControllerListener;", "fadeDurationMs", "progressiveRenderingEnabled", "headers", "Lcom/facebook/react/bridge/ReadableMap;", "resizeMultiplier", "", "resizeMethod", "Lcom/facebook/react/views/image/ImageResizeMethod;", "updateCallerContext", "", "setShouldNotifyLoadEvents", "shouldNotify", "setBlurRadius", "blurRadius", "setBackgroundColor", "backgroundColor", "setBorderColor", "borderColor", "setOverlayColor", "setBorderWidth", "borderWidth", "setBorderRadius", "borderRadius", "position", "setScaleType", "setTileMode", "setResizeMethod", "setResizeMultiplier", "multiplier", "setSource", "Lcom/facebook/react/bridge/ReadableArray;", "computeCacheControl", "Lcom/facebook/react/modules/fresco/ImageCacheControl;", "cacheControl", "", "computeRequestLevel", "Lcom/facebook/imagepipeline/request/ImageRequest$RequestLevel;", "setDefaultSource", "name", "setLoadingIndicatorSource", "setProgressiveRenderingEnabled", "enabled", "setFadeDuration", "durationMs", "setHeaders", "hasOverlappingRendering", "onDraw", "canvas", "Landroid/graphics/Canvas;", "maybeUpdateView", "maybeUpdateViewFromRequest", "doResize", "setControllerListener", "controllerListener", "onSizeChanged", "w", "h", "oldw", "oldh", "hasMultipleSources", "isTiled", "()Z", "setSourceImage", "shouldResize", "resizeOptions", "Lcom/facebook/imagepipeline/common/ResizeOptions;", "getResizeOptions", "()Lcom/facebook/imagepipeline/common/ResizeOptions;", "warnImageSource", "uri", "TilePostprocessor", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactImageView.kt\ncom/facebook/react/views/image/ReactImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,630:1\n1#2:631\n*E\n"})
public final class ReactImageView
extends GenericDraweeView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder;
    @Nullable
    private final GlobalImageLoadListener globalImageLoadListener;
    @Nullable
    private Object callerContext;
    @NotNull
    private final List<ImageSource> sources;
    @Nullable
    private ImageSource imageSource;
    @Nullable
    private ImageSource cachedImageSource;
    @Nullable
    private Drawable defaultImageDrawable;
    @Nullable
    private Drawable loadingImageDrawable;
    private int overlayColor;
    @NotNull
    private ScalingUtils.ScaleType scaleType;
    @NotNull
    private Shader.TileMode tileMode;
    private boolean isDirty;
    @Nullable
    private TilePostprocessor tilePostprocessor;
    @Nullable
    private IterativeBoxBlurPostProcessor iterativeBoxBlurPostProcessor;
    @Nullable
    private ReactImageDownloadListener<ImageInfo> downloadListener;
    @Nullable
    private ControllerListener<ImageInfo> controllerForTesting;
    private int fadeDurationMs;
    private boolean progressiveRenderingEnabled;
    @Nullable
    private ReadableMap headers;
    private float resizeMultiplier;
    @NotNull
    private ImageResizeMethod resizeMethod;
    public static final int REMOTE_IMAGE_FADE_DURATION_MS = 300;
    @NotNull
    private static final Matrix tileMatrix = new Matrix();

    public ReactImageView(@NotNull Context context, @NotNull AbstractDraweeControllerBuilder<?, ?, ?, ?> draweeControllerBuilder, @Nullable GlobalImageLoadListener globalImageLoadListener, @Nullable Object callerContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(draweeControllerBuilder, (String)"draweeControllerBuilder");
        super(context, ReactImageView.Companion.buildHierarchy(context));
        this.draweeControllerBuilder = draweeControllerBuilder;
        this.globalImageLoadListener = globalImageLoadListener;
        this.callerContext = callerContext;
        this.sources = new ArrayList();
        this.scaleType = ImageResizeMode.defaultValue();
        this.tileMode = ImageResizeMode.defaultTileMode();
        this.fadeDurationMs = -1;
        this.resizeMultiplier = 1.0f;
        this.resizeMethod = ImageResizeMethod.AUTO;
        this.setLegacyVisibilityHandlingEnabled(true);
    }

    @Nullable
    public final ImageSource getImageSource$ReactAndroid_release() {
        return this.imageSource;
    }

    public final void setImageSource$ReactAndroid_release(@Nullable ImageSource imageSource) {
        this.imageSource = imageSource;
    }

    public final void updateCallerContext(@Nullable Object callerContext) {
        if (!Intrinsics.areEqual((Object)this.callerContext, (Object)callerContext)) {
            this.callerContext = callerContext;
            this.isDirty = true;
        }
    }

    public final void setShouldNotifyLoadEvents(boolean shouldNotify) {
        if (shouldNotify == (this.downloadListener != null)) {
            return;
        }
        if (!shouldNotify) {
            this.downloadListener = null;
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)context, this.getId());
            this.downloadListener = new ReactImageDownloadListener<ImageInfo>(eventDispatcher, this){
                final /* synthetic */ EventDispatcher $eventDispatcher;
                final /* synthetic */ ReactImageView this$0;
                {
                    this.$eventDispatcher = $eventDispatcher;
                    this.this$0 = $receiver;
                }

                public void onProgressChange(int loaded, int total) {
                    if (this.$eventDispatcher == null || this.this$0.getImageSource$ReactAndroid_release() == null) {
                        return;
                    }
                    ImageSource imageSource = this.this$0.getImageSource$ReactAndroid_release();
                    this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createProgressEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId(), imageSource != null ? imageSource.getSource() : null, loaded, total));
                }

                public void onSubmit(String id2, Object callerContext) {
                    Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                    if (this.$eventDispatcher == null) {
                        return;
                    }
                    this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadStartEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId()));
                }

                public void onFinalImageSet(String id2, ImageInfo imageInfo, Animatable animatable) {
                    Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                    if (imageInfo != null && this.this$0.getImageSource$ReactAndroid_release() != null && this.$eventDispatcher != null) {
                        ImageSource imageSource = this.this$0.getImageSource$ReactAndroid_release();
                        this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId(), imageSource != null ? imageSource.getSource() : null, imageInfo.getWidth(), imageInfo.getHeight()));
                        this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createLoadEndEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId()));
                    }
                }

                public void onFailure(String id2, Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    if (this.$eventDispatcher == null) {
                        return;
                    }
                    this.$eventDispatcher.dispatchEvent(ImageLoadEvent.Companion.createErrorEvent(UIManagerHelper.getSurfaceId((View)this.this$0), this.this$0.getId(), throwable));
                }
            };
        }
        this.isDirty = true;
    }

    public final void setBlurRadius(float blurRadius) {
        int pixelBlurRadius = (int)PixelUtil.INSTANCE.dpToPx(blurRadius) / 2;
        this.iterativeBoxBlurPostProcessor = pixelBlurRadius == 0 ? null : new IterativeBoxBlurPostProcessor(2, pixelBlurRadius);
        this.isDirty = true;
    }

    public void setBackgroundColor(int backgroundColor) {
        BackgroundStyleApplicator.setBackgroundColor((View)this, backgroundColor);
    }

    public final void setBorderColor(int borderColor) {
        BackgroundStyleApplicator.setBorderColor((View)this, LogicalEdge.ALL, borderColor);
    }

    public final void setOverlayColor(int overlayColor) {
        if (this.overlayColor != overlayColor) {
            this.overlayColor = overlayColor;
            this.isDirty = true;
        }
    }

    public final void setBorderWidth(float borderWidth) {
        BackgroundStyleApplicator.setBorderWidth((View)this, LogicalEdge.ALL, Float.valueOf(borderWidth));
    }

    public final void setBorderRadius(float borderRadius) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.INSTANCE.pxToDp(borderRadius), LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.BORDER_RADIUS, radius);
    }

    public final void setBorderRadius(float borderRadius, int position) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.INSTANCE.pxToDp(borderRadius), LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.values()[position], radius);
    }

    public final void setScaleType(@NotNull ScalingUtils.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        if (this.scaleType != scaleType) {
            this.scaleType = scaleType;
            this.isDirty = true;
        }
    }

    public final void setTileMode(@NotNull Shader.TileMode tileMode) {
        Intrinsics.checkNotNullParameter((Object)tileMode, (String)"tileMode");
        if (this.tileMode != tileMode) {
            this.tileMode = tileMode;
            this.tilePostprocessor = this.isTiled() ? new TilePostprocessor() : null;
            this.isDirty = true;
        }
    }

    public final void setResizeMethod(@NotNull ImageResizeMethod resizeMethod) {
        Intrinsics.checkNotNullParameter((Object)((Object)resizeMethod), (String)"resizeMethod");
        if (this.resizeMethod != resizeMethod) {
            this.resizeMethod = resizeMethod;
            this.isDirty = true;
        }
    }

    public final void setResizeMultiplier(float multiplier) {
        boolean isNewMultiplier;
        boolean bl = isNewMultiplier = Math.abs((double)(this.resizeMultiplier - multiplier)) > (double)1.0E-4f;
        if (isNewMultiplier) {
            this.resizeMultiplier = multiplier;
            this.isDirty = true;
        }
    }

    public final void setSource(@Nullable ReadableArray sources) {
        List tmpSources = new ArrayList();
        if (sources == null || sources.size() == 0) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            tmpSources.add(ImageSource.Companion.getTransparentBitmapImageSource(context));
        } else if (sources.size() == 1) {
            ReadableMap readableMap = sources.getMap(0);
            if (readableMap == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            ReadableMap source2 = readableMap;
            ImageCacheControl cacheControl = this.computeCacheControl(source2.getString("cache"));
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            ImageSource imageSource = new ImageSource(context, source2.getString("uri"), 0.0, 0.0, cacheControl, 12, null);
            if (Intrinsics.areEqual((Object)Uri.EMPTY, (Object)imageSource.getUri())) {
                this.warnImageSource(source2.getString("uri"));
                Context context2 = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
                imageSource = ImageSource.Companion.getTransparentBitmapImageSource(context2);
            }
            tmpSources.add(imageSource);
        } else {
            int n = sources.size();
            for (int idx = 0; idx < n; ++idx) {
                ReadableMap source3;
                if (sources.getMap(idx) == null) continue;
                ImageCacheControl cacheControl = this.computeCacheControl(source3.getString("cache"));
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                ImageSource imageSource = new ImageSource(context, source3.getString("uri"), source3.getDouble("width"), source3.getDouble("height"), cacheControl);
                if (Intrinsics.areEqual((Object)Uri.EMPTY, (Object)imageSource.getUri())) {
                    this.warnImageSource(source3.getString("uri"));
                    Context context3 = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
                    imageSource = ImageSource.Companion.getTransparentBitmapImageSource(context3);
                }
                tmpSources.add(imageSource);
            }
        }
        if (Intrinsics.areEqual(this.sources, (Object)tmpSources)) {
            return;
        }
        this.sources.clear();
        this.sources.addAll(tmpSources);
        this.isDirty = true;
    }

    /*
     * Unable to fully structure code
     */
    private final ImageCacheControl computeCacheControl(String cacheControl) {
        var2_2 = cacheControl;
        if (var2_2 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var2_2.hashCode()) {
            case 706834161: {
                if (var2_2.equals("only-if-cached")) {
                    tmp = 1;
                }
                break;
            }
            case 1544803905: {
                if (var2_2.equals("default")) {
                    tmp = 2;
                }
                break;
            }
            case -934641255: {
                if (var2_2.equals("reload")) {
                    tmp = 3;
                }
                break;
            }
            case -1564134880: {
                if (var2_2.equals("force-cache")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: lbl-1000:
            // 2 sources

            {
                v0 = ImageCacheControl.DEFAULT;
                break;
            }
            case 3: {
                v0 = ImageCacheControl.RELOAD;
                break;
            }
            case 4: {
                v0 = ImageCacheControl.FORCE_CACHE;
                break;
            }
            case 1: {
                v0 = ImageCacheControl.ONLY_IF_CACHED;
                break;
            }
            default: {
                v0 = ImageCacheControl.DEFAULT;
            }
        }
        return v0;
    }

    private final ImageRequest.RequestLevel computeRequestLevel(ImageCacheControl cacheControl) {
        return WhenMappings.$EnumSwitchMapping$0[cacheControl.ordinal()] == 1 ? ImageRequest.RequestLevel.DISK_CACHE : ImageRequest.RequestLevel.FULL_FETCH;
    }

    public final void setDefaultSource(@Nullable String name) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Drawable newDefaultDrawable = ResourceDrawableIdHelper.getResourceDrawable(context, name);
        if (!Intrinsics.areEqual((Object)this.defaultImageDrawable, (Object)newDefaultDrawable)) {
            this.defaultImageDrawable = newDefaultDrawable;
            this.isDirty = true;
        }
    }

    public final void setLoadingIndicatorSource(@Nullable String name) {
        AutoRotateDrawable newLoadingIndicatorSource;
        Drawable drawable2;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Drawable drawable3 = drawable2 = ResourceDrawableIdHelper.getResourceDrawable(context, name);
        if (drawable3 != null) {
            Drawable it = drawable3;
            boolean bl = false;
            v2 = new AutoRotateDrawable(it, 1000);
        } else {
            v2 = newLoadingIndicatorSource = null;
        }
        if (!Intrinsics.areEqual((Object)this.loadingImageDrawable, (Object)newLoadingIndicatorSource)) {
            this.loadingImageDrawable = (Drawable)newLoadingIndicatorSource;
            this.isDirty = true;
        }
    }

    public final void setProgressiveRenderingEnabled(boolean enabled) {
        this.progressiveRenderingEnabled = enabled;
    }

    public final void setFadeDuration(int durationMs) {
        this.fadeDurationMs = durationMs;
    }

    public final void setHeaders(@Nullable ReadableMap headers) {
        this.headers = headers;
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    public void onDraw(@NotNull Canvas canvas) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
            try {
                super.onDraw(canvas);
            }
            catch (RuntimeException e) {
                EventDispatcher eventDispatcher;
                if (this.downloadListener == null) break block3;
                Context context = this.getContext();
                Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
                EventDispatcher eventDispatcher2 = eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)context, this.getId());
                if (eventDispatcher2 != null) {
                    eventDispatcher2.dispatchEvent(ImageLoadEvent.Companion.createErrorEvent(UIManagerHelper.getSurfaceId((View)this), this.getId(), e));
                }
            }
        }
    }

    public final void maybeUpdateView() {
        RoundingParams roundingParams;
        if (!this.isDirty) {
            return;
        }
        if (this.hasMultipleSources() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        this.setSourceImage();
        ImageSource imageSource = this.imageSource;
        if (imageSource == null) {
            return;
        }
        ImageSource imageSourceSafe = imageSource;
        boolean doResize = this.shouldResize(imageSourceSafe);
        if (doResize && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        if (this.isTiled() && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        GenericDraweeHierarchy hierarchy = (GenericDraweeHierarchy)this.getHierarchy();
        hierarchy.setActualImageScaleType(this.scaleType);
        if (this.defaultImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.defaultImageDrawable, this.scaleType);
        }
        if (this.loadingImageDrawable != null) {
            hierarchy.setPlaceholderImage(this.loadingImageDrawable, ScalingUtils.ScaleType.CENTER);
        }
        if ((roundingParams = hierarchy.getRoundingParams()) != null) {
            RoundingParams roundingParams2 = this.overlayColor != 0 ? roundingParams.setOverlayColor(this.overlayColor) : roundingParams.setRoundingMethod(RoundingParams.RoundingMethod.BITMAP_ONLY);
            hierarchy.setRoundingParams(roundingParams);
        }
        hierarchy.setFadeDuration(this.fadeDurationMs >= 0 ? this.fadeDurationMs : (imageSourceSafe.isResource() ? 0 : 300));
        this.maybeUpdateViewFromRequest(doResize);
        this.isDirty = false;
    }

    private final void maybeUpdateViewFromRequest(boolean doResize) {
        ResizeOptions resizeOptions;
        Object it;
        ImageSource imageSource = this.imageSource;
        if (imageSource == null) {
            return;
        }
        ImageSource imageSource2 = imageSource;
        Uri uri = imageSource2.getUri();
        ImageCacheControl cacheControl = imageSource2.getCacheControl();
        ImageRequest.RequestLevel requestLevel = this.computeRequestLevel(cacheControl);
        List postprocessorList = new ArrayList();
        IterativeBoxBlurPostProcessor iterativeBoxBlurPostProcessor = this.iterativeBoxBlurPostProcessor;
        if (iterativeBoxBlurPostProcessor != null) {
            it = iterativeBoxBlurPostProcessor;
            boolean bl = false;
            postprocessorList.add(it);
        }
        TilePostprocessor tilePostprocessor = this.tilePostprocessor;
        if (tilePostprocessor != null) {
            it = tilePostprocessor;
            boolean bl = false;
            postprocessorList.add(it);
        }
        Postprocessor postprocessor = MultiPostprocessor.Companion.from(postprocessorList);
        ResizeOptions resizeOptions2 = resizeOptions = doResize ? this.getResizeOptions() : null;
        if (cacheControl == ImageCacheControl.RELOAD) {
            ImagePipeline imagePipeline = Fresco.getImagePipeline();
            imagePipeline.evictFromCache(uri);
        }
        ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)uri).setPostprocessor(postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.progressiveRenderingEnabled).setLowestPermittedRequestLevel(requestLevel);
        if (this.resizeMethod == ImageResizeMethod.NONE) {
            imageRequestBuilder.setDownsampleOverride(DownsampleMode.NEVER);
        }
        Intrinsics.checkNotNull((Object)imageRequestBuilder);
        ImageRequest imageRequest = ReactNetworkImageRequest.Companion.fromBuilderWithHeaders(imageRequestBuilder, this.headers, cacheControl);
        GlobalImageLoadListener globalImageLoadListener = this.globalImageLoadListener;
        if (globalImageLoadListener != null) {
            globalImageLoadListener.onLoadAttempt(uri);
        }
        AbstractDraweeControllerBuilder<?, ?, ?, ?> abstractDraweeControllerBuilder = this.draweeControllerBuilder;
        Intrinsics.checkNotNull(abstractDraweeControllerBuilder, (String)"null cannot be cast to non-null type com.facebook.drawee.controller.AbstractDraweeControllerBuilder<*, com.facebook.imagepipeline.request.ImageRequest, com.facebook.common.references.CloseableReference<com.facebook.imagepipeline.image.CloseableImage>, com.facebook.imagepipeline.image.ImageInfo>");
        AbstractDraweeControllerBuilder<?, ?, ?, ?> builder = abstractDraweeControllerBuilder;
        builder.reset();
        builder.setImageRequest((Object)imageRequest).setAutoPlayAnimations(true).setOldController(this.getController());
        Object object = this.callerContext;
        if (object != null) {
            Object it2 = object;
            boolean bl = false;
            AbstractDraweeControllerBuilder abstractDraweeControllerBuilder2 = builder.setCallerContext(it2);
            v8 = abstractDraweeControllerBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)abstractDraweeControllerBuilder2, (String)"setCallerContext(...)");
        } else {
            v8 = null;
        }
        ImageSource imageSource3 = this.cachedImageSource;
        if (imageSource3 != null) {
            ImageSource cachedSource = imageSource3;
            boolean bl = false;
            ImageRequestBuilder cachedImageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)cachedSource.getUri()).setPostprocessor(postprocessor).setResizeOptions(resizeOptions).setAutoRotateEnabled(true).setProgressiveRenderingEnabled(this.progressiveRenderingEnabled);
            if (this.resizeMethod == ImageResizeMethod.NONE) {
                cachedImageRequestBuilder.setDownsampleOverride(DownsampleMode.NEVER);
            }
            AbstractDraweeControllerBuilder abstractDraweeControllerBuilder3 = builder.setLowResImageRequest((Object)cachedImageRequestBuilder.build());
            v11 = abstractDraweeControllerBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)abstractDraweeControllerBuilder3, (String)"setLowResImageRequest(...)");
        } else {
            v11 = null;
        }
        if (this.downloadListener != null && this.controllerForTesting != null) {
            ForwardingControllerListener combinedListener = new ForwardingControllerListener();
            combinedListener.addListener((ControllerListener)this.downloadListener);
            combinedListener.addListener(this.controllerForTesting);
            builder.setControllerListener((ControllerListener)combinedListener);
        } else if (this.controllerForTesting != null) {
            builder.setControllerListener(this.controllerForTesting);
        } else if (this.downloadListener != null) {
            builder.setControllerListener((ControllerListener)this.downloadListener);
        }
        if (this.downloadListener != null) {
            ((GenericDraweeHierarchy)this.getHierarchy()).setProgressBarImage((Drawable)this.downloadListener);
        }
        this.setController((DraweeController)builder.build());
        builder.reset();
    }

    @VisibleForTesting
    public final void setControllerListener(@Nullable ControllerListener<ImageInfo> controllerListener) {
        this.controllerForTesting = controllerListener;
        this.isDirty = true;
        this.maybeUpdateView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.isDirty = this.isDirty || this.hasMultipleSources() || this.isTiled();
            this.maybeUpdateView();
        }
    }

    private final boolean hasMultipleSources() {
        return this.sources.size() > 1;
    }

    private final boolean isTiled() {
        return this.tileMode != Shader.TileMode.CLAMP;
    }

    private final void setSourceImage() {
        this.imageSource = null;
        if (this.sources.isEmpty()) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.sources.add(ImageSource.Companion.getTransparentBitmapImageSource(context));
        } else if (this.hasMultipleSources()) {
            MultiSourceHelper.MultiSourceResult multiSource = MultiSourceHelper.getBestSourceForSize(this.getWidth(), this.getHeight(), this.sources);
            this.imageSource = multiSource.bestResult;
            this.cachedImageSource = multiSource.bestResultInCache;
            return;
        }
        this.imageSource = this.sources.get(0);
    }

    private final boolean shouldResize(ImageSource imageSource) {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.resizeMethod.ordinal()]) {
            case 1 -> {
                if (UriUtil.isLocalContentUri((Uri)imageSource.getUri()) || UriUtil.isLocalFileUri((Uri)imageSource.getUri())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> true;
            default -> false;
        };
    }

    private final ResizeOptions getResizeOptions() {
        int width = Math.round((float)this.getWidth() * this.resizeMultiplier);
        int height = Math.round((float)this.getHeight() * this.resizeMultiplier);
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new ResizeOptions(width, height, 0.0f, 0.0f, 12, null);
    }

    private final void warnImageSource(String uri) {
        if (ReactBuildConfig.DEBUG && !ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture()) {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            RNLog.w((ReactContext)context, "ReactImageView: Image source \"" + uri + "\" doesn't exist");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/views/image/ReactImageView$Companion;", "", "<init>", "()V", "REMOTE_IMAGE_FADE_DURATION_MS", "", "tileMatrix", "Landroid/graphics/Matrix;", "buildHierarchy", "Lcom/facebook/drawee/generic/GenericDraweeHierarchy;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nReactImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactImageView.kt\ncom/facebook/react/views/image/ReactImageView$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,630:1\n1#2:631\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final GenericDraweeHierarchy buildHierarchy(Context context) {
            void $this$buildHierarchy_u24lambda_u240;
            RoundingParams roundingParams;
            RoundingParams roundingParams2 = roundingParams = RoundingParams.fromCornersRadius((float)0.0f);
            GenericDraweeHierarchyBuilder genericDraweeHierarchyBuilder = new GenericDraweeHierarchyBuilder(context.getResources());
            boolean bl = false;
            $this$buildHierarchy_u24lambda_u240.setPaintFilterBitmap(true);
            GenericDraweeHierarchy genericDraweeHierarchy = genericDraweeHierarchyBuilder.setRoundingParams(roundingParams).build();
            Intrinsics.checkNotNullExpressionValue((Object)genericDraweeHierarchy, (String)"build(...)");
            return genericDraweeHierarchy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/facebook/react/views/image/ReactImageView$TilePostprocessor;", "Lcom/facebook/imagepipeline/request/BasePostprocessor;", "<init>", "(Lcom/facebook/react/views/image/ReactImageView;)V", "process", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "source", "bitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "ReactAndroid_release"})
    private final class TilePostprocessor
    extends BasePostprocessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public CloseableReference<Bitmap> process(@NotNull Bitmap source2, @NotNull PlatformBitmapFactory bitmapFactory) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)bitmapFactory, (String)"bitmapFactory");
            Rect destRect = new Rect(0, 0, ReactImageView.this.getWidth(), ReactImageView.this.getHeight());
            ReactImageView.this.scaleType.getTransform(tileMatrix, destRect, source2.getWidth(), source2.getHeight(), 0.0f, 0.0f);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            Shader shader = (Shader)new BitmapShader(source2, ReactImageView.this.tileMode, ReactImageView.this.tileMode);
            shader.setLocalMatrix(tileMatrix);
            paint.setShader(shader);
            CloseableReference closeableReference = bitmapFactory.createBitmap(ReactImageView.this.getWidth(), ReactImageView.this.getHeight());
            Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"createBitmap(...)");
            CloseableReference output = closeableReference;
            try {
                Canvas canvas = new Canvas((Bitmap)output.get());
                canvas.drawRect(destRect, paint);
                CloseableReference closeableReference2 = output.clone();
                Intrinsics.checkNotNullExpressionValue((Object)closeableReference2, (String)"clone(...)");
                CloseableReference closeableReference3 = closeableReference2;
                return closeableReference3;
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)output);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ImageCacheControl.values().length];
            try {
                nArray[ImageCacheControl.ONLY_IF_CACHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageResizeMethod.values().length];
            try {
                nArray[ImageResizeMethod.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageResizeMethod.RESIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

