/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.graphics.Shader;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.react.views.image.ScaleTypeStartInside;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/image/ImageResizeMode;", "", "<init>", "()V", "RESIZE_MODE_CONTAIN", "", "RESIZE_MODE_COVER", "RESIZE_MODE_STRETCH", "RESIZE_MODE_CENTER", "RESIZE_MODE_REPEAT", "RESIZE_MODE_NONE", "toScaleType", "Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "resizeModeValue", "toTileMode", "Landroid/graphics/Shader$TileMode;", "defaultValue", "defaultTileMode", "ReactAndroid_release"})
public final class ImageResizeMode {
    @NotNull
    public static final ImageResizeMode INSTANCE = new ImageResizeMode();
    @NotNull
    private static final String RESIZE_MODE_CONTAIN = "contain";
    @NotNull
    private static final String RESIZE_MODE_COVER = "cover";
    @NotNull
    private static final String RESIZE_MODE_STRETCH = "stretch";
    @NotNull
    private static final String RESIZE_MODE_CENTER = "center";
    @NotNull
    private static final String RESIZE_MODE_REPEAT = "repeat";
    @NotNull
    private static final String RESIZE_MODE_NONE = "none";

    private ImageResizeMode() {
    }

    @JvmStatic
    @NotNull
    public static final ScalingUtils.ScaleType toScaleType(@Nullable String resizeModeValue) {
        block23: {
            String string2 = resizeModeValue;
            if (string2 == null) break block23;
            int n = -1;
            switch (string2.hashCode()) {
                case 94852023: {
                    if (string2.equals(RESIZE_MODE_COVER)) {
                        n = 1;
                    }
                    break;
                }
                case -1881872635: {
                    if (string2.equals(RESIZE_MODE_STRETCH)) {
                        n = 2;
                    }
                    break;
                }
                case 951526612: {
                    if (string2.equals(RESIZE_MODE_CONTAIN)) {
                        n = 3;
                    }
                    break;
                }
                case -1364013995: {
                    if (string2.equals(RESIZE_MODE_CENTER)) {
                        n = 4;
                    }
                    break;
                }
                case -934531685: {
                    if (string2.equals(RESIZE_MODE_REPEAT)) {
                        n = 5;
                    }
                    break;
                }
                case 3387192: {
                    if (string2.equals(RESIZE_MODE_NONE)) {
                        n = 6;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    ScalingUtils.ScaleType scaleType = ScalingUtils.ScaleType.FIT_CENTER;
                    Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"FIT_CENTER");
                    return scaleType;
                }
                case 1: {
                    ScalingUtils.ScaleType scaleType = ScalingUtils.ScaleType.CENTER_CROP;
                    Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"CENTER_CROP");
                    return scaleType;
                }
                case 2: {
                    ScalingUtils.ScaleType scaleType = ScalingUtils.ScaleType.FIT_XY;
                    Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"FIT_XY");
                    return scaleType;
                }
                case 4: {
                    ScalingUtils.ScaleType scaleType = ScalingUtils.ScaleType.CENTER_INSIDE;
                    Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"CENTER_INSIDE");
                    return scaleType;
                }
                case 5: {
                    return ScaleTypeStartInside.Companion.getINSTANCE();
                }
                case 6: {
                    return ScaleTypeStartInside.Companion.getINSTANCE();
                }
            }
        }
        if (resizeModeValue != null) {
            FLog.w((String)"ReactNative", (String)("Invalid resize mode: '" + resizeModeValue + "'"));
        }
        return INSTANCE.defaultValue();
    }

    @JvmStatic
    @NotNull
    public static final Shader.TileMode toTileMode(@Nullable String resizeModeValue) {
        if (Intrinsics.areEqual((Object)RESIZE_MODE_CONTAIN, (Object)resizeModeValue) || Intrinsics.areEqual((Object)RESIZE_MODE_COVER, (Object)resizeModeValue) || Intrinsics.areEqual((Object)RESIZE_MODE_STRETCH, (Object)resizeModeValue) || Intrinsics.areEqual((Object)RESIZE_MODE_CENTER, (Object)resizeModeValue) || Intrinsics.areEqual((Object)RESIZE_MODE_NONE, (Object)resizeModeValue)) {
            return Shader.TileMode.CLAMP;
        }
        if (Intrinsics.areEqual((Object)RESIZE_MODE_REPEAT, (Object)resizeModeValue)) {
            return Shader.TileMode.REPEAT;
        }
        if (resizeModeValue != null) {
            FLog.w((String)"ReactNative", (String)("Invalid resize mode: '" + resizeModeValue + "'"));
        }
        return INSTANCE.defaultTileMode();
    }

    @JvmStatic
    @NotNull
    public static final ScalingUtils.ScaleType defaultValue() {
        ScalingUtils.ScaleType scaleType = ScalingUtils.ScaleType.CENTER_CROP;
        Intrinsics.checkNotNullExpressionValue((Object)scaleType, (String)"CENTER_CROP");
        return scaleType;
    }

    @JvmStatic
    @NotNull
    public static final Shader.TileMode defaultTileMode() {
        return Shader.TileMode.CLAMP;
    }
}

