/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import androidx.core.graphics.ColorUtils;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.style.ColorStop;
import com.facebook.react.uimanager.style.ProcessedColorStop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nJ!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/uimanager/style/ColorStopUtils;", "", "<init>", "()V", "getFixedColorStops", "", "Lcom/facebook/react/uimanager/style/ProcessedColorStop;", "colorStops", "Lcom/facebook/react/uimanager/style/ColorStop;", "gradientLineLength", "", "processColorTransitionHints", "originalStops", "", "([Lcom/facebook/react/uimanager/style/ProcessedColorStop;)Ljava/util/List;", "resolveColorStopPosition", "position", "Lcom/facebook/react/uimanager/LengthPercentage;", "(Lcom/facebook/react/uimanager/LengthPercentage;F)Ljava/lang/Float;", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nColorStop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorStop.kt\ncom/facebook/react/uimanager/style/ColorStopUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class ColorStopUtils {
    @NotNull
    public static final ColorStopUtils INSTANCE = new ColorStopUtils();

    private ColorStopUtils() {
    }

    @NotNull
    public final List<ProcessedColorStop> getFixedColorStops(@NotNull List<ColorStop> colorStops, float gradientLineLength) {
        int n;
        Intrinsics.checkNotNullParameter(colorStops, (String)"colorStops");
        int n2 = 0;
        int n3 = colorStops.size();
        ProcessedColorStop[] processedColorStopArray = new ProcessedColorStop[n3];
        while (n2 < n3) {
            n = n2++;
            processedColorStopArray[n] = new ProcessedColorStop(null, null, 3, null);
        }
        ProcessedColorStop[] fixedColorStops = processedColorStopArray;
        boolean hasNullPositions = false;
        Float f = this.resolveColorStopPosition(colorStops.get(0).getPosition(), gradientLineLength);
        float maxPositionSoFar = f != null ? f.floatValue() : 0.0f;
        n = ((Collection)colorStops).size();
        for (int i = 0; i < n; ++i) {
            ColorStop colorStop = colorStops.get(i);
            Float newPosition = this.resolveColorStopPosition(colorStop.getPosition(), gradientLineLength);
            Float f2 = newPosition;
            if (f2 == null) {
                int n4 = i;
                f2 = n4 == 0 ? Float.valueOf(0.0f) : (n4 == colorStops.size() - 1 ? Float.valueOf(1.0f) : null);
            }
            if ((newPosition = f2) != null) {
                newPosition = Float.valueOf(Math.max(newPosition.floatValue(), maxPositionSoFar));
                fixedColorStops[i] = new ProcessedColorStop(colorStop.getColor(), newPosition);
                maxPositionSoFar = newPosition.floatValue();
                continue;
            }
            hasNullPositions = true;
        }
        if (hasNullPositions) {
            int lastDefinedIndex = 0;
            int n5 = fixedColorStops.length;
            for (int i = 1; i < n5; ++i) {
                Float endPosition = fixedColorStops[i].getPosition();
                Float startPosition = fixedColorStops[lastDefinedIndex].getPosition();
                int unpositionedStops = i - lastDefinedIndex - 1;
                if (endPosition == null || startPosition == null || unpositionedStops <= 0) continue;
                float increment = (endPosition.floatValue() - startPosition.floatValue()) / (float)(unpositionedStops + 1);
                int j = 1;
                if (j <= unpositionedStops) {
                    while (true) {
                        fixedColorStops[lastDefinedIndex + j] = new ProcessedColorStop(colorStops.get(lastDefinedIndex + j).getColor(), Float.valueOf(startPosition.floatValue() + increment * (float)j));
                        if (j == unpositionedStops) break;
                        ++j;
                    }
                }
                lastDefinedIndex = i;
            }
        }
        return this.processColorTransitionHints(fixedColorStops);
    }

    private final List<ProcessedColorStop> processColorTransitionHints(ProcessedColorStop[] originalStops) {
        List colorStops = ArraysKt.toMutableList((Object[])originalStops);
        int indexOffset = 0;
        int n = originalStops.length - 1;
        for (int i = 1; i < n; ++i) {
            Iterator iterator2;
            int x;
            if (originalStops[i].getColor() != null || (x = i + indexOffset) < 1) continue;
            Float offsetLeft = ((ProcessedColorStop)colorStops.get(x - 1)).getPosition();
            Float offsetRight = ((ProcessedColorStop)colorStops.get(x + 1)).getPosition();
            Float offset = ((ProcessedColorStop)colorStops.get(x)).getPosition();
            if (offsetLeft == null || offsetRight == null || offset == null) continue;
            float leftDist = offset.floatValue() - offsetLeft.floatValue();
            float rightDist = offsetRight.floatValue() - offset.floatValue();
            float totalDist = offsetRight.floatValue() - offsetLeft.floatValue();
            Integer leftColor = ((ProcessedColorStop)colorStops.get(x - 1)).getColor();
            Integer rightColor = ((ProcessedColorStop)colorStops.get(x + 1)).getColor();
            if (FloatUtil.floatsEqual(leftDist, rightDist)) {
                colorStops.remove(x);
                --indexOffset;
                continue;
            }
            if (FloatUtil.floatsEqual(leftDist, 0.0f)) {
                ((ProcessedColorStop)colorStops.get(x)).setColor(rightColor);
                continue;
            }
            if (FloatUtil.floatsEqual(rightDist, 0.0f)) {
                ((ProcessedColorStop)colorStops.get(x)).setColor(leftColor);
                continue;
            }
            ArrayList<ProcessedColorStop> newStops = new ArrayList<ProcessedColorStop>(9);
            if (leftDist > rightDist) {
                for (y = 0; y < 7; ++y) {
                    newStops.add(new ProcessedColorStop(null, Float.valueOf(offsetLeft.floatValue() + leftDist * ((7.0f + (float)y) / 13.0f))));
                }
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offset.floatValue() + rightDist * 0.33333334f)));
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offset.floatValue() + rightDist * 0.6666667f)));
            } else {
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offsetLeft.floatValue() + leftDist * 0.33333334f)));
                newStops.add(new ProcessedColorStop(null, Float.valueOf(offsetLeft.floatValue() + leftDist * 0.6666667f)));
                for (y = 0; y < 7; ++y) {
                    newStops.add(new ProcessedColorStop(null, Float.valueOf(offset.floatValue() + rightDist * ((float)y / 13.0f))));
                }
            }
            float hintRelativeOffset = leftDist / totalDist;
            double logRatio = Math.log(0.5) / (double)((float)Math.log(hintRelativeOffset));
            Intrinsics.checkNotNullExpressionValue(newStops.iterator(), (String)"iterator(...)");
            while (iterator2.hasNext()) {
                float pointRelativeOffset;
                float weighting;
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                ProcessedColorStop newStop = (ProcessedColorStop)e;
                if (newStop.getPosition() == null || !(Math.abs(weighting = (float)Math.pow(pointRelativeOffset = (newStop.getPosition().floatValue() - offsetLeft.floatValue()) / totalDist, logRatio)) <= Float.MAX_VALUE) || Float.isNaN(weighting)) continue;
                Integer n2 = leftColor;
                if (n2 == null) continue;
                int left = ((Number)n2).intValue();
                boolean bl = false;
                Integer n3 = rightColor;
                if (n3 == null) continue;
                int right = ((Number)n3).intValue();
                boolean bl2 = false;
                newStop.setColor(ColorUtils.blendARGB((int)left, (int)right, (float)weighting));
            }
            colorStops.remove(x);
            colorStops.addAll(x, (Collection)newStops);
            indexOffset += 8;
        }
        return colorStops;
    }

    private final Float resolveColorStopPosition(LengthPercentage position, float gradientLineLength) {
        if (position == null) {
            return null;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[position.getType().ordinal()]) {
            case 1 -> Float.valueOf(PixelUtil.toPixelFromDIP(position.resolve(0.0f)) / gradientLineLength);
            case 2 -> Float.valueOf(position.resolve(1.0f));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LengthPercentageType.values().length];
            try {
                nArray[LengthPercentageType.POINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LengthPercentageType.PERCENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

