/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/OpacityAnimation;", "Landroid/view/animation/Animation;", "view", "Landroid/view/View;", "startOpacity", "", "endOpacity", "<init>", "(Landroid/view/View;FF)V", "viewRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "deltaOpacity", "applyTransformation", "", "interpolatedTime", "t", "Landroid/view/animation/Transformation;", "willChangeBounds", "", "OpacityAnimationListener", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nOpacityAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpacityAnimation.kt\ncom/facebook/react/uimanager/layoutanimation/OpacityAnimation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class OpacityAnimation
extends Animation {
    private final float startOpacity;
    @NotNull
    private final WeakReference<View> viewRef;
    private final float deltaOpacity;

    public OpacityAnimation(@NotNull View view, float startOpacity, float endOpacity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.startOpacity = startOpacity;
        this.viewRef = new WeakReference<View>(view);
        this.deltaOpacity = endOpacity - this.startOpacity;
        this.setAnimationListener(new OpacityAnimationListener(view));
        LegacyArchitectureLogger.assertLegacyArchitecture("OpacityAnimation", LegacyArchitectureLogLevel.ERROR);
    }

    @VisibleForTesting
    public void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            View view = (View)this.viewRef.get();
            if (view == null) break block0;
            View view2 = view;
            boolean bl = false;
            view2.setAlpha(this.startOpacity + this.deltaOpacity * interpolatedTime);
        }
    }

    public boolean willChangeBounds() {
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/OpacityAnimation$OpacityAnimationListener;", "Landroid/view/animation/Animation$AnimationListener;", "view", "Landroid/view/View;", "<init>", "(Landroid/view/View;)V", "viewRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "layerTypeChanged", "", "onAnimationStart", "", "animation", "Landroid/view/animation/Animation;", "onAnimationEnd", "onAnimationRepeat", "ReactAndroid_release"})
    public static final class OpacityAnimationListener
    implements Animation.AnimationListener {
        @NotNull
        private final WeakReference<View> viewRef;
        private boolean layerTypeChanged;

        public OpacityAnimationListener(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.viewRef = new WeakReference<View>(view);
        }

        public void onAnimationStart(@NotNull Animation animation) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                View view = (View)this.viewRef.get();
                if (view == null) break block1;
                View view2 = view;
                boolean bl = false;
                if (view2.hasOverlappingRendering() && view2.getLayerType() == 0) {
                    this.layerTypeChanged = true;
                    view2.setLayerType(2, null);
                }
            }
        }

        public void onAnimationEnd(@NotNull Animation animation) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                View view = (View)this.viewRef.get();
                if (view == null) break block1;
                View view2 = view;
                boolean bl = false;
                if (this.layerTypeChanged) {
                    view2.setLayerType(0, null);
                }
            }
        }

        public void onAnimationRepeat(@NotNull Animation animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        }
    }
}

