/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.internal;

import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.common.annotations.LegacyArchitectureShadowNodeWithCxxImpl;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.util.RNLog;
import com.facebook.yoga.YogaMeasureFunction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/facebook/react/uimanager/internal/LegacyArchitectureShadowNodeLogger;", "", "<init>", "()V", "assertUnsupportedViewManager", "", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "shadowNodeClass", "Ljava/lang/Class;", "viewManagerName", "", "ReactAndroid_release"})
public final class LegacyArchitectureShadowNodeLogger {
    @NotNull
    public static final LegacyArchitectureShadowNodeLogger INSTANCE = new LegacyArchitectureShadowNodeLogger();

    private LegacyArchitectureShadowNodeLogger() {
    }

    @JvmStatic
    public static final void assertUnsupportedViewManager(@NotNull ReactApplicationContext reactContext, @NotNull Class<?> shadowNodeClass, @NotNull String viewManagerName) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter(shadowNodeClass, (String)"shadowNodeClass");
        Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
        Class<?>[] classArray = shadowNodeClass.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
        boolean implementsYogaMeasureFunction = ArraysKt.contains((Object[])classArray, YogaMeasureFunction.class);
        boolean annotatedWithCxxImpl = shadowNodeClass.isAnnotationPresent(LegacyArchitectureShadowNodeWithCxxImpl.class);
        if (implementsYogaMeasureFunction && !annotatedWithCxxImpl) {
            String message = StringsKt.trimIndent((String)("\n              [Legacy Architecture] The ViewManager `" + viewManagerName + "` is unlikely to work with the New Architecture.\n              That's because the shadow node `" + shadowNodeClass.getSimpleName() + "` implements the `YogaMeasureFunction.measure()` method.\n              This is not supported in the New Architecture as shadow nodes with custom measurements should be implemented in C++.\n              "));
            if (ReactBuildConfig.DEBUG) {
                RNLog.w(reactContext, message);
                ReactSoftExceptionLogger.logSoftException("SoftAssertions", new ReactNoCrashSoftException(message));
            }
        }
    }
}

