/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.drawable.BackgroundDrawable;
import com.facebook.react.uimanager.drawable.BorderDrawable;
import com.facebook.react.uimanager.drawable.CSSBackgroundDrawable;
import com.facebook.react.uimanager.drawable.OutlineDrawable;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\u008f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010.\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010/\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\"\u00100\u001a\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u00103\u001a\u00020\u00002\b\u00104\u001a\u0004\u0018\u00010\u0005J\u0010\u0010$\u001a\u0002052\u0006\u0010\u0010\u001a\u000206H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u00068"}, d2={"Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable;", "Landroid/graphics/drawable/LayerDrawable;", "context", "Landroid/content/Context;", "originalBackground", "Landroid/graphics/drawable/Drawable;", "outerShadows", "", "cssBackground", "Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "background", "Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "border", "Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "feedbackUnderlay", "innerShadows", "outline", "Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "borderInsets", "Lcom/facebook/react/uimanager/style/BorderInsets;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "<init>", "(Landroid/content/Context;Landroid/graphics/drawable/Drawable;Ljava/util/List;Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;Lcom/facebook/react/uimanager/drawable/BorderDrawable;Landroid/graphics/drawable/Drawable;Ljava/util/List;Lcom/facebook/react/uimanager/drawable/OutlineDrawable;Lcom/facebook/react/uimanager/style/BorderInsets;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "getOriginalBackground", "()Landroid/graphics/drawable/Drawable;", "getOuterShadows", "()Ljava/util/List;", "getCssBackground", "()Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "getBackground", "()Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "getBorder", "()Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "getFeedbackUnderlay", "getInnerShadows", "getOutline", "()Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "getBorderInsets", "()Lcom/facebook/react/uimanager/style/BorderInsets;", "setBorderInsets", "(Lcom/facebook/react/uimanager/style/BorderInsets;)V", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "withNewCssBackground", "withNewBackground", "withNewShadows", "withNewBorder", "withNewOutline", "withNewFeedbackUnderlay", "newUnderlay", "", "Landroid/graphics/Outline;", "Companion", "ReactAndroid_release"})
public final class CompositeBackgroundDrawable
extends LayerDrawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final Drawable originalBackground;
    @NotNull
    private final List<Drawable> outerShadows;
    @Nullable
    private final CSSBackgroundDrawable cssBackground;
    @Nullable
    private final BackgroundDrawable background;
    @Nullable
    private final BorderDrawable border;
    @Nullable
    private final Drawable feedbackUnderlay;
    @NotNull
    private final List<Drawable> innerShadows;
    @Nullable
    private final OutlineDrawable outline;
    @Nullable
    private BorderInsets borderInsets;
    @Nullable
    private BorderRadiusStyle borderRadius;

    public CompositeBackgroundDrawable(@NotNull Context context, @Nullable Drawable originalBackground, @NotNull List<? extends Drawable> outerShadows, @Nullable CSSBackgroundDrawable cssBackground, @Nullable BackgroundDrawable background, @Nullable BorderDrawable border, @Nullable Drawable feedbackUnderlay, @NotNull List<? extends Drawable> innerShadows, @Nullable OutlineDrawable outline, @Nullable BorderInsets borderInsets, @Nullable BorderRadiusStyle borderRadius) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(outerShadows, (String)"outerShadows");
        Intrinsics.checkNotNullParameter(innerShadows, (String)"innerShadows");
        super(CompositeBackgroundDrawable.Companion.createLayersArray(originalBackground, outerShadows, cssBackground, background, border, feedbackUnderlay, innerShadows, outline));
        this.context = context;
        this.originalBackground = originalBackground;
        this.outerShadows = outerShadows;
        this.cssBackground = cssBackground;
        this.background = background;
        this.border = border;
        this.feedbackUnderlay = feedbackUnderlay;
        this.innerShadows = innerShadows;
        this.outline = outline;
        this.borderInsets = borderInsets;
        this.borderRadius = borderRadius;
        this.setPaddingMode(1);
    }

    public /* synthetic */ CompositeBackgroundDrawable(Context context, Drawable drawable2, List list, CSSBackgroundDrawable cSSBackgroundDrawable, BackgroundDrawable backgroundDrawable, BorderDrawable borderDrawable, Drawable drawable3, List list2, OutlineDrawable outlineDrawable, BorderInsets borderInsets, BorderRadiusStyle borderRadiusStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            drawable2 = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            cSSBackgroundDrawable = null;
        }
        if ((n & 0x10) != 0) {
            backgroundDrawable = null;
        }
        if ((n & 0x20) != 0) {
            borderDrawable = null;
        }
        if ((n & 0x40) != 0) {
            drawable3 = null;
        }
        if ((n & 0x80) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            outlineDrawable = null;
        }
        if ((n & 0x200) != 0) {
            borderInsets = null;
        }
        if ((n & 0x400) != 0) {
            borderRadiusStyle = null;
        }
        this(context, drawable2, list, cSSBackgroundDrawable, backgroundDrawable, borderDrawable, drawable3, list2, outlineDrawable, borderInsets, borderRadiusStyle);
    }

    @Nullable
    public final Drawable getOriginalBackground() {
        return this.originalBackground;
    }

    @NotNull
    public final List<Drawable> getOuterShadows() {
        return this.outerShadows;
    }

    @Nullable
    public final CSSBackgroundDrawable getCssBackground() {
        return this.cssBackground;
    }

    @Nullable
    public final BackgroundDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public final BorderDrawable getBorder() {
        return this.border;
    }

    @Nullable
    public final Drawable getFeedbackUnderlay() {
        return this.feedbackUnderlay;
    }

    @NotNull
    public final List<Drawable> getInnerShadows() {
        return this.innerShadows;
    }

    @Nullable
    public final OutlineDrawable getOutline() {
        return this.outline;
    }

    @Nullable
    public final BorderInsets getBorderInsets() {
        return this.borderInsets;
    }

    public final void setBorderInsets(@Nullable BorderInsets borderInsets) {
        this.borderInsets = borderInsets;
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewCssBackground(@Nullable CSSBackgroundDrawable cssBackground) {
        return new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, cssBackground, this.background, this.border, this.feedbackUnderlay, this.innerShadows, this.outline, this.borderInsets, this.borderRadius);
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewBackground(@Nullable BackgroundDrawable background) {
        return new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, this.cssBackground, background, this.border, this.feedbackUnderlay, this.innerShadows, this.outline, this.borderInsets, this.borderRadius);
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewShadows(@NotNull List<? extends Drawable> outerShadows, @NotNull List<? extends Drawable> innerShadows) {
        Intrinsics.checkNotNullParameter(outerShadows, (String)"outerShadows");
        Intrinsics.checkNotNullParameter(innerShadows, (String)"innerShadows");
        return new CompositeBackgroundDrawable(this.context, this.originalBackground, outerShadows, this.cssBackground, this.background, this.border, this.feedbackUnderlay, innerShadows, this.outline, this.borderInsets, this.borderRadius);
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewBorder(@NotNull BorderDrawable border) {
        Intrinsics.checkNotNullParameter((Object)((Object)border), (String)"border");
        return new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, this.cssBackground, this.background, border, this.feedbackUnderlay, this.innerShadows, this.outline, this.borderInsets, this.borderRadius);
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewOutline(@NotNull OutlineDrawable outline) {
        Intrinsics.checkNotNullParameter((Object)((Object)outline), (String)"outline");
        return new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, this.cssBackground, this.background, this.border, this.feedbackUnderlay, this.innerShadows, outline, this.borderInsets, this.borderRadius);
    }

    @NotNull
    public final CompositeBackgroundDrawable withNewFeedbackUnderlay(@Nullable Drawable newUnderlay) {
        return new CompositeBackgroundDrawable(this.context, this.originalBackground, this.outerShadows, this.cssBackground, this.background, this.border, newUnderlay, this.innerShadows, this.outline, this.borderInsets, this.borderRadius);
    }

    public void getOutline(@NotNull Outline outline) {
        Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
        BorderRadiusStyle borderRadiusStyle = this.borderRadius;
        boolean bl = borderRadiusStyle != null ? borderRadiusStyle.hasRoundedBorders() : false;
        if (bl) {
            Path pathForOutline = new Path();
            BorderRadiusStyle borderRadiusStyle2 = this.borderRadius;
            ComputedBorderRadius computedBorderRadius = borderRadiusStyle2 != null ? borderRadiusStyle2.resolve(this.getLayoutDirection(), this.context, this.getBounds().width(), this.getBounds().height()) : null;
            BorderInsets borderInsets = this.borderInsets;
            RectF computedBorderInsets = borderInsets != null ? borderInsets.resolve(this.getLayoutDirection(), this.context) : null;
            ComputedBorderRadius computedBorderRadius2 = computedBorderRadius;
            if (computedBorderRadius2 != null) {
                ComputedBorderRadius it = computedBorderRadius2;
                boolean bl2 = false;
                float[] fArray = new float[8];
                RectF rectF = computedBorderInsets;
                fArray[0] = PixelUtil.INSTANCE.dpToPx(it.getTopLeft().getHorizontal() + (rectF != null ? rectF.left : 0.0f));
                RectF rectF2 = computedBorderInsets;
                fArray[1] = PixelUtil.INSTANCE.dpToPx(it.getTopLeft().getVertical() + (rectF2 != null ? rectF2.top : 0.0f));
                RectF rectF3 = computedBorderInsets;
                fArray[2] = PixelUtil.INSTANCE.dpToPx(it.getTopRight().getHorizontal() + (rectF3 != null ? rectF3.right : 0.0f));
                RectF rectF4 = computedBorderInsets;
                fArray[3] = PixelUtil.INSTANCE.dpToPx(it.getTopRight().getVertical() + (rectF4 != null ? rectF4.top : 0.0f));
                RectF rectF5 = computedBorderInsets;
                fArray[4] = PixelUtil.INSTANCE.dpToPx(it.getBottomRight().getHorizontal() + (rectF5 != null ? rectF5.right : 0.0f));
                RectF rectF6 = computedBorderInsets;
                fArray[5] = PixelUtil.INSTANCE.dpToPx(it.getBottomRight().getVertical() + (rectF6 != null ? rectF6.bottom : 0.0f));
                RectF rectF7 = computedBorderInsets;
                fArray[6] = PixelUtil.INSTANCE.dpToPx(it.getBottomLeft().getHorizontal() + (rectF7 != null ? rectF7.left : 0.0f));
                RectF rectF8 = computedBorderInsets;
                fArray[7] = PixelUtil.INSTANCE.dpToPx(it.getBottomLeft().getVertical() + (rectF8 != null ? rectF8.bottom : 0.0f));
                pathForOutline.addRoundRect(new RectF(this.getBounds()), fArray, Path.Direction.CW);
            }
            if (Build.VERSION.SDK_INT >= 30) {
                outline.setPath(pathForOutline);
            } else {
                outline.setConvexPath(pathForOutline);
            }
        } else {
            outline.setRect(this.getBounds());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jm\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable$Companion;", "", "<init>", "()V", "createLayersArray", "", "Landroid/graphics/drawable/Drawable;", "originalBackground", "outerShadows", "", "cssBackground", "Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "background", "Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "border", "Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "feedbackUnderlay", "innerShadows", "outline", "Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "(Landroid/graphics/drawable/Drawable;Ljava/util/List;Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;Lcom/facebook/react/uimanager/drawable/BorderDrawable;Landroid/graphics/drawable/Drawable;Ljava/util/List;Lcom/facebook/react/uimanager/drawable/OutlineDrawable;)[Landroid/graphics/drawable/Drawable;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nCompositeBackgroundDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeBackgroundDrawable.kt\ncom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,245:1\n1#2:246\n37#3:247\n36#3,3:248\n*S KotlinDebug\n*F\n+ 1 CompositeBackgroundDrawable.kt\ncom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable$Companion\n*L\n241#1:247\n241#1:248,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Drawable[] createLayersArray(Drawable originalBackground, List<? extends Drawable> outerShadows, CSSBackgroundDrawable cssBackground, BackgroundDrawable background, BorderDrawable border, Drawable feedbackUnderlay, List<? extends Drawable> innerShadows, OutlineDrawable outline) {
            Drawable it;
            List layers = new ArrayList();
            Drawable drawable2 = originalBackground;
            if (drawable2 != null) {
                it = drawable2;
                boolean bl = false;
                layers.add(it);
            }
            layers.addAll(CollectionsKt.asReversed(outerShadows));
            CSSBackgroundDrawable cSSBackgroundDrawable = cssBackground;
            if (cSSBackgroundDrawable != null) {
                it = cSSBackgroundDrawable;
                boolean bl = false;
                layers.add(it);
            }
            BackgroundDrawable backgroundDrawable = background;
            if (backgroundDrawable != null) {
                it = backgroundDrawable;
                boolean bl = false;
                layers.add(it);
            }
            BorderDrawable borderDrawable = border;
            if (borderDrawable != null) {
                it = borderDrawable;
                boolean bl = false;
                layers.add(it);
            }
            Drawable drawable3 = feedbackUnderlay;
            if (drawable3 != null) {
                it = drawable3;
                boolean bl = false;
                layers.add(it);
            }
            layers.addAll(CollectionsKt.asReversed(innerShadows));
            OutlineDrawable outlineDrawable = outline;
            if (outlineDrawable != null) {
                it = outlineDrawable;
                boolean bl = false;
                layers.add(it);
            }
            Collection $this$toTypedArray$iv = layers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Drawable[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

