/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B'\b\u0016\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0000\u0012\u00020\t\u0012\u0006\b\u0000\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0004\b\u0004\u0010\nB'\b\u0016\u0012\u001c\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0018\u00010\f\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u0016\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\rJ\u001a\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u001a\u0010\u0014\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\rH\u0001J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0017R\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/facebook/react/uimanager/ViewManagerRegistry;", "Landroid/content/ComponentCallbacks2;", "viewManagerResolver", "Lcom/facebook/react/uimanager/ViewManagerResolver;", "<init>", "(Lcom/facebook/react/uimanager/ViewManagerResolver;)V", "viewManagerList", "", "Lcom/facebook/react/uimanager/ViewManager;", "", "(Ljava/util/List;)V", "viewManagerMap", "", "", "(Ljava/util/Map;)V", "viewManagersMap", "", "get", "className", "getViewManagerFromResolver", "getViewManagerIfExists", "onSurfaceStopped", "", "surfaceId", "", "invalidate", "onTrimMemory", "level", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nViewManagerRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewManagerRegistry.kt\ncom/facebook/react/uimanager/ViewManagerRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1208#2,2:163\n1236#2,4:165\n1#3:169\n*S KotlinDebug\n*F\n+ 1 ViewManagerRegistry.kt\ncom/facebook/react/uimanager/ViewManagerRegistry\n*L\n29#1:163,2\n29#1:165,4\n*E\n"})
public final class ViewManagerRegistry
implements ComponentCallbacks2 {
    @NotNull
    private final Map<String, ViewManager<?, ?>> viewManagersMap;
    @Nullable
    private final ViewManagerResolver viewManagerResolver;

    public ViewManagerRegistry(@NotNull ViewManagerResolver viewManagerResolver) {
        Intrinsics.checkNotNullParameter((Object)viewManagerResolver, (String)"viewManagerResolver");
        this.viewManagersMap = new LinkedHashMap();
        this.viewManagerResolver = viewManagerResolver;
    }

    /*
     * WARNING - void declaration
     */
    public ViewManagerRegistry(@NotNull List<? extends ViewManager> viewManagerList) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(viewManagerList, (String)"viewManagerList");
        Iterable iterable = viewManagerList;
        ViewManagerRegistry viewManagerRegistry2 = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ViewManager viewManager = (ViewManager)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        viewManagerRegistry2.viewManagersMap = MapsKt.toMutableMap((Map)destination$iv$iv);
        this.viewManagerResolver = null;
    }

    public ViewManagerRegistry(@Nullable Map<String, ? extends ViewManager<?, ?>> viewManagerMap) {
        Map map = viewManagerMap;
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        this.viewManagersMap = map;
        this.viewManagerResolver = null;
    }

    @NotNull
    public final synchronized ViewManager<?, ?> get(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ViewManager<?, ?> viewManager = this.viewManagersMap.get(className);
        if (viewManager != null) {
            ViewManager<?, ?> it = viewManager;
            boolean bl = false;
            return it;
        }
        String rctViewManagerName = "RCT" + className;
        ViewManager<?, ?> viewManager2 = this.viewManagersMap.get(rctViewManagerName);
        if (viewManager2 != null) {
            ViewManager<?, ?> it = viewManager2;
            boolean bl = false;
            return it;
        }
        if (this.viewManagerResolver != null) {
            ViewManager<?, ?> resolvedManager = this.getViewManagerFromResolver(className);
            if (resolvedManager != null) {
                return resolvedManager;
            }
            ViewManager<?, ?> rctResolvedManager = this.getViewManagerFromResolver(rctViewManagerName);
            if (rctResolvedManager != null) {
                return rctResolvedManager;
            }
            throw new IllegalViewOperationException("Can't find ViewManager '" + className + "' nor '" + rctViewManagerName + "' in ViewManagerRegistry, existing names are: " + this.viewManagerResolver.getViewManagerNames());
        }
        throw new IllegalViewOperationException("No ViewManager found for class " + className);
    }

    private final ViewManager<?, ?> getViewManagerFromResolver(String className) {
        ViewManager<?, ?> viewManager;
        ViewManagerResolver viewManagerResolver = this.viewManagerResolver;
        ViewManager<Object, Object> viewManager2 = viewManager = viewManagerResolver != null ? viewManagerResolver.getViewManager(className) : null;
        if (viewManager != null) {
            this.viewManagersMap.put(className, viewManager);
        }
        return viewManager;
    }

    @JvmName(name="getViewManagerIfExists")
    @Nullable
    public final synchronized ViewManager<?, ?> getViewManagerIfExists(@NotNull String className) {
        ViewManager<?, ?> viewManager;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ViewManager<?, ?> viewManager2 = this.viewManagersMap.get(className);
        if (viewManager2 != null) {
            ViewManager<?, ?> it = viewManager2;
            boolean bl = false;
            return it;
        }
        ViewManagerResolver viewManagerResolver = this.viewManagerResolver;
        if (viewManagerResolver != null) {
            ViewManagerResolver it = viewManagerResolver;
            boolean bl = false;
            viewManager = this.getViewManagerFromResolver(className);
        } else {
            viewManager = null;
        }
        return viewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSurfaceStopped(int surfaceId) {
        ArrayList arrayList;
        ViewManagerRegistry viewManagerRegistry2 = this;
        synchronized (viewManagerRegistry2) {
            boolean bl = false;
            arrayList = new ArrayList(this.viewManagersMap.values());
        }
        List viewManagers = arrayList;
        Function0 runnable = () -> ViewManagerRegistry.onSurfaceStopped$lambda$6(viewManagers, surfaceId);
        if (UiThreadUtil.isOnUiThread()) {
            runnable.invoke();
        } else {
            UiThreadUtil.runOnUiThread(() -> ViewManagerRegistry.onSurfaceStopped$lambda$7(runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate() {
        ArrayList arrayList;
        ViewManagerRegistry viewManagerRegistry2 = this;
        synchronized (viewManagerRegistry2) {
            boolean bl = false;
            arrayList = new ArrayList(this.viewManagersMap.values());
        }
        List viewManagers = arrayList;
        Function0 runnable = () -> ViewManagerRegistry.invalidate$lambda$9(viewManagers);
        if (UiThreadUtil.isOnUiThread()) {
            runnable.invoke();
        } else {
            UiThreadUtil.runOnUiThread(() -> ViewManagerRegistry.invalidate$lambda$10(runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrimMemory(int level) {
        ArrayList arrayList;
        ViewManagerRegistry viewManagerRegistry2 = this;
        synchronized (viewManagerRegistry2) {
            boolean bl = false;
            arrayList = new ArrayList(this.viewManagersMap.values());
        }
        List viewManagers = arrayList;
        Function0 runnable = () -> ViewManagerRegistry.onTrimMemory$lambda$12(viewManagers);
        if (UiThreadUtil.isOnUiThread()) {
            runnable.invoke();
        } else {
            UiThreadUtil.runOnUiThread(() -> ViewManagerRegistry.onTrimMemory$lambda$13(runnable));
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
    }

    @Deprecated(message="Overrides deprecated ComponentCallbacks2.onLowMemory()")
    public void onLowMemory() {
        this.onTrimMemory(40);
    }

    private static final Unit onSurfaceStopped$lambda$6(List $viewManagers, int $surfaceId) {
        for (ViewManager viewManager : $viewManagers) {
            viewManager.onSurfaceStopped($surfaceId);
        }
        return Unit.INSTANCE;
    }

    private static final void onSurfaceStopped$lambda$7(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit invalidate$lambda$9(List $viewManagers) {
        for (ViewManager viewManager : $viewManagers) {
            viewManager.invalidate();
        }
        return Unit.INSTANCE;
    }

    private static final void invalidate$lambda$10(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit onTrimMemory$lambda$12(List $viewManagers) {
        for (ViewManager viewManager : $viewManagers) {
            viewManager.trimMemory();
        }
        return Unit.INSTANCE;
    }

    private static final void onTrimMemory$lambda$13(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

