/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.widget.EditText;
import androidx.core.view.ViewCompat;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherProvider;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J\"\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0007J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0012\u0010\u001a\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u001bH\u0007J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u001bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/uimanager/UIManagerHelper;", "", "<init>", "()V", "TAG", "", "PADDING_START_INDEX", "", "PADDING_END_INDEX", "PADDING_TOP_INDEX", "PADDING_BOTTOM_INDEX", "getUIManagerForReactTag", "Lcom/facebook/react/bridge/UIManager;", "context", "Lcom/facebook/react/bridge/ReactContext;", "reactTag", "getUIManager", "uiManagerType", "returnNullIfCatalystIsInactive", "", "getEventDispatcherForReactTag", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher", "getReactContext", "view", "Landroid/view/View;", "getSurfaceId", "Landroid/content/Context;", "getDefaultTextInputPadding", "", "ReactAndroid_release"})
public final class UIManagerHelper {
    @NotNull
    public static final UIManagerHelper INSTANCE = new UIManagerHelper();
    @NotNull
    private static final String TAG = "UIManagerHelper";
    public static final int PADDING_START_INDEX = 0;
    public static final int PADDING_END_INDEX = 1;
    public static final int PADDING_TOP_INDEX = 2;
    public static final int PADDING_BOTTOM_INDEX = 3;

    private UIManagerHelper() {
    }

    @JvmStatic
    @Nullable
    public static final UIManager getUIManagerForReactTag(@NotNull ReactContext context, int reactTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return UIManagerHelper.getUIManager(context, ViewUtil.getUIManagerType(reactTag));
    }

    @JvmStatic
    @Nullable
    public static final UIManager getUIManager(@NotNull ReactContext context, int uiManagerType) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return UIManagerHelper.getUIManager(context, uiManagerType, true);
    }

    @JvmStatic
    private static final UIManager getUIManager(ReactContext context, int uiManagerType, boolean returnNullIfCatalystIsInactive) {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE || context.isBridgeless()) {
            UIManager uiManager = context.getFabricUIManager();
            if (uiManager == null) {
                ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager because the instance hasn't been initialized yet."));
                return null;
            }
            return uiManager;
        }
        LegacyArchitectureLogger.assertLegacyArchitecture("UIManagerHelper.getUIManager(context, uiManagerType)", LegacyArchitectureLogLevel.ERROR);
        if (!context.hasCatalystInstance()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager because the context doesn't contain a CatalystInstance."));
            return null;
        }
        if (!context.hasActiveReactInstance()) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager because the context doesn't contain an active CatalystInstance."));
            if (returnNullIfCatalystIsInactive) {
                return null;
            }
        }
        CatalystInstance catalystInstance = context.getCatalystInstance();
        Intrinsics.checkNotNullExpressionValue((Object)catalystInstance, (String)"getCatalystInstance(...)");
        CatalystInstance catalystInstance2 = catalystInstance;
        try {
            return uiManagerType == 2 ? context.getFabricUIManager() : (UIManager)catalystInstance2.getNativeModule(UIManagerModule.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot get UIManager for UIManagerType: " + uiManagerType));
            return catalystInstance2.getNativeModule(UIManagerModule.class);
        }
    }

    @JvmStatic
    @Nullable
    public static final EventDispatcher getEventDispatcherForReactTag(@NotNull ReactContext context, int reactTag) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcher(context, ViewUtil.getUIManagerType(reactTag));
        if (eventDispatcher == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot get EventDispatcher for reactTag " + reactTag));
        }
        return eventDispatcher;
    }

    @JvmStatic
    @Nullable
    public static final EventDispatcher getEventDispatcher(@NotNull ReactContext context, int uiManagerType) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        ReactContext localContext = context;
        if (localContext.isBridgeless()) {
            if (localContext instanceof ThemedReactContext) {
                localContext = ((ThemedReactContext)localContext).getReactApplicationContext();
            }
            ReactContext reactContext = localContext;
            Intrinsics.checkNotNull((Object)((Object)reactContext), (String)"null cannot be cast to non-null type com.facebook.react.uimanager.events.EventDispatcherProvider");
            return ((EventDispatcherProvider)((Object)reactContext)).getEventDispatcher();
        }
        UIManager uiManager = UIManagerHelper.getUIManager(localContext, uiManagerType, false);
        if (uiManager == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Unable to find UIManager for UIManagerType " + uiManagerType));
            return null;
        }
        EventDispatcher eventDispatcher = uiManager.getEventDispatcher();
        if (eventDispatcher == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot get EventDispatcher for UIManagerType " + uiManagerType));
        }
        return eventDispatcher;
    }

    @JvmStatic
    @NotNull
    public static final ReactContext getReactContext(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        if (!(context instanceof ReactContext) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
        return (ReactContext)context2;
    }

    @JvmStatic
    public static final int getSurfaceId(@NotNull View view) {
        int surfaceId;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view instanceof ReactRoot) {
            ReactRoot rootView = (ReactRoot)view;
            return rootView.getUIManagerType() == 2 ? rootView.getRootViewTag() : -1;
        }
        int reactTag = view.getId();
        if (ViewUtil.getUIManagerType(reactTag) == 1) {
            return -1;
        }
        Context context = view.getContext();
        if (!(context instanceof ThemedReactContext) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if ((surfaceId = UIManagerHelper.getSurfaceId(context)) == -1) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Fabric View [" + reactTag + "] does not have SurfaceId associated with it"));
        }
        return surfaceId;
    }

    @JvmStatic
    public static final int getSurfaceId(@Nullable Context context) {
        return context instanceof ThemedReactContext ? ((ThemedReactContext)context).getSurfaceId() : -1;
    }

    @JvmStatic
    @NotNull
    public static final float[] getDefaultTextInputPadding(@Nullable Context context) {
        EditText editText = new EditText(context);
        float[] padding = new float[]{PixelUtil.toDIPFromPixel(ViewCompat.getPaddingStart((View)((View)editText))), PixelUtil.toDIPFromPixel(ViewCompat.getPaddingEnd((View)((View)editText))), PixelUtil.toDIPFromPixel(editText.getPaddingTop()), PixelUtil.toDIPFromPixel(editText.getPaddingBottom())};
        return padding;
    }
}

