/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.ReactCompoundViewGroup;
import com.facebook.react.uimanager.ReactOverflowView;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.common.ViewUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000223B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J2\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0007J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0003J8\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\"H\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J \u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J0\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0007H\u0002J,\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001b2\u0010\b\u0002\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\"H\u0002J \u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/facebook/react/uimanager/TouchTargetHelper;", "", "<init>", "()V", "eventCoords", "", "tempPoint", "Landroid/graphics/PointF;", "matrixTransformCoords", "inverseMatrix", "Landroid/graphics/Matrix;", "findTargetTagForTouch", "", "eventX", "", "eventY", "viewGroup", "Landroid/view/ViewGroup;", "nativeViewId", "", "findTargetTagAndCoordinatesForTouch", "viewCoords", "nativeViewTag", "findTargetPathAndCoordinatesForTouch", "", "Lcom/facebook/react/uimanager/TouchTargetHelper$ViewTarget;", "findClosestReactAncestor", "Landroid/view/View;", "view", "findTouchTargetView", "allowReturnTouchTargetTypes", "Ljava/util/EnumSet;", "Lcom/facebook/react/uimanager/TouchTargetHelper$TouchTargetReturnType;", "pathAccumulator", "", "isTouchPointInView", "", "x", "y", "isTouchPointInViewWithOverflowInset", "getChildPoint", "", "parent", "child", "outLocalPoint", "findTouchTargetViewWithPointerEvents", "getTouchTargetForView", "targetView", "viewX", "viewY", "TouchTargetReturnType", "ViewTarget", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nTouchTargetHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TouchTargetHelper.kt\ncom/facebook/react/uimanager/TouchTargetHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
public final class TouchTargetHelper {
    @NotNull
    public static final TouchTargetHelper INSTANCE = new TouchTargetHelper();
    @NotNull
    private static final float[] eventCoords = new float[2];
    @NotNull
    private static final PointF tempPoint = new PointF();
    @NotNull
    private static final float[] matrixTransformCoords = new float[2];
    @NotNull
    private static final Matrix inverseMatrix = new Matrix();

    private TouchTargetHelper() {
    }

    @JvmStatic
    public static final int findTargetTagForTouch(float eventX, float eventY, @NotNull ViewGroup viewGroup) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(eventX, eventY, viewGroup, eventCoords, null);
    }

    @JvmStatic
    public static final int findTargetTagForTouch(float eventX, float eventY, @NotNull ViewGroup viewGroup, @Nullable int[] nativeViewId) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        return TouchTargetHelper.findTargetTagAndCoordinatesForTouch(eventX, eventY, viewGroup, eventCoords, nativeViewId);
    }

    @JvmStatic
    public static final int findTargetTagAndCoordinatesForTouch(float eventX, float eventY, @NotNull ViewGroup viewGroup, @NotNull float[] viewCoords, @Nullable int[] nativeViewTag) {
        View reactTargetView;
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)viewCoords, (String)"viewCoords");
        UiThreadUtil.assertOnUiThread();
        int targetTag = viewGroup.getId();
        viewCoords[0] = eventX;
        viewCoords[1] = eventY;
        View nativeTargetView = INSTANCE.findTouchTargetViewWithPointerEvents(viewCoords, (View)viewGroup, null);
        if (nativeTargetView != null && (reactTargetView = INSTANCE.findClosestReactAncestor(nativeTargetView)) != null) {
            if (nativeViewTag != null) {
                int[] it = nativeViewTag;
                boolean bl = false;
                nativeViewTag[0] = reactTargetView.getId();
            }
            targetTag = INSTANCE.getTouchTargetForView(reactTargetView, viewCoords[0], viewCoords[1]);
        }
        return targetTag;
    }

    @JvmStatic
    @SuppressLint(value={"ResourceType"})
    @NotNull
    public static final List<ViewTarget> findTargetPathAndCoordinatesForTouch(float eventX, float eventY, @NotNull ViewGroup viewGroup, @NotNull float[] viewCoords) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        Intrinsics.checkNotNullParameter((Object)viewCoords, (String)"viewCoords");
        UiThreadUtil.assertOnUiThread();
        viewCoords[0] = eventX;
        viewCoords[1] = eventY;
        List pathAccumulator = new ArrayList();
        View targetView = INSTANCE.findTouchTargetViewWithPointerEvents(viewCoords, (View)viewGroup, pathAccumulator);
        if (targetView != null) {
            int targetTag;
            View reactTargetView = targetView;
            int firstReactAncestor = 0;
            while (reactTargetView != null && reactTargetView.getId() <= 0) {
                ViewParent viewParent = reactTargetView.getParent();
                reactTargetView = viewParent instanceof View ? (View)viewParent : null;
                ++firstReactAncestor;
            }
            if (firstReactAncestor > 0 && firstReactAncestor <= pathAccumulator.size()) {
                pathAccumulator.subList(firstReactAncestor, pathAccumulator.size());
            }
            if (reactTargetView != null && (targetTag = INSTANCE.getTouchTargetForView(reactTargetView, viewCoords[0], viewCoords[1])) != reactTargetView.getId()) {
                pathAccumulator.add(0, new ViewTarget(targetTag, null));
            }
        }
        return pathAccumulator;
    }

    @SuppressLint(value={"ResourceType"})
    private final View findClosestReactAncestor(View view) {
        View currentView = view;
        while (currentView != null && currentView.getId() <= 0) {
            ViewParent viewParent = currentView.getParent();
            currentView = viewParent instanceof View ? (View)viewParent : null;
        }
        return currentView;
    }

    private final View findTouchTargetView(float[] eventCoords, View view, EnumSet<TouchTargetReturnType> allowReturnTouchTargetTypes, List<ViewTarget> pathAccumulator) {
        if (allowReturnTouchTargetTypes.contains((Object)TouchTargetReturnType.CHILD) && view instanceof ViewGroup) {
            View viewGroup = view;
            if (!this.isTouchPointInView(eventCoords[0], eventCoords[1], view)) {
                if (view instanceof ReactOverflowViewWithInset) {
                    if (ViewUtil.getUIManagerType(view.getId()) == 2 && !this.isTouchPointInViewWithOverflowInset(eventCoords[0], eventCoords[1], view)) {
                        return null;
                    }
                    String overflow = ((ReactOverflowView)view).getOverflow();
                    if (Intrinsics.areEqual((Object)"hidden", (Object)overflow) || Intrinsics.areEqual((Object)"scroll", (Object)overflow)) {
                        return null;
                    }
                }
                if (((ViewGroup)viewGroup).getClipChildren()) {
                    return null;
                }
            }
            int childrenCount = ((ViewGroup)viewGroup).getChildCount();
            View view2 = viewGroup;
            ReactZIndexedViewGroup zIndexedViewGroup = view2 instanceof ReactZIndexedViewGroup ? (ReactZIndexedViewGroup)view2 : null;
            for (int i = childrenCount - 1; -1 < i; --i) {
                ReactZIndexedViewGroup reactZIndexedViewGroup = zIndexedViewGroup;
                int childIndex = reactZIndexedViewGroup != null ? reactZIndexedViewGroup.getZIndexMappedChildIndex(i) : i;
                View child = ((ViewGroup)viewGroup).getChildAt(childIndex);
                PointF childPoint = tempPoint;
                float f = eventCoords[0];
                float f2 = eventCoords[1];
                ViewGroup viewGroup2 = (ViewGroup)viewGroup;
                Intrinsics.checkNotNull((Object)child);
                this.getChildPoint(f, f2, viewGroup2, child, childPoint);
                float restoreX = eventCoords[0];
                float restoreY = eventCoords[1];
                eventCoords[0] = childPoint.x;
                eventCoords[1] = childPoint.y;
                View target = this.findTouchTargetViewWithPointerEvents(eventCoords, child, pathAccumulator);
                if (target != null) {
                    return target;
                }
                eventCoords[0] = restoreX;
                eventCoords[1] = restoreY;
            }
        }
        if (allowReturnTouchTargetTypes.contains((Object)TouchTargetReturnType.SELF) && this.isTouchPointInView(eventCoords[0], eventCoords[1], view)) {
            return view;
        }
        return null;
    }

    private final boolean isTouchPointInView(float x, float y, View view) {
        Rect hitSlopRect;
        ReactHitSlopView reactHitSlopView = view instanceof ReactHitSlopView ? (ReactHitSlopView)view : null;
        Object object = hitSlopRect = reactHitSlopView != null ? reactHitSlopView.getHitSlopRect() : null;
        if (hitSlopRect != null) {
            return x >= (float)(-hitSlopRect.left) && x < (float)(view.getWidth() + hitSlopRect.right) && y >= (float)(-hitSlopRect.top) && y < (float)(view.getHeight() + hitSlopRect.bottom);
        }
        return x >= 0.0f && x < (float)view.getWidth() && y >= 0.0f && y < (float)view.getHeight();
    }

    private final boolean isTouchPointInViewWithOverflowInset(float x, float y, View view) {
        if (!(view instanceof ReactOverflowViewWithInset)) {
            return false;
        }
        Rect overflowInset = ((ReactOverflowViewWithInset)view).getOverflowInset();
        return x >= (float)overflowInset.left && x < (float)(view.getWidth() - overflowInset.right) && y >= (float)overflowInset.top && y < (float)(view.getHeight() - overflowInset.bottom);
    }

    private final void getChildPoint(float x, float y, ViewGroup parent, View child, PointF outLocalPoint) {
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        Matrix matrix = child.getMatrix();
        if (!matrix.isIdentity()) {
            float[] localXY = matrixTransformCoords;
            localXY[0] = localX;
            localXY[1] = localY;
            Matrix inverseMatrix = TouchTargetHelper.inverseMatrix;
            matrix.invert(inverseMatrix);
            inverseMatrix.mapPoints(localXY);
            localX = localXY[0];
            localY = localXY[1];
        }
        outLocalPoint.set(localX, localY);
    }

    private final View findTouchTargetViewWithPointerEvents(float[] eventCoords, View view, List<ViewTarget> pathAccumulator) {
        View view2;
        PointerEvents pointerEvents;
        PointerEvents pointerEvents2 = pointerEvents = view instanceof ReactPointerEventsView ? ((ReactPointerEventsView)view).getPointerEvents() : PointerEvents.AUTO;
        if (!view.isEnabled()) {
            pointerEvents = switch (WhenMappings.$EnumSwitchMapping$0[pointerEvents.ordinal()]) {
                case 1 -> PointerEvents.BOX_NONE;
                case 2 -> PointerEvents.NONE;
                default -> pointerEvents;
            };
        }
        switch (WhenMappings.$EnumSwitchMapping$0[pointerEvents.ordinal()]) {
            case 3: {
                view2 = null;
                break;
            }
            case 2: {
                View targetView;
                EnumSet<Enum> enumSet = EnumSet.of((Enum)TouchTargetReturnType.SELF);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
                View view3 = targetView = this.findTouchTargetView(eventCoords, view, enumSet, pathAccumulator);
                if (view3 != null) {
                    View it = view3;
                    boolean bl = false;
                    List<ViewTarget> list = pathAccumulator;
                    if (list != null) {
                        list.add(new ViewTarget(view.getId(), view));
                    }
                }
                view2 = targetView;
                break;
            }
            case 4: {
                int reactTag;
                EnumSet<Enum> enumSet = EnumSet.of((Enum)TouchTargetReturnType.CHILD);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
                View targetView = this.findTouchTargetView(eventCoords, view, enumSet, pathAccumulator);
                if (targetView != null) {
                    List<ViewTarget> list = pathAccumulator;
                    if (list != null) {
                        list.add(new ViewTarget(view.getId(), view));
                    }
                    return targetView;
                }
                if (view instanceof ReactCompoundView && this.isTouchPointInView(eventCoords[0], eventCoords[1], view) && (reactTag = ((ReactCompoundView)view).reactTagForTouch(eventCoords[0], eventCoords[1])) != view.getId()) {
                    List<ViewTarget> list = pathAccumulator;
                    if (list != null) {
                        list.add(new ViewTarget(view.getId(), view));
                    }
                    return view;
                }
                view2 = null;
                break;
            }
            default: {
                View result;
                if (pointerEvents != PointerEvents.AUTO) {
                    FLog.w((String)"ReactNative", (String)("Unknown pointer event type: " + pointerEvents));
                }
                if (view instanceof ReactCompoundViewGroup && this.isTouchPointInView(eventCoords[0], eventCoords[1], view) && ((ReactCompoundViewGroup)view).interceptsTouchEvent(eventCoords[0], eventCoords[1])) {
                    List<ViewTarget> list = pathAccumulator;
                    if (list != null) {
                        list.add(new ViewTarget(view.getId(), view));
                    }
                    return view;
                }
                EnumSet<Enum> enumSet = EnumSet.of((Enum)TouchTargetReturnType.SELF, (Enum)TouchTargetReturnType.CHILD);
                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
                View view4 = result = this.findTouchTargetView(eventCoords, view, enumSet, pathAccumulator);
                if (view4 != null) {
                    View it = view4;
                    boolean bl = false;
                    List<ViewTarget> list = pathAccumulator;
                    if (list != null) {
                        list.add(new ViewTarget(view.getId(), view));
                    }
                }
                view2 = result;
            }
        }
        return view2;
    }

    static /* synthetic */ View findTouchTargetViewWithPointerEvents$default(TouchTargetHelper touchTargetHelper, float[] fArray, View view, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return touchTargetHelper.findTouchTargetViewWithPointerEvents(fArray, view, list);
    }

    private final int getTouchTargetForView(View targetView, float viewX, float viewY) {
        return targetView instanceof ReactCompoundView ? ((ReactCompoundView)targetView).reactTagForTouch(viewX, viewY) : targetView.getId();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/uimanager/TouchTargetHelper$TouchTargetReturnType;", "", "<init>", "(Ljava/lang/String;I)V", "SELF", "CHILD", "ReactAndroid_release"})
    private static final class TouchTargetReturnType
    extends Enum<TouchTargetReturnType> {
        public static final /* enum */ TouchTargetReturnType SELF = new TouchTargetReturnType();
        public static final /* enum */ TouchTargetReturnType CHILD = new TouchTargetReturnType();
        private static final /* synthetic */ TouchTargetReturnType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TouchTargetReturnType[] values() {
            return (TouchTargetReturnType[])$VALUES.clone();
        }

        public static TouchTargetReturnType valueOf(String value) {
            return Enum.valueOf(TouchTargetReturnType.class, value);
        }

        @NotNull
        public static EnumEntries<TouchTargetReturnType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = touchTargetReturnTypeArray = new TouchTargetReturnType[]{TouchTargetReturnType.SELF, TouchTargetReturnType.CHILD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0003J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/uimanager/TouchTargetHelper$ViewTarget;", "", "viewId", "", "view", "Landroid/view/View;", "<init>", "(ILandroid/view/View;)V", "getViewId", "getView", "equals", "", "other", "hashCode", "ReactAndroid_release"})
    public static final class ViewTarget {
        private final int viewId;
        @Nullable
        private final View view;

        public ViewTarget(int viewId, @Nullable View view) {
            this.viewId = viewId;
            this.view = view;
        }

        public final int getViewId() {
            return this.viewId;
        }

        @Nullable
        public final View getView() {
            return this.view;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewTarget)) {
                return false;
            }
            return ((ViewTarget)other).getViewId() == this.viewId;
        }

        public int hashCode() {
            return Integer.hashCode(this.viewId);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PointerEvents.values().length];
            try {
                nArray[PointerEvents.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PointerEvents.BOX_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PointerEvents.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PointerEvents.BOX_NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

