/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ/\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0010\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/uimanager/ReactAxOrderHelper;", "", "<init>", "()V", "cleanUpAxOrder", "", "host", "Landroid/view/ViewGroup;", "restoreFocusability", "disableFocusForSubtree", "view", "axOrderList", "", "buildAxOrderList", "Landroid/view/View;", "result", "", "(Landroid/view/View;Ljava/util/List;[Landroid/view/View;)V", "ReactAndroid_release"})
public final class ReactAxOrderHelper {
    @NotNull
    public static final ReactAxOrderHelper INSTANCE = new ReactAxOrderHelper();

    private ReactAxOrderHelper() {
    }

    @JvmStatic
    public static final void cleanUpAxOrder(@NotNull ViewGroup host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        int n = host.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = host.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getChildAt(...)");
            ReactAxOrderHelper.cleanUpAxOrder$traverse(view);
        }
    }

    @JvmStatic
    public static final void restoreFocusability(@NotNull ViewGroup host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        int n = host.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = host.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getChildAt(...)");
            ReactAxOrderHelper.restoreFocusability$traverse$0(view);
        }
    }

    public final void disableFocusForSubtree(@NotNull ViewGroup view, @NotNull List<?> axOrderList) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(axOrderList, (String)"axOrderList");
        int n = view.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view2 = view.getChildAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
            ReactAxOrderHelper.disableFocusForSubtree$traverse$1(axOrderList, view2);
        }
    }

    public final void buildAxOrderList(@NotNull View view, @NotNull List<?> axOrderList, @NotNull View[] result) {
        int idx;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(axOrderList, (String)"axOrderList");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object nativeId = view.getTag(R.id.view_tag_native_id);
        view.setTag(R.id.accessibility_order_parent, (Object)this);
        if (CollectionsKt.contains((Iterable)axOrderList, (Object)nativeId) && (idx = CollectionsKt.indexOf(axOrderList, (Object)nativeId)) != -1) {
            result[idx] = view;
        }
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                this.buildAxOrderList(view2, axOrderList, result);
            }
        }
    }

    private static final void cleanUpAxOrder$traverse(View view) {
        View axOrderParent;
        Boolean originalFocusability = (Boolean)view.getTag(R.id.original_focusability);
        if (originalFocusability != null) {
            view.setFocusable(originalFocusability.booleanValue());
        }
        if ((axOrderParent = (View)view.getTag(R.id.accessibility_order_parent)) != null) {
            view.setTag(R.id.accessibility_order_parent, null);
        }
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                ReactAxOrderHelper.cleanUpAxOrder$traverse(view2);
            }
        }
    }

    private static final void restoreFocusability$traverse$0(View view) {
        Boolean originalFocusability = (Boolean)view.getTag(R.id.original_focusability);
        if (originalFocusability != null) {
            view.setFocusable(originalFocusability.booleanValue());
        }
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                ReactAxOrderHelper.restoreFocusability$traverse$0(view2);
            }
        }
    }

    private static final void disableFocusForSubtree$traverse$1(List<?> $axOrderList, View view) {
        if (!CollectionsKt.contains((Iterable)$axOrderList, (Object)view.getTag(R.id.view_tag_native_id))) {
            if (view.getTag(R.id.original_focusability) == null) {
                view.setTag(R.id.original_focusability, (Object)view.isFocusable());
            }
            view.setFocusable(false);
        }
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = ((ViewGroup)view).getChildAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                ReactAxOrderHelper.disableFocusForSubtree$traverse$1($axOrderList, view2);
            }
        }
    }
}

