/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.uimanager.NativeKind;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ShadowNodeRegistry;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewProps;

public class NativeViewHierarchyOptimizer {
    private static final String TAG = "NativeViewHierarchyOptimizer";
    private static final boolean ENABLED = true;
    private final UIViewOperationQueue mUIViewOperationQueue;
    private final ShadowNodeRegistry mShadowNodeRegistry;
    private final SparseBooleanArray mTagsWithLayoutVisited = new SparseBooleanArray();

    public static void assertNodeSupportedWithoutOptimizer(ReactShadowNode node) {
        Assertions.assertCondition((node.getNativeKind() != NativeKind.LEAF ? 1 : 0) != 0, (String)"Nodes with NativeKind.LEAF are not supported when the optimizer is disabled");
    }

    public NativeViewHierarchyOptimizer(UIViewOperationQueue uiViewOperationQueue, ShadowNodeRegistry shadowNodeRegistry) {
        this.mUIViewOperationQueue = uiViewOperationQueue;
        this.mShadowNodeRegistry = shadowNodeRegistry;
    }

    public void handleCreateView(ReactShadowNode node, ThemedReactContext themedContext, @Nullable ReactStylesDiffMap initialProps) {
        boolean isLayoutOnly = node.getViewClass().equals("RCTView") && NativeViewHierarchyOptimizer.isLayoutOnlyAndCollapsable(initialProps);
        node.setIsLayoutOnly(isLayoutOnly);
        if (node.getNativeKind() != NativeKind.NONE) {
            this.mUIViewOperationQueue.enqueueCreateView(themedContext, node.getReactTag(), node.getViewClass(), initialProps);
        }
    }

    public static void handleRemoveNode(ReactShadowNode node) {
        node.removeAllNativeChildren();
    }

    public void handleUpdateView(ReactShadowNode node, String className, ReactStylesDiffMap props) {
        boolean needsToLeaveLayoutOnly;
        boolean bl = needsToLeaveLayoutOnly = node.isLayoutOnly() && !NativeViewHierarchyOptimizer.isLayoutOnlyAndCollapsable(props);
        if (needsToLeaveLayoutOnly) {
            this.transitionLayoutOnlyViewToNativeView(node, props);
        } else if (!node.isLayoutOnly()) {
            this.mUIViewOperationQueue.enqueueUpdateProperties(node.getReactTag(), className, props);
        }
    }

    public void handleManageChildren(ReactShadowNode nodeToManage, int[] indicesToRemove, int[] tagsToRemove, ViewAtIndex[] viewsToAdd, int[] tagsToDelete) {
        int i;
        for (i = 0; i < tagsToRemove.length; ++i) {
            int tagToRemove = tagsToRemove[i];
            boolean delete = false;
            for (int j = 0; j < tagsToDelete.length; ++j) {
                if (tagsToDelete[j] != tagToRemove) continue;
                delete = true;
                break;
            }
            ReactShadowNode<?> nodeToRemove = this.mShadowNodeRegistry.getNode(tagToRemove);
            this.removeNodeFromParent(nodeToRemove, delete);
        }
        for (i = 0; i < viewsToAdd.length; ++i) {
            ViewAtIndex toAdd = viewsToAdd[i];
            ReactShadowNode<?> nodeToAdd = this.mShadowNodeRegistry.getNode(toAdd.mTag);
            this.addNodeToNode(nodeToManage, nodeToAdd, toAdd.mIndex);
        }
    }

    public void handleSetChildren(ReactShadowNode nodeToManage, ReadableArray childrenTags) {
        for (int i = 0; i < childrenTags.size(); ++i) {
            ReactShadowNode<?> nodeToAdd = this.mShadowNodeRegistry.getNode(childrenTags.getInt(i));
            this.addNodeToNode(nodeToManage, nodeToAdd, i);
        }
    }

    public void handleUpdateLayout(ReactShadowNode node) {
        this.applyLayoutBase(node);
    }

    public void handleForceViewToBeNonLayoutOnly(ReactShadowNode node) {
        if (node.isLayoutOnly()) {
            this.transitionLayoutOnlyViewToNativeView(node, null);
        }
    }

    public void onBatchComplete() {
        this.mTagsWithLayoutVisited.clear();
    }

    private NodeIndexPair walkUpUntilNativeKindIsParent(ReactShadowNode node, int indexInNativeChildren) {
        while (node.getNativeKind() != NativeKind.PARENT) {
            ReactShadowNode parent = node.getParent();
            if (parent == null) {
                return null;
            }
            indexInNativeChildren = indexInNativeChildren + (node.getNativeKind() == NativeKind.LEAF ? 1 : 0) + parent.getNativeOffsetForChild((ReactShadowNode)node);
            node = parent;
        }
        return new NodeIndexPair(node, indexInNativeChildren);
    }

    private void addNodeToNode(ReactShadowNode parent, ReactShadowNode child, int index) {
        int indexInNativeChildren = parent.getNativeOffsetForChild(parent.getChildAt(index));
        if (parent.getNativeKind() != NativeKind.PARENT) {
            NodeIndexPair result = this.walkUpUntilNativeKindIsParent(parent, indexInNativeChildren);
            if (result == null) {
                return;
            }
            parent = result.node;
            indexInNativeChildren = result.index;
        }
        if (child.getNativeKind() != NativeKind.NONE) {
            this.addNativeChild(parent, child, indexInNativeChildren);
        } else {
            this.addNonNativeChild(parent, child, indexInNativeChildren);
        }
    }

    private void removeNodeFromParent(ReactShadowNode nodeToRemove, boolean shouldDelete) {
        ReactShadowNode nativeNodeToRemoveFrom;
        if (nodeToRemove.getNativeKind() != NativeKind.PARENT) {
            for (int i = nodeToRemove.getChildCount() - 1; i >= 0; --i) {
                this.removeNodeFromParent((ReactShadowNode)nodeToRemove.getChildAt(i), shouldDelete);
            }
        }
        if ((nativeNodeToRemoveFrom = nodeToRemove.getNativeParent()) != null) {
            int[] nArray;
            int index = nativeNodeToRemoveFrom.indexOfNativeChild((ReactShadowNode)nodeToRemove);
            nativeNodeToRemoveFrom.removeNativeChildAt(index);
            int n = nativeNodeToRemoveFrom.getReactTag();
            int[] nArray2 = new int[]{index};
            if (shouldDelete) {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = nodeToRemove.getReactTag();
            } else {
                nArray = null;
            }
            this.mUIViewOperationQueue.enqueueManageChildren(n, nArray2, null, nArray);
        }
    }

    private void addNonNativeChild(ReactShadowNode nativeParent, ReactShadowNode nonNativeChild, int index) {
        this.addGrandchildren(nativeParent, nonNativeChild, index);
    }

    private void addNativeChild(ReactShadowNode parent, ReactShadowNode child, int index) {
        parent.addNativeChildAt(child, index);
        this.mUIViewOperationQueue.enqueueManageChildren(parent.getReactTag(), null, new ViewAtIndex[]{new ViewAtIndex(child.getReactTag(), index)}, null);
        if (child.getNativeKind() != NativeKind.PARENT) {
            this.addGrandchildren(parent, child, index + 1);
        }
    }

    private void addGrandchildren(ReactShadowNode nativeParent, ReactShadowNode child, int index) {
        Assertions.assertCondition((child.getNativeKind() != NativeKind.PARENT ? 1 : 0) != 0);
        int currentIndex = index;
        for (int i = 0; i < child.getChildCount(); ++i) {
            Object grandchild = child.getChildAt(i);
            Assertions.assertCondition((grandchild.getNativeParent() == null ? 1 : 0) != 0);
            int grandchildCountBefore = nativeParent.getNativeChildCount();
            if (grandchild.getNativeKind() == NativeKind.NONE) {
                this.addNonNativeChild(nativeParent, (ReactShadowNode)grandchild, currentIndex);
            } else {
                this.addNativeChild(nativeParent, (ReactShadowNode)grandchild, currentIndex);
            }
            int grandchildCountAfter = nativeParent.getNativeChildCount();
            currentIndex += grandchildCountAfter - grandchildCountBefore;
        }
    }

    private void applyLayoutBase(ReactShadowNode node) {
        int tag = node.getReactTag();
        if (this.mTagsWithLayoutVisited.get(tag)) {
            return;
        }
        this.mTagsWithLayoutVisited.put(tag, true);
        int x = node.getScreenX();
        int y = node.getScreenY();
        for (Object parent = node.getParent(); parent != null && parent.getNativeKind() != NativeKind.PARENT; parent = parent.getParent()) {
            if (parent.isVirtual()) continue;
            x += Math.round(parent.getLayoutX());
            y += Math.round(parent.getLayoutY());
        }
        this.applyLayoutRecursive(node, x, y);
    }

    private void applyLayoutRecursive(ReactShadowNode toUpdate, int x, int y) {
        if (toUpdate.getNativeKind() != NativeKind.NONE && toUpdate.getNativeParent() != null) {
            int tag = toUpdate.getReactTag();
            this.mUIViewOperationQueue.enqueueUpdateLayout(toUpdate.getLayoutParent().getReactTag(), tag, x, y, toUpdate.getScreenWidth(), toUpdate.getScreenHeight(), toUpdate.getLayoutDirection());
            return;
        }
        for (int i = 0; i < toUpdate.getChildCount(); ++i) {
            Object child = toUpdate.getChildAt(i);
            int childTag = child.getReactTag();
            if (this.mTagsWithLayoutVisited.get(childTag)) continue;
            this.mTagsWithLayoutVisited.put(childTag, true);
            int childX = child.getScreenX();
            int childY = child.getScreenY();
            this.applyLayoutRecursive((ReactShadowNode)child, childX += x, childY += y);
        }
    }

    private void transitionLayoutOnlyViewToNativeView(ReactShadowNode node, @Nullable ReactStylesDiffMap props) {
        int i;
        ReactShadowNode parent = node.getParent();
        if (parent == null) {
            node.setIsLayoutOnly(false);
            return;
        }
        int childIndex = parent.indexOf((ReactShadowNode)node);
        parent.removeChildAt(childIndex);
        this.removeNodeFromParent(node, false);
        node.setIsLayoutOnly(false);
        this.mUIViewOperationQueue.enqueueCreateView(node.getThemedContext(), node.getReactTag(), node.getViewClass(), props);
        parent.addChildAt((ReactShadowNode)node, childIndex);
        this.addNodeToNode(parent, node, childIndex);
        for (i = 0; i < node.getChildCount(); ++i) {
            this.addNodeToNode(node, (ReactShadowNode)node.getChildAt(i), i);
        }
        FLog.i((String)TAG, (String)("Transitioning LayoutOnlyView - tag: " + node.getReactTag() + " - rootTag: " + node.getRootTag() + " - hasProps: " + (props != null) + " - tagsWithLayout.size: " + this.mTagsWithLayoutVisited.size()));
        Assertions.assertCondition((this.mTagsWithLayoutVisited.size() == 0 ? 1 : 0) != 0);
        this.applyLayoutBase(node);
        for (i = 0; i < node.getChildCount(); ++i) {
            this.applyLayoutBase((ReactShadowNode)node.getChildAt(i));
        }
        this.mTagsWithLayoutVisited.clear();
    }

    private static boolean isLayoutOnlyAndCollapsable(@Nullable ReactStylesDiffMap props) {
        if (props == null) {
            return true;
        }
        if (props.hasKey("collapsable") && !props.getBoolean("collapsable", true)) {
            return false;
        }
        ReadableMapKeySetIterator keyIterator = props.internal_backingMap().keySetIterator();
        while (keyIterator.hasNextKey()) {
            if (ViewProps.isLayoutOnly(props.internal_backingMap(), keyIterator.nextKey())) continue;
            return false;
        }
        return true;
    }

    void onViewUpdatesCompleted(ReactShadowNode cssNode) {
        this.mTagsWithLayoutVisited.clear();
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture(TAG, LegacyArchitectureLogLevel.ERROR);
    }

    private static class NodeIndexPair {
        public final ReactShadowNode node;
        public final int index;

        NodeIndexPair(ReactShadowNode node, int index) {
            this.node = node;
            this.index = index;
        }
    }
}

