/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.annotation.TargetApi;
import android.graphics.BlendMode;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.ViewGroupKt;
import com.facebook.react.R;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/facebook/react/uimanager/BlendModeHelper;", "", "<init>", "()V", "parseMixBlendMode", "Landroid/graphics/BlendMode;", "mixBlendMode", "", "needsIsolatedLayer", "", "view", "Landroid/view/ViewGroup;", "ReactAndroid_release"})
@TargetApi(value=29)
@SourceDebugExtension(value={"SMAP\nBlendModeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlendModeHelper.kt\ncom/facebook/react/uimanager/BlendModeHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,52:1\n1255#2,2:53\n*S KotlinDebug\n*F\n+ 1 BlendModeHelper.kt\ncom/facebook/react/uimanager/BlendModeHelper\n*L\n50#1:53,2\n*E\n"})
public final class BlendModeHelper {
    @NotNull
    public static final BlendModeHelper INSTANCE = new BlendModeHelper();

    private BlendModeHelper() {
    }

    @JvmStatic
    @Nullable
    public static final BlendMode parseMixBlendMode(@Nullable String mixBlendMode) {
        if (mixBlendMode == null || Build.VERSION.SDK_INT < 29) {
            return null;
        }
        return switch (mixBlendMode) {
            case "normal" -> null;
            case "multiply" -> BlendMode.MULTIPLY;
            case "screen" -> BlendMode.SCREEN;
            case "overlay" -> BlendMode.OVERLAY;
            case "darken" -> BlendMode.DARKEN;
            case "lighten" -> BlendMode.LIGHTEN;
            case "color-dodge" -> BlendMode.COLOR_DODGE;
            case "color-burn" -> BlendMode.COLOR_BURN;
            case "hard-light" -> BlendMode.HARD_LIGHT;
            case "soft-light" -> BlendMode.SOFT_LIGHT;
            case "difference" -> BlendMode.DIFFERENCE;
            case "exclusion" -> BlendMode.EXCLUSION;
            case "hue" -> BlendMode.HUE;
            case "saturation" -> BlendMode.SATURATION;
            case "color" -> BlendMode.COLOR;
            case "luminosity" -> BlendMode.LUMINOSITY;
            default -> throw new IllegalArgumentException("Invalid mix-blend-mode name: " + mixBlendMode);
        };
    }

    @JvmStatic
    public static final boolean needsIsolatedLayer(@NotNull ViewGroup view) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Sequence $this$any$iv = ViewGroupKt.getChildren((ViewGroup)view);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                View it = (View)element$iv;
                boolean bl2 = false;
                if (!(it.getTag(R.id.mix_blend_mode) != null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

