/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.Spacing;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.drawable.BackgroundDrawable;
import com.facebook.react.uimanager.drawable.BorderDrawable;
import com.facebook.react.uimanager.drawable.CSSBackgroundDrawable;
import com.facebook.react.uimanager.drawable.CompositeBackgroundDrawable;
import com.facebook.react.uimanager.drawable.InsetBoxShadowDrawable;
import com.facebook.react.uimanager.drawable.OutlineDrawable;
import com.facebook.react.uimanager.drawable.OutsetBoxShadowDrawable;
import com.facebook.react.uimanager.style.BackgroundImageLayer;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.BoxShadow;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.OutlineStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0007J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0010J'\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u001cJ\"\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0007J\u001a\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%H\u0007J\u0012\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J!\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\nJ\u0017\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0015H\u0007J\u0015\u0010,\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010/\u001a\u0004\u0018\u000100H\u0007J\u0010\u00101\u001a\u0004\u0018\u0001002\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u00102\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0015\u00103\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010-J\u001e\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\rH\u0007J\u001a\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u000107H\u0007J\u001a\u00108\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u00109\u001a\u0004\u0018\u00010:H\u0007J\u0018\u0010;\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=H\u0007J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010@2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010D\u001a\u00020E2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010C2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010E2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010J\u001a\u00020I2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010L2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J!\u0010N\u001a\u00020\u00152\b\u0010O\u001a\u0004\u0018\u00010\u00152\b\u0010P\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010QJ*\u0010R\u001a\u00020S2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010T\u001a\u00020@2\u0006\u0010U\u001a\u00020V2\b\u0010W\u001a\u0004\u0018\u00010VH\u0002\u00a8\u0006X"}, d2={"Lcom/facebook/react/uimanager/BackgroundStyleApplicator;", "", "<init>", "()V", "setBackgroundColor", "", "view", "Landroid/view/View;", "color", "", "(Landroid/view/View;Ljava/lang/Integer;)V", "setBackgroundImage", "backgroundImageLayers", "", "Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "getBackgroundColor", "(Landroid/view/View;)Ljava/lang/Integer;", "setBorderWidth", "edge", "Lcom/facebook/react/uimanager/style/LogicalEdge;", "width", "", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;Ljava/lang/Float;)V", "getBorderWidth", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;)Ljava/lang/Float;", "setBorderColor", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;Ljava/lang/Integer;)V", "getBorderColor", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;)Ljava/lang/Integer;", "setBorderRadius", "corner", "Lcom/facebook/react/uimanager/style/BorderRadiusProp;", "radius", "Lcom/facebook/react/uimanager/LengthPercentage;", "getBorderRadius", "setBorderStyle", "borderStyle", "Lcom/facebook/react/uimanager/style/BorderStyle;", "getBorderStyle", "setOutlineColor", "outlineColor", "getOutlineColor", "setOutlineOffset", "outlineOffset", "getOutlineOffset", "(Landroid/view/View;)Ljava/lang/Float;", "setOutlineStyle", "outlineStyle", "Lcom/facebook/react/uimanager/style/OutlineStyle;", "getOutlineStyle", "setOutlineWidth", "getOutlineWidth", "setBoxShadow", "shadows", "Lcom/facebook/react/uimanager/style/BoxShadow;", "Lcom/facebook/react/bridge/ReadableArray;", "setFeedbackUnderlay", "drawable", "Landroid/graphics/drawable/Drawable;", "clipToPaddingBox", "canvas", "Landroid/graphics/Canvas;", "reset", "ensureCompositeBackgroundDrawable", "Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable;", "getCompositeBackgroundDrawable", "ensureCSSBackground", "Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "ensureBackgroundDrawable", "Lcom/facebook/react/uimanager/drawable/BackgroundDrawable;", "getCSSBackground", "getBackground", "getBorder", "Lcom/facebook/react/uimanager/drawable/BorderDrawable;", "ensureBorderDrawable", "ensureOutlineDrawable", "Lcom/facebook/react/uimanager/drawable/OutlineDrawable;", "getOutlineDrawable", "getInnerBorderRadius", "computedRadius", "borderWidth", "(Ljava/lang/Float;Ljava/lang/Float;)F", "createPaddingBoxPath", "Landroid/graphics/Path;", "composite", "paddingBoxRect", "Landroid/graphics/RectF;", "computedBorderInsets", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nBackgroundStyleApplicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundStyleApplicator.kt\ncom/facebook/react/uimanager/BackgroundStyleApplicator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,585:1\n808#2,11:586\n808#2,11:597\n808#2,11:608\n*S KotlinDebug\n*F\n+ 1 BackgroundStyleApplicator.kt\ncom/facebook/react/uimanager/BackgroundStyleApplicator\n*L\n110#1:586,11\n173#1:597,11\n180#1:608,11\n*E\n"})
public final class BackgroundStyleApplicator {
    @NotNull
    public static final BackgroundStyleApplicator INSTANCE = new BackgroundStyleApplicator();

    private BackgroundStyleApplicator() {
    }

    @JvmStatic
    public static final void setBackgroundColor(@NotNull View view, @ColorInt @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!(color != null && color != 0 || view.getBackground() instanceof CompositeBackgroundDrawable)) {
            return;
        }
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            Integer n = color;
            INSTANCE.ensureBackgroundDrawable(view).setBackgroundColor(n != null ? n : 0);
        } else {
            Integer n = color;
            INSTANCE.ensureCSSBackground(view).setColor(n != null ? n : 0);
        }
    }

    @JvmStatic
    public static final void setBackgroundImage(@NotNull View view, @Nullable List<BackgroundImageLayer> backgroundImageLayers) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            INSTANCE.ensureBackgroundDrawable(view).setBackgroundImageLayers(backgroundImageLayers);
        } else {
            INSTANCE.ensureCSSBackground(view).setBackgroundImage(backgroundImageLayers);
        }
    }

    @JvmStatic
    @ColorInt
    @Nullable
    public static final Integer getBackgroundColor(@NotNull View view) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            BackgroundDrawable backgroundDrawable = INSTANCE.getBackground(view);
            n = backgroundDrawable != null ? Integer.valueOf(backgroundDrawable.getBackgroundColor()) : null;
        } else {
            CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
            n = cSSBackgroundDrawable != null ? Integer.valueOf(cSSBackgroundDrawable.getColor()) : null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void setBorderWidth(@NotNull View view, @NotNull LogicalEdge edge, @Nullable Float width) {
        BorderInsets borderInsets;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        CompositeBackgroundDrawable composite = INSTANCE.ensureCompositeBackgroundDrawable(view);
        BorderInsets borderInsets2 = composite.getBorderInsets();
        if (borderInsets2 == null) {
            borderInsets2 = new BorderInsets();
        }
        composite.setBorderInsets(borderInsets2);
        BorderInsets borderInsets3 = composite.getBorderInsets();
        if (borderInsets3 != null) {
            borderInsets3.setBorderWidth(edge, width);
        }
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            Float f = width;
            INSTANCE.ensureBorderDrawable(view).setBorderWidth(edge.toSpacingType(), f != null ? PixelUtil.INSTANCE.dpToPx(f.floatValue()) : Float.NaN);
            BackgroundDrawable backgroundDrawable = composite.getBackground();
            if (backgroundDrawable != null) {
                backgroundDrawable.setBorderInsets(composite.getBorderInsets());
            }
            BorderDrawable borderDrawable = composite.getBorder();
            if (borderDrawable != null) {
                borderDrawable.setBorderInsets(composite.getBorderInsets());
            }
            BackgroundDrawable backgroundDrawable2 = composite.getBackground();
            if (backgroundDrawable2 != null) {
                backgroundDrawable2.invalidateSelf();
            }
            BorderDrawable borderDrawable2 = composite.getBorder();
            if (borderDrawable2 != null) {
                borderDrawable2.invalidateSelf();
            }
        } else {
            Float f = width;
            INSTANCE.ensureCSSBackground(view).setBorderWidth(edge.toSpacingType(), f != null ? PixelUtil.INSTANCE.dpToPx(f.floatValue()) : Float.NaN);
        }
        if ((borderInsets = composite.getBorderInsets()) == null) {
            borderInsets = new BorderInsets();
        }
        composite.setBorderInsets(borderInsets);
        BorderInsets borderInsets4 = composite.getBorderInsets();
        if (borderInsets4 != null) {
            borderInsets4.setBorderWidth(edge, width);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = composite.getInnerShadows();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof InsetBoxShadowDrawable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (InsetBoxShadowDrawable shadow : (List)destination$iv$iv) {
                shadow.setBorderInsets(composite.getBorderInsets());
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Float getBorderWidth(@NotNull View view, @NotNull LogicalEdge edge) {
        Float f;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            Float width;
            Object object = INSTANCE.getBorder(view);
            Float f2 = object != null && (object = object.getBorderWidth()) != null ? Float.valueOf(((Spacing)object).getRaw(edge.toSpacingType())) : (width = null);
            f = width == null || Float.isNaN(width.floatValue()) ? null : Float.valueOf(PixelUtil.INSTANCE.pxToDp(width.floatValue()));
        } else {
            CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
            Float width = cSSBackgroundDrawable != null ? cSSBackgroundDrawable.getBorderWidth(edge.toSpacingType()) : null;
            f = width == null || Float.isNaN(width.floatValue()) ? null : Float.valueOf(PixelUtil.INSTANCE.pxToDp(width.floatValue()));
        }
        return f;
    }

    @JvmStatic
    public static final void setBorderColor(@NotNull View view, @NotNull LogicalEdge edge, @ColorInt @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            INSTANCE.ensureBorderDrawable(view).setBorderColor(edge, color);
        } else {
            INSTANCE.ensureCSSBackground(view).setBorderColor(edge.toSpacingType(), color);
        }
    }

    @JvmStatic
    @ColorInt
    @Nullable
    public static final Integer getBorderColor(@NotNull View view, @NotNull LogicalEdge edge) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            BorderDrawable borderDrawable = INSTANCE.getBorder(view);
            n = borderDrawable != null ? Integer.valueOf(borderDrawable.getBorderColor(edge)) : null;
        } else {
            CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
            n = cSSBackgroundDrawable != null ? Integer.valueOf(cSSBackgroundDrawable.getBorderColor(edge.toSpacingType())) : null;
        }
        return n;
    }

    @JvmStatic
    public static final void setBorderRadius(@NotNull View view, @NotNull BorderRadiusProp corner, @Nullable LengthPercentage radius) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        boolean $i$f$filterIsInstanceTo;
        Collection destination$iv$iv;
        boolean $i$f$filterIsInstance;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)corner), (String)"corner");
        CompositeBackgroundDrawable compositeBackgroundDrawable = INSTANCE.ensureCompositeBackgroundDrawable(view);
        BorderRadiusStyle borderRadiusStyle = compositeBackgroundDrawable.getBorderRadius();
        if (borderRadiusStyle == null) {
            borderRadiusStyle = new BorderRadiusStyle(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }
        compositeBackgroundDrawable.setBorderRadius(borderRadiusStyle);
        BorderRadiusStyle borderRadiusStyle2 = compositeBackgroundDrawable.getBorderRadius();
        if (borderRadiusStyle2 != null) {
            borderRadiusStyle2.set(corner, radius);
        }
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            if (view instanceof ImageView) {
                INSTANCE.ensureBackgroundDrawable(view);
            }
            BackgroundDrawable backgroundDrawable = compositeBackgroundDrawable.getBackground();
            if (backgroundDrawable != null) {
                backgroundDrawable.setBorderRadius(compositeBackgroundDrawable.getBorderRadius());
            }
            BorderDrawable borderDrawable = compositeBackgroundDrawable.getBorder();
            if (borderDrawable != null) {
                borderDrawable.setBorderRadius(compositeBackgroundDrawable.getBorderRadius());
            }
            BackgroundDrawable backgroundDrawable2 = compositeBackgroundDrawable.getBackground();
            if (backgroundDrawable2 != null) {
                backgroundDrawable2.invalidateSelf();
            }
            BorderDrawable borderDrawable2 = compositeBackgroundDrawable.getBorder();
            if (borderDrawable2 != null) {
                borderDrawable2.invalidateSelf();
            }
        } else {
            INSTANCE.ensureCSSBackground(view).setBorderRadius(corner, radius);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            $this$filterIsInstance$iv = compositeBackgroundDrawable.getOuterShadows();
            $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof OutsetBoxShadowDrawable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Drawable shadow : (List)destination$iv$iv) {
                shadow.setBorderRadius(compositeBackgroundDrawable.getBorderRadius());
            }
        }
        if (Build.VERSION.SDK_INT >= 29) {
            $this$filterIsInstance$iv = compositeBackgroundDrawable.getInnerShadows();
            $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof InsetBoxShadowDrawable)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Drawable shadow : (List)destination$iv$iv) {
                shadow.setBorderRadius(compositeBackgroundDrawable.getBorderRadius());
            }
        }
        OutlineDrawable outlineDrawable = compositeBackgroundDrawable.getOutline();
        if (outlineDrawable != null) {
            outlineDrawable.setBorderRadius(compositeBackgroundDrawable.getBorderRadius());
        }
        compositeBackgroundDrawable.invalidateSelf();
    }

    @JvmStatic
    @Nullable
    public static final LengthPercentage getBorderRadius(@NotNull View view, @NotNull BorderRadiusProp corner) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)corner), (String)"corner");
        return ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables() ? ((object2 = INSTANCE.getCompositeBackgroundDrawable(view)) != null && (object2 = ((CompositeBackgroundDrawable)((Object)object2)).getBorderRadius()) != null ? ((BorderRadiusStyle)object2).get(corner) : null) : ((object = INSTANCE.getCSSBackground(view)) != null && (object = ((CSSBackgroundDrawable)((Object)object)).getBorderRadius()) != null ? ((BorderRadiusStyle)object).get(corner) : null);
    }

    @JvmStatic
    public static final void setBorderStyle(@NotNull View view, @Nullable BorderStyle borderStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            INSTANCE.ensureBorderDrawable(view).setBorderStyle(borderStyle);
        } else {
            INSTANCE.ensureCSSBackground(view).setBorderStyle(borderStyle);
        }
    }

    @JvmStatic
    @Nullable
    public static final BorderStyle getBorderStyle(@NotNull View view) {
        BorderStyle borderStyle;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            BorderDrawable borderDrawable = INSTANCE.getBorder(view);
            borderStyle = borderDrawable != null ? borderDrawable.getBorderStyle() : null;
        } else {
            CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
            borderStyle = cSSBackgroundDrawable != null ? cSSBackgroundDrawable.getBorderStyle() : null;
        }
        return borderStyle;
    }

    @JvmStatic
    public static final void setOutlineColor(@NotNull View view, @ColorInt @Nullable Integer outlineColor) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ViewUtil.getUIManagerType(view) != 2) {
            return;
        }
        OutlineDrawable outline = INSTANCE.ensureOutlineDrawable(view);
        if (outlineColor != null) {
            outline.setOutlineColor(outlineColor);
        }
    }

    @JvmStatic
    @Nullable
    public static final Integer getOutlineColor(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        OutlineDrawable outlineDrawable = INSTANCE.getOutlineDrawable(view);
        return outlineDrawable != null ? Integer.valueOf(outlineDrawable.getOutlineColor()) : null;
    }

    @JvmStatic
    public static final void setOutlineOffset(@NotNull View view, float outlineOffset) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ViewUtil.getUIManagerType(view) != 2) {
            return;
        }
        OutlineDrawable outline = INSTANCE.ensureOutlineDrawable(view);
        outline.setOutlineOffset(PixelUtil.INSTANCE.dpToPx(outlineOffset));
    }

    @Nullable
    public final Float getOutlineOffset(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        OutlineDrawable outlineDrawable = this.getOutlineDrawable(view);
        return outlineDrawable != null ? Float.valueOf(outlineDrawable.getOutlineOffset()) : null;
    }

    @JvmStatic
    public static final void setOutlineStyle(@NotNull View view, @Nullable OutlineStyle outlineStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ViewUtil.getUIManagerType(view) != 2) {
            return;
        }
        OutlineDrawable outline = INSTANCE.ensureOutlineDrawable(view);
        if (outlineStyle != null) {
            outline.setOutlineStyle(outlineStyle);
        }
    }

    @Nullable
    public final OutlineStyle getOutlineStyle(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        OutlineDrawable outlineDrawable = this.getOutlineDrawable(view);
        return outlineDrawable != null ? outlineDrawable.getOutlineStyle() : null;
    }

    @JvmStatic
    public static final void setOutlineWidth(@NotNull View view, float width) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ViewUtil.getUIManagerType(view) != 2) {
            return;
        }
        OutlineDrawable outline = INSTANCE.ensureOutlineDrawable(view);
        outline.setOutlineWidth(PixelUtil.INSTANCE.dpToPx(width));
    }

    @Nullable
    public final Float getOutlineWidth(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        OutlineDrawable outlineDrawable = this.getOutlineDrawable(view);
        return outlineDrawable != null ? Float.valueOf(outlineDrawable.getOutlineOffset()) : null;
    }

    @JvmStatic
    public static final void setBoxShadow(@NotNull View view, @NotNull List<BoxShadow> shadows) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(shadows, (String)"shadows");
        if (ViewUtil.getUIManagerType(view) != 2) {
            return;
        }
        List innerShadows = new ArrayList();
        List outerShadows = new ArrayList();
        CompositeBackgroundDrawable compositeBackgroundDrawable = INSTANCE.ensureCompositeBackgroundDrawable(view);
        BorderInsets borderInsets = compositeBackgroundDrawable.getBorderInsets();
        BorderRadiusStyle borderRadius = compositeBackgroundDrawable.getBorderRadius();
        for (BoxShadow boxShadow : shadows) {
            Context context;
            boolean inset;
            float offsetX = boxShadow.getOffsetX();
            float offsetY = boxShadow.getOffsetY();
            Integer n = boxShadow.getColor();
            int color = n != null ? n : -16777216;
            Float f = boxShadow.getBlurRadius();
            float blurRadius = f != null ? f.floatValue() : 0.0f;
            Float f2 = boxShadow.getSpreadDistance();
            float spreadDistance = f2 != null ? f2.floatValue() : 0.0f;
            Boolean bl = boxShadow.getInset();
            boolean bl2 = inset = bl != null ? bl : false;
            if (inset && Build.VERSION.SDK_INT >= 29) {
                Intrinsics.checkNotNullExpressionValue((Object)view.getContext(), (String)"getContext(...)");
                innerShadows.add(new InsetBoxShadowDrawable(context, color, offsetX, offsetY, blurRadius, spreadDistance, borderInsets, borderRadius));
                continue;
            }
            if (inset || Build.VERSION.SDK_INT < 28) continue;
            Intrinsics.checkNotNullExpressionValue((Object)view.getContext(), (String)"getContext(...)");
            outerShadows.add(new OutsetBoxShadowDrawable(context, color, offsetX, offsetY, blurRadius, spreadDistance, borderRadius));
        }
        view.setBackground((Drawable)INSTANCE.ensureCompositeBackgroundDrawable(view).withNewShadows(outerShadows, innerShadows));
    }

    @JvmStatic
    public static final void setBoxShadow(@NotNull View view, @Nullable ReadableArray shadows) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (shadows == null) {
            BackgroundStyleApplicator.setBoxShadow(view, CollectionsKt.emptyList());
            return;
        }
        List shadowStyles = new ArrayList();
        int n = shadows.size();
        for (int i = 0; i < n; ++i) {
            ReadableMap readableMap = shadows.getMap(i);
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            BoxShadow boxShadow = BoxShadow.Companion.parse(readableMap, context);
            if (boxShadow == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            shadowStyles.add(boxShadow);
        }
        BackgroundStyleApplicator.setBoxShadow(view, shadowStyles);
    }

    @JvmStatic
    public static final void setFeedbackUnderlay(@NotNull View view, @Nullable Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            INSTANCE.ensureCompositeBackgroundDrawable(view).withNewFeedbackUnderlay(drawable2);
        } else {
            view.setBackground((Drawable)INSTANCE.ensureCompositeBackgroundDrawable(view).withNewFeedbackUnderlay(drawable2));
        }
    }

    @JvmStatic
    public static final void clipToPaddingBox(@NotNull View view, @NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables()) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            RectF rectF;
            Rect drawingRect = new Rect();
            view.getDrawingRect(drawingRect);
            CompositeBackgroundDrawable composite = INSTANCE.getCompositeBackgroundDrawable(view);
            if (composite == null) {
                canvas.clipRect(drawingRect);
                return;
            }
            RectF paddingBoxRect = new RectF();
            BorderInsets borderInsets = composite.getBorderInsets();
            if (borderInsets != null) {
                int n = composite.getLayoutDirection();
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                rectF = borderInsets.resolve(n, context);
            } else {
                rectF = null;
            }
            RectF computedBorderInsets = rectF;
            float f6 = composite.getBounds().left;
            RectF rectF2 = computedBorderInsets;
            if (rectF2 != null) {
                f5 = rectF2.left;
                f4 = PixelUtil.INSTANCE.dpToPx(f5);
            } else {
                f4 = 0.0f;
            }
            paddingBoxRect.left = f6 + f4;
            float f7 = composite.getBounds().top;
            RectF rectF3 = computedBorderInsets;
            if (rectF3 != null) {
                f5 = rectF3.top;
                f3 = PixelUtil.INSTANCE.dpToPx(f5);
            } else {
                f3 = 0.0f;
            }
            paddingBoxRect.top = f7 + f3;
            float f8 = composite.getBounds().right;
            RectF rectF4 = computedBorderInsets;
            if (rectF4 != null) {
                f5 = rectF4.right;
                f2 = PixelUtil.INSTANCE.dpToPx(f5);
            } else {
                f2 = 0.0f;
            }
            paddingBoxRect.right = f8 - f2;
            float f9 = composite.getBounds().bottom;
            RectF rectF5 = computedBorderInsets;
            if (rectF5 != null) {
                f5 = rectF5.bottom;
                f = PixelUtil.INSTANCE.dpToPx(f5);
            } else {
                f = 0.0f;
            }
            paddingBoxRect.bottom = f9 - f;
            BorderRadiusStyle borderRadiusStyle = composite.getBorderRadius();
            boolean bl = borderRadiusStyle != null ? borderRadiusStyle.hasRoundedBorders() : false;
            if (bl) {
                Path paddingBoxPath = INSTANCE.createPaddingBoxPath(view, composite, paddingBoxRect, computedBorderInsets);
                paddingBoxPath.offset((float)drawingRect.left, (float)drawingRect.top);
                v18 = canvas.clipPath(paddingBoxPath);
            } else {
                paddingBoxRect.offset((float)drawingRect.left, (float)drawingRect.top);
                v18 = canvas.clipRect(paddingBoxRect);
            }
        } else {
            Rect drawingRect = new Rect();
            view.getDrawingRect(drawingRect);
            CSSBackgroundDrawable cssBackground = INSTANCE.getCSSBackground(view);
            if (cssBackground == null) {
                canvas.clipRect(drawingRect);
                return;
            }
            Path paddingBoxPath = cssBackground.getPaddingBoxPath();
            if (paddingBoxPath != null) {
                paddingBoxPath.offset((float)drawingRect.left, (float)drawingRect.top);
                v18 = canvas.clipPath(paddingBoxPath);
            } else {
                RectF rectF = cssBackground.getPaddingBoxRect();
                Intrinsics.checkNotNullExpressionValue((Object)rectF, (String)"getPaddingBoxRect(...)");
                RectF paddingBoxRect = rectF;
                paddingBoxRect.offset((float)drawingRect.left, (float)drawingRect.top);
                v18 = canvas.clipRect(paddingBoxRect);
            }
        }
    }

    @JvmStatic
    public static final void reset(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getBackground() instanceof CompositeBackgroundDrawable) {
            Drawable drawable2 = view.getBackground();
            Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.drawable.CompositeBackgroundDrawable");
            view.setBackground(((CompositeBackgroundDrawable)drawable2).getOriginalBackground());
        }
    }

    private final CompositeBackgroundDrawable ensureCompositeBackgroundDrawable(View view) {
        if (view.getBackground() instanceof CompositeBackgroundDrawable) {
            Drawable drawable2 = view.getBackground();
            Intrinsics.checkNotNull((Object)drawable2, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.drawable.CompositeBackgroundDrawable");
            return (CompositeBackgroundDrawable)drawable2;
        }
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        CompositeBackgroundDrawable compositeDrawable = new CompositeBackgroundDrawable(context, view.getBackground(), null, null, null, null, null, null, null, null, null, 2044, null);
        view.setBackground((Drawable)compositeDrawable);
        return compositeDrawable;
    }

    private final CompositeBackgroundDrawable getCompositeBackgroundDrawable(View view) {
        Drawable drawable2 = view.getBackground();
        return drawable2 instanceof CompositeBackgroundDrawable ? (CompositeBackgroundDrawable)drawable2 : null;
    }

    private final CSSBackgroundDrawable ensureCSSBackground(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.ensureCompositeBackgroundDrawable(view);
        CSSBackgroundDrawable cssBackground = compositeBackgroundDrawable.getCssBackground();
        if (cssBackground != null) {
            return cssBackground;
        }
        cssBackground = new CSSBackgroundDrawable(view.getContext());
        view.setBackground((Drawable)compositeBackgroundDrawable.withNewCssBackground(cssBackground));
        return cssBackground;
    }

    private final BackgroundDrawable ensureBackgroundDrawable(View view) {
        BackgroundDrawable backgroundDrawable;
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.ensureCompositeBackgroundDrawable(view);
        BackgroundDrawable background = compositeBackgroundDrawable.getBackground();
        if (background != null) {
            backgroundDrawable = background;
        } else {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            background = new BackgroundDrawable(context, compositeBackgroundDrawable.getBorderRadius(), compositeBackgroundDrawable.getBorderInsets());
            view.setBackground((Drawable)compositeBackgroundDrawable.withNewBackground(background));
            backgroundDrawable = background;
        }
        return backgroundDrawable;
    }

    private final CSSBackgroundDrawable getCSSBackground(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.getCompositeBackgroundDrawable(view);
        return compositeBackgroundDrawable != null ? compositeBackgroundDrawable.getCssBackground() : null;
    }

    private final BackgroundDrawable getBackground(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.getCompositeBackgroundDrawable(view);
        return compositeBackgroundDrawable != null ? compositeBackgroundDrawable.getBackground() : null;
    }

    private final BorderDrawable getBorder(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.getCompositeBackgroundDrawable(view);
        return compositeBackgroundDrawable != null ? compositeBackgroundDrawable.getBorder() : null;
    }

    private final BorderDrawable ensureBorderDrawable(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.ensureCompositeBackgroundDrawable(view);
        BorderDrawable border = compositeBackgroundDrawable.getBorder();
        if (border == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context2 = context;
            BorderRadiusStyle borderRadiusStyle = compositeBackgroundDrawable.getBorderRadius();
            Spacing spacing = new Spacing(0.0f);
            BorderStyle borderStyle = BorderStyle.SOLID;
            BorderInsets borderInsets = compositeBackgroundDrawable.getBorderInsets();
            border = new BorderDrawable(context2, spacing, borderRadiusStyle, borderInsets, borderStyle);
            view.setBackground((Drawable)compositeBackgroundDrawable.withNewBorder(border));
        }
        return border;
    }

    private final OutlineDrawable ensureOutlineDrawable(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.ensureCompositeBackgroundDrawable(view);
        OutlineDrawable outline = compositeBackgroundDrawable.getOutline();
        if (outline == null) {
            BorderRadiusStyle borderRadius = ReactNativeFeatureFlags.enableNewBackgroundAndBorderDrawables() ? compositeBackgroundDrawable.getBorderRadius() : this.ensureCSSBackground(view).getBorderRadius();
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            outline = new OutlineDrawable(context, borderRadius, -16777216, 0.0f, OutlineStyle.SOLID, 0.0f);
            view.setBackground((Drawable)compositeBackgroundDrawable.withNewOutline(outline));
        }
        return outline;
    }

    private final OutlineDrawable getOutlineDrawable(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.getCompositeBackgroundDrawable(view);
        return compositeBackgroundDrawable != null ? compositeBackgroundDrawable.getOutline() : null;
    }

    private final float getInnerBorderRadius(Float computedRadius, Float borderWidth) {
        Float f = computedRadius;
        Float f2 = borderWidth;
        return RangesKt.coerceAtLeast((float)((f != null ? f.floatValue() : 0.0f) - (f2 != null ? f2.floatValue() : 0.0f)), (float)0.0f);
    }

    private final Path createPaddingBoxPath(View view, CompositeBackgroundDrawable composite, RectF paddingBoxRect, RectF computedBorderInsets) {
        Float f;
        Float f2;
        Float f3;
        Float f4;
        float f5;
        Float f6;
        Float f7;
        float f8;
        Float f9;
        Float f10;
        float f11;
        Float f12;
        Float f13;
        float f14;
        Float f15;
        Float f16;
        float f17;
        Float f18;
        Float f19;
        float f20;
        Float f21;
        Float f22;
        float f23;
        ComputedBorderRadius computedBorderRadius;
        BorderRadiusStyle borderRadiusStyle = composite.getBorderRadius();
        if (borderRadiusStyle != null) {
            int n = composite.getLayoutDirection();
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            computedBorderRadius = borderRadiusStyle.resolve(n, context, PixelUtil.toDIPFromPixel(composite.getBounds().width()), PixelUtil.toDIPFromPixel(composite.getBounds().height()));
        } else {
            computedBorderRadius = null;
        }
        ComputedBorderRadius computedBorderRadius2 = computedBorderRadius;
        Path paddingBoxPath = new Path();
        Object object = computedBorderRadius2;
        if (object != null && (object = ((ComputedBorderRadius)object).getTopLeft()) != null) {
            f23 = ((CornerRadii)object).getHorizontal();
            f22 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f23));
        } else {
            f22 = null;
        }
        RectF rectF = computedBorderInsets;
        if (rectF != null) {
            float f24 = rectF.left;
            f21 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f24));
        } else {
            f21 = null;
        }
        float innerTopLeftRadiusX = this.getInnerBorderRadius(f22, f21);
        Object object2 = computedBorderRadius2;
        if (object2 != null && (object2 = ((ComputedBorderRadius)object2).getTopLeft()) != null) {
            f20 = ((CornerRadii)object2).getVertical();
            f19 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f20));
        } else {
            f19 = null;
        }
        RectF rectF2 = computedBorderInsets;
        if (rectF2 != null) {
            f23 = rectF2.top;
            f18 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f23));
        } else {
            f18 = null;
        }
        float innerTopLeftRadiusY = this.getInnerBorderRadius(f19, f18);
        Object object3 = computedBorderRadius2;
        if (object3 != null && (object3 = ((ComputedBorderRadius)object3).getTopRight()) != null) {
            f17 = ((CornerRadii)object3).getHorizontal();
            f16 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f17));
        } else {
            f16 = null;
        }
        RectF rectF3 = computedBorderInsets;
        if (rectF3 != null) {
            f20 = rectF3.right;
            f15 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f20));
        } else {
            f15 = null;
        }
        float innerTopRightRadiusX = this.getInnerBorderRadius(f16, f15);
        Object object4 = computedBorderRadius2;
        if (object4 != null && (object4 = ((ComputedBorderRadius)object4).getTopRight()) != null) {
            f14 = ((CornerRadii)object4).getVertical();
            f13 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f14));
        } else {
            f13 = null;
        }
        RectF rectF4 = computedBorderInsets;
        if (rectF4 != null) {
            f17 = rectF4.top;
            f12 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f17));
        } else {
            f12 = null;
        }
        float innerTopRightRadiusY = this.getInnerBorderRadius(f13, f12);
        Object object5 = computedBorderRadius2;
        if (object5 != null && (object5 = ((ComputedBorderRadius)object5).getBottomRight()) != null) {
            f11 = ((CornerRadii)object5).getHorizontal();
            f10 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f11));
        } else {
            f10 = null;
        }
        RectF rectF5 = computedBorderInsets;
        if (rectF5 != null) {
            f14 = rectF5.right;
            f9 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f14));
        } else {
            f9 = null;
        }
        float innerBottomRightRadiusX = this.getInnerBorderRadius(f10, f9);
        Object object6 = computedBorderRadius2;
        if (object6 != null && (object6 = ((ComputedBorderRadius)object6).getBottomRight()) != null) {
            f8 = ((CornerRadii)object6).getVertical();
            f7 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f8));
        } else {
            f7 = null;
        }
        RectF rectF6 = computedBorderInsets;
        if (rectF6 != null) {
            f11 = rectF6.bottom;
            f6 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f11));
        } else {
            f6 = null;
        }
        float innerBottomRightRadiusY = this.getInnerBorderRadius(f7, f6);
        Object object7 = computedBorderRadius2;
        if (object7 != null && (object7 = ((ComputedBorderRadius)object7).getBottomLeft()) != null) {
            f5 = ((CornerRadii)object7).getHorizontal();
            f4 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f5));
        } else {
            f4 = null;
        }
        RectF rectF7 = computedBorderInsets;
        if (rectF7 != null) {
            f8 = rectF7.left;
            f3 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f8));
        } else {
            f3 = null;
        }
        float innerBottomLeftRadiusX = this.getInnerBorderRadius(f4, f3);
        Object object8 = computedBorderRadius2;
        if (object8 != null && (object8 = ((ComputedBorderRadius)object8).getBottomLeft()) != null) {
            float f25 = ((CornerRadii)object8).getVertical();
            f2 = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f25));
        } else {
            f2 = null;
        }
        RectF rectF8 = computedBorderInsets;
        if (rectF8 != null) {
            f5 = rectF8.bottom;
            f = Float.valueOf(PixelUtil.INSTANCE.dpToPx(f5));
        } else {
            f = null;
        }
        float innerBottomLeftRadiusY = this.getInnerBorderRadius(f2, f);
        float[] fArray = new float[]{innerTopLeftRadiusX, innerTopLeftRadiusY, innerTopRightRadiusX, innerTopRightRadiusY, innerBottomRightRadiusX, innerBottomRightRadiusY, innerBottomLeftRadiusX, innerBottomLeftRadiusY};
        paddingBoxPath.addRoundRect(paddingBoxRect, fArray, Path.Direction.CW);
        return paddingBoxPath;
    }
}

