/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.react.ReactHost;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.fabric.SurfaceHandlerBinding;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.runtime.ReactSurfaceView;
import com.facebook.react.runtime.internal.bolts.Task;
import com.facebook.react.uimanager.events.EventDispatcher;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u0019\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000bJ\b\u0010\"\u001a\u00020\u001bH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\b\u00101\u001a\u00020\u001bH\u0016J-\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020,H\u0001\u00a2\u0006\u0002\b7R\u0016\u0010\u0002\u001a\u00020\u00038AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001f\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0016\u00108\u001a\u0004\u0018\u0001098@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010?\u00a8\u0006B"}, d2={"Lcom/facebook/react/runtime/ReactSurfaceImpl;", "Lcom/facebook/react/interfaces/fabric/ReactSurface;", "surfaceHandler", "Lcom/facebook/react/fabric/SurfaceHandlerBinding;", "context", "Landroid/content/Context;", "<init>", "(Lcom/facebook/react/fabric/SurfaceHandlerBinding;Landroid/content/Context;)V", "moduleName", "", "initialProps", "Landroid/os/Bundle;", "(Landroid/content/Context;Ljava/lang/String;Landroid/os/Bundle;)V", "getSurfaceHandler", "()Lcom/facebook/react/fabric/SurfaceHandlerBinding;", "value", "getContext", "()Landroid/content/Context;", "surfaceViewRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/facebook/react/runtime/ReactSurfaceView;", "reactHostRef", "Lcom/facebook/react/runtime/ReactHostImpl;", "reactHost", "getReactHost$ReactAndroid_release", "()Lcom/facebook/react/runtime/ReactHostImpl;", "attach", "", "host", "Lcom/facebook/react/ReactHost;", "attachView", "view", "updateInitProps", "newProps", "detach", "Landroid/view/ViewGroup;", "getView", "()Landroid/view/ViewGroup;", "prerender", "Lcom/facebook/react/interfaces/TaskInterface;", "Ljava/lang/Void;", "start", "stop", "surfaceID", "", "getSurfaceID", "()I", "getModuleName", "()Ljava/lang/String;", "clear", "updateLayoutSpecs", "widthMeasureSpec", "heightMeasureSpec", "offsetX", "offsetY", "updateLayoutSpecs$ReactAndroid_release", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher$ReactAndroid_release", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "isAttached", "", "isAttached$ReactAndroid_release", "()Z", "isRunning", "Companion", "ReactAndroid_release"})
@ThreadSafe
@SourceDebugExtension(value={"SMAP\nReactSurfaceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactSurfaceImpl.kt\ncom/facebook/react/runtime/ReactSurfaceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class ReactSurfaceImpl
implements ReactSurface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SurfaceHandlerBinding surfaceHandler;
    @NotNull
    private Context context;
    @NotNull
    private final AtomicReference<ReactSurfaceView> surfaceViewRef;
    @NotNull
    private final AtomicReference<ReactHostImpl> reactHostRef;

    @VisibleForTesting
    public ReactSurfaceImpl(@NotNull SurfaceHandlerBinding surfaceHandler, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)((Object)surfaceHandler), (String)"surfaceHandler");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.surfaceHandler = surfaceHandler;
        this.context = context;
        this.surfaceViewRef = new AtomicReference<Object>(null);
        this.reactHostRef = new AtomicReference<Object>(null);
    }

    @JvmName(name="getSurfaceHandler")
    @NotNull
    public final SurfaceHandlerBinding getSurfaceHandler() {
        return this.surfaceHandler;
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.context;
    }

    @Nullable
    public final ReactHostImpl getReactHost$ReactAndroid_release() {
        return this.reactHostRef.get();
    }

    public ReactSurfaceImpl(@NotNull Context context, @NotNull String moduleName, @Nullable Bundle initialProps) {
        NativeMap nativeMap;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        this(new SurfaceHandlerBinding(moduleName), context);
        Bundle bundle = initialProps;
        if (bundle != null) {
            Bundle it = bundle;
            boolean bl = false;
            WritableMap writableMap = Arguments.fromBundle(it);
            Intrinsics.checkNotNull((Object)writableMap, (String)"null cannot be cast to non-null type com.facebook.react.bridge.NativeMap");
            nativeMap = (NativeMap)((Object)writableMap);
        } else {
            nativeMap = null;
        }
        NativeMap nativeProps = nativeMap;
        this.surfaceHandler.setProps(nativeProps);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.surfaceHandler.setLayoutConstraints(View.MeasureSpec.makeMeasureSpec((int)displayMetrics.widthPixels, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)displayMetrics.heightPixels, (int)Integer.MIN_VALUE), 0, 0, ReactSurfaceImpl.Companion.doRTLSwap(context), ReactSurfaceImpl.Companion.isRTL(context), displayMetrics.density, ReactSurfaceImpl.Companion.getFontScale(context));
    }

    public final void attach(@NotNull ReactHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (!(host instanceof ReactHostImpl)) {
            boolean $i$a$-require-ReactSurfaceImpl$attach$22 = false;
            String $i$a$-require-ReactSurfaceImpl$attach$22 = "ReactSurfaceImpl.attach can only attach to ReactHostImpl.";
            throw new IllegalArgumentException($i$a$-require-ReactSurfaceImpl$attach$22.toString());
        }
        if (!this.reactHostRef.compareAndSet(null, (ReactHostImpl)host)) {
            boolean bl = false;
            String string2 = "This surface is already attached to a host!";
            throw new IllegalStateException(string2.toString());
        }
    }

    public final void attachView(@NotNull ReactSurfaceView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.surfaceViewRef.compareAndSet(null, view)) {
            boolean bl = false;
            String string2 = "Trying to call ReactSurface.attachView(), but the view is already attached.";
            throw new IllegalStateException(string2.toString());
        }
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.context = context;
    }

    public final void updateInitProps(@NotNull Bundle newProps) {
        Intrinsics.checkNotNullParameter((Object)newProps, (String)"newProps");
        WritableMap writableMap = Arguments.fromBundle(newProps);
        Intrinsics.checkNotNull((Object)writableMap, (String)"null cannot be cast to non-null type com.facebook.react.bridge.NativeMap");
        this.surfaceHandler.setProps((NativeMap)((Object)writableMap));
    }

    @Override
    public void detach() {
        this.reactHostRef.set(null);
    }

    @Override
    @Nullable
    public ViewGroup getView() {
        return (ViewGroup)this.surfaceViewRef.get();
    }

    @Override
    @NotNull
    public TaskInterface<Void> prerender() {
        ReactHostImpl reactHostImpl = this.getReactHost$ReactAndroid_release();
        if (reactHostImpl == null) {
            return Task.Companion.forError(new IllegalStateException("Trying to call ReactSurface.prerender(), but no ReactHost is attached."));
        }
        ReactHostImpl host = reactHostImpl;
        return host.prerenderSurface$ReactAndroid_release(this);
    }

    @Override
    @NotNull
    public TaskInterface<Void> start() {
        if (this.surfaceViewRef.get() == null) {
            return Task.Companion.forError(new IllegalStateException("Trying to call ReactSurface.start(), but view is not created."));
        }
        ReactHostImpl reactHostImpl = this.getReactHost$ReactAndroid_release();
        if (reactHostImpl == null) {
            return Task.Companion.forError(new IllegalStateException("Trying to call ReactSurface.start(), but no ReactHost is attached."));
        }
        ReactHostImpl host = reactHostImpl;
        return host.startSurface$ReactAndroid_release(this);
    }

    @Override
    @NotNull
    public TaskInterface<Void> stop() {
        ReactHostImpl reactHostImpl = this.getReactHost$ReactAndroid_release();
        if (reactHostImpl == null) {
            return Task.Companion.forError(new IllegalStateException("Trying to call ReactSurface.stop(), but no ReactHost is attached."));
        }
        ReactHostImpl host = reactHostImpl;
        return host.stopSurface$ReactAndroid_release(this);
    }

    @Override
    public int getSurfaceID() {
        return this.surfaceHandler.getSurfaceId();
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.surfaceHandler.getModuleName();
    }

    @Override
    public void clear() {
        UiThreadUtil.runOnUiThread(() -> ReactSurfaceImpl.clear$lambda$4(this));
    }

    @UiThread
    public final synchronized void updateLayoutSpecs$ReactAndroid_release(int widthMeasureSpec, int heightMeasureSpec, int offsetX, int offsetY) {
        this.surfaceHandler.setLayoutConstraints(widthMeasureSpec, heightMeasureSpec, offsetX, offsetY, ReactSurfaceImpl.Companion.doRTLSwap(this.getContext()), ReactSurfaceImpl.Companion.isRTL(this.getContext()), this.getContext().getResources().getDisplayMetrics().density, ReactSurfaceImpl.Companion.getFontScale(this.getContext()));
    }

    @Nullable
    public final EventDispatcher getEventDispatcher$ReactAndroid_release() {
        ReactHostImpl reactHostImpl = this.getReactHost$ReactAndroid_release();
        return reactHostImpl != null ? reactHostImpl.getEventDispatcher$ReactAndroid_release() : null;
    }

    public final boolean isAttached$ReactAndroid_release() {
        return this.getReactHost$ReactAndroid_release() != null;
    }

    @Override
    public boolean isRunning() {
        return this.surfaceHandler.isRunning();
    }

    private static final void clear$lambda$4(ReactSurfaceImpl this$0) {
        ViewGroup view = this$0.getView();
        if (view != null) {
            view.removeAllViews();
            view.setId(-1);
        }
    }

    @JvmStatic
    @NotNull
    public static final ReactSurfaceImpl createWithView(@NotNull Context context, @NotNull String moduleName, @Nullable Bundle initialProps) {
        return Companion.createWithView(context, moduleName, initialProps);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/runtime/ReactSurfaceImpl$Companion;", "", "<init>", "()V", "createWithView", "Lcom/facebook/react/runtime/ReactSurfaceImpl;", "context", "Landroid/content/Context;", "moduleName", "", "initialProps", "Landroid/os/Bundle;", "isRTL", "", "getFontScale", "", "doRTLSwap", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ReactSurfaceImpl createWithView(@NotNull Context context, @NotNull String moduleName, @Nullable Bundle initialProps) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            ReactSurfaceImpl surface = new ReactSurfaceImpl(context, moduleName, initialProps);
            surface.attachView(new ReactSurfaceView(context, surface));
            return surface;
        }

        private final boolean isRTL(Context context) {
            return I18nUtil.Companion.getInstance().isRTL(context);
        }

        private final float getFontScale(Context context) {
            return ReactNativeFeatureFlags.enableFontScaleChangesUpdatingLayout() ? context.getResources().getConfiguration().fontScale : 1.0f;
        }

        private final boolean doRTLSwap(Context context) {
            return I18nUtil.Companion.getInstance().doLeftAndRightSwapInRTL(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

