/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.runtime.ReactSurfaceImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UnstableReactNativeAPI
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/facebook/react/runtime/ReactHostImplDevHelper;", "Lcom/facebook/react/devsupport/ReactInstanceDevHelper;", "delegate", "Lcom/facebook/react/runtime/ReactHostImpl;", "<init>", "(Lcom/facebook/react/runtime/ReactHostImpl;)V", "currentActivity", "Landroid/app/Activity;", "getCurrentActivity", "()Landroid/app/Activity;", "javaScriptExecutorFactory", "Lcom/facebook/react/bridge/JavaScriptExecutorFactory;", "getJavaScriptExecutorFactory", "()Lcom/facebook/react/bridge/JavaScriptExecutorFactory;", "currentReactContext", "Lcom/facebook/react/bridge/ReactContext;", "getCurrentReactContext", "()Lcom/facebook/react/bridge/ReactContext;", "onJSBundleLoadedFromServer", "", "toggleElementInspector", "createRootView", "Landroid/view/View;", "appKey", "", "destroyRootView", "rootView", "reload", "reason", "loadBundle", "Lcom/facebook/react/interfaces/TaskInterface;", "", "bundleLoader", "Lcom/facebook/react/bridge/JSBundleLoader;", "ReactAndroid_release"})
public final class ReactHostImplDevHelper
implements ReactInstanceDevHelper {
    @NotNull
    private final ReactHostImpl delegate;

    public ReactHostImplDevHelper(@NotNull ReactHostImpl delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public Activity getCurrentActivity() {
        return this.delegate.getLastUsedActivity$ReactAndroid_release();
    }

    @Override
    @NotNull
    public JavaScriptExecutorFactory getJavaScriptExecutorFactory() {
        throw new IllegalStateException("Not implemented for bridgeless mode");
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        return this.delegate.getCurrentReactContext();
    }

    @Override
    public void onJSBundleLoadedFromServer() {
    }

    @Override
    public void toggleElementInspector() {
        block0: {
            DeviceEventManagerModule.RCTDeviceEventEmitter rCTDeviceEventEmitter;
            ReactContext reactContext = this.delegate.getCurrentReactContext();
            if (reactContext == null || (rCTDeviceEventEmitter = reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)) == null) break block0;
            rCTDeviceEventEmitter.emit("toggleElementInspector", null);
        }
    }

    @Override
    @Nullable
    public View createRootView(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity != null && !this.delegate.isSurfaceWithModuleNameAttached$ReactAndroid_release(appKey)) {
            ReactSurfaceImpl reactSurface = ReactSurfaceImpl.Companion.createWithView((Context)currentActivity, appKey, new Bundle());
            reactSurface.attach(this.delegate);
            reactSurface.start();
            return (View)reactSurface.getView();
        }
        return null;
    }

    @Override
    public void destroyRootView(@NotNull View rootView) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
    }

    @Override
    public void reload(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.delegate.reload(reason);
    }

    @Override
    @NotNull
    public TaskInterface<Boolean> loadBundle(@NotNull JSBundleLoader bundleLoader) {
        Intrinsics.checkNotNullParameter((Object)bundleLoader, (String)"bundleLoader");
        return this.delegate.loadBundle$ReactAndroid_release(bundleLoader);
    }
}

