/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.toast;

import android.content.Context;
import android.widget.Toast;
import com.facebook.fbreact.specs.NativeToastAndroidSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.module.annotations.ReactModule;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="ToastAndroid")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J2\u0010\u0011\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/modules/toast/ToastModule;", "Lcom/facebook/fbreact/specs/NativeToastAndroidSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "getTypedExportedConstants", "", "", "", "show", "", "message", "durationDouble", "", "showWithGravity", "gravityDouble", "showWithGravityAndOffset", "xOffsetDouble", "yOffsetDouble", "Companion", "ReactAndroid_release"})
public final class ToastModule
extends NativeToastAndroidSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "ToastAndroid";
    @NotNull
    private static final String DURATION_SHORT_KEY = "SHORT";
    @NotNull
    private static final String DURATION_LONG_KEY = "LONG";
    @NotNull
    private static final String GRAVITY_TOP_KEY = "TOP";
    @NotNull
    private static final String GRAVITY_BOTTOM_KEY = "BOTTOM";
    @NotNull
    private static final String GRAVITY_CENTER = "CENTER";

    public ToastModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
    }

    @Override
    @NotNull
    protected Map<String, Object> getTypedExportedConstants() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DURATION_SHORT_KEY, (Object)0), TuplesKt.to((Object)DURATION_LONG_KEY, (Object)1), TuplesKt.to((Object)GRAVITY_TOP_KEY, (Object)49), TuplesKt.to((Object)GRAVITY_BOTTOM_KEY, (Object)81), TuplesKt.to((Object)GRAVITY_CENTER, (Object)17)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Override
    public void show(@Nullable String message, double durationDouble) {
        int duration = (int)durationDouble;
        UiThreadUtil.runOnUiThread(() -> ToastModule.show$lambda$0(this, message, duration));
    }

    @Override
    public void showWithGravity(@Nullable String message, double durationDouble, double gravityDouble) {
        int duration = (int)durationDouble;
        int gravity = (int)gravityDouble;
        UiThreadUtil.runOnUiThread(() -> ToastModule.showWithGravity$lambda$1(this, message, duration, gravity));
    }

    @Override
    public void showWithGravityAndOffset(@Nullable String message, double durationDouble, double gravityDouble, double xOffsetDouble, double yOffsetDouble) {
        int duration = (int)durationDouble;
        int gravity = (int)gravityDouble;
        int xOffset = (int)xOffsetDouble;
        int yOffset = (int)yOffsetDouble;
        UiThreadUtil.runOnUiThread(() -> ToastModule.showWithGravityAndOffset$lambda$2(this, message, duration, gravity, xOffset, yOffset));
    }

    private static final void show$lambda$0(ToastModule this$0, String $message, int $duration) {
        Toast.makeText((Context)((Context)this$0.getReactApplicationContext()), (CharSequence)$message, (int)$duration).show();
    }

    private static final void showWithGravity$lambda$1(ToastModule this$0, String $message, int $duration, int $gravity) {
        Toast toast = Toast.makeText((Context)((Context)this$0.getReactApplicationContext()), (CharSequence)$message, (int)$duration);
        toast.setGravity($gravity, 0, 0);
        toast.show();
    }

    private static final void showWithGravityAndOffset$lambda$2(ToastModule this$0, String $message, int $duration, int $gravity, int $xOffset, int $yOffset) {
        Toast toast = Toast.makeText((Context)((Context)this$0.getReactApplicationContext()), (CharSequence)$message, (int)$duration);
        toast.setGravity($gravity, $xOffset, $yOffset);
        toast.show();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/modules/toast/ToastModule$Companion;", "", "<init>", "()V", "NAME", "", "DURATION_SHORT_KEY", "DURATION_LONG_KEY", "GRAVITY_TOP_KEY", "GRAVITY_BOTTOM_KEY", "GRAVITY_CENTER", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

