/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.network.ProgressListener;
import com.facebook.react.modules.network.ProgressRequestBody;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.-DeprecatedUpgrade;
import okio.BufferedSink;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\fH\u0007J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010$\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/facebook/react/modules/network/RequestBodyUtil;", "", "<init>", "()V", "CONTENT_ENCODING_GZIP", "", "NAME", "TEMP_FILE_SUFFIX", "isGzipEncoding", "", "encodingType", "getFileInputStream", "Ljava/io/InputStream;", "context", "Landroid/content/Context;", "fileContentUriStr", "getDownloadFileInputStream", "uri", "Landroid/net/Uri;", "createGzip", "Lokhttp3/RequestBody;", "mediaType", "Lokhttp3/MediaType;", "body", "closeQuietly", "", "source", "Lokio/Source;", "create", "inputStream", "createProgressRequest", "Lcom/facebook/react/modules/network/ProgressRequestBody;", "requestBody", "listener", "Lcom/facebook/react/modules/network/ProgressListener;", "getEmptyBody", "method", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nRequestBodyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestBodyUtil.kt\ncom/facebook/react/modules/network/RequestBodyUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,180:1\n739#2,9:181\n37#3:190\n36#3,3:191\n*S KotlinDebug\n*F\n+ 1 RequestBodyUtil.kt\ncom/facebook/react/modules/network/RequestBodyUtil\n*L\n68#1:181,9\n69#1:190\n69#1:191,3\n*E\n"})
public final class RequestBodyUtil {
    @NotNull
    public static final RequestBodyUtil INSTANCE = new RequestBodyUtil();
    @NotNull
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    @NotNull
    private static final String NAME = "RequestBodyUtil";
    @NotNull
    private static final String TEMP_FILE_SUFFIX = "temp";

    private RequestBodyUtil() {
    }

    @JvmStatic
    public static final boolean isGzipEncoding(@Nullable String encodingType) {
        return StringsKt.equals((String)CONTENT_ENCODING_GZIP, (String)encodingType, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final InputStream getFileInputStream(@NotNull Context context, @NotNull String fileContentUriStr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileContentUriStr, (String)"fileContentUriStr");
        try {
            Uri fileContentUri = Uri.parse((String)fileContentUriStr);
            String string2 = fileContentUri.getScheme();
            boolean bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"http", (boolean)false, (int)2, null) : false;
            if (bl) {
                Intrinsics.checkNotNull((Object)fileContentUri);
                return INSTANCE.getDownloadFileInputStream(context, fileContentUri);
            }
            if (StringsKt.startsWith$default((String)fileContentUriStr, (String)"data:", (boolean)false, (int)2, null)) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                Object object = fileContentUriStr;
                Regex regex = new Regex(",");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                byte[] decodedDataUrString = Base64.decode((String)thisCollection$iv.toArray(new String[0])[1], (int)0);
                return new ByteArrayInputStream(decodedDataUrString);
            }
            return context.getContentResolver().openInputStream(fileContentUri);
        }
        catch (Exception e) {
            FLog.e((String)"ReactNative", (String)("Could not retrieve file for contentUri " + fileContentUriStr), (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private final InputStream getDownloadFileInputStream(Context context, Uri uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @JvmStatic
    @Nullable
    public static final RequestBody createGzip(@Nullable MediaType mediaType, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ByteArrayOutputStream gzipByteArrayOutputStream = new ByteArrayOutputStream();
        try {
            OutputStream gzipOutputStream = new GZIPOutputStream(gzipByteArrayOutputStream);
            String string2 = body;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            gzipOutputStream.write(byArray);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            return null;
        }
        byte[] byArray = gzipByteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)mediaType, (byte[])byArray, (int)0, (int)0, (int)12, null);
    }

    private final void closeQuietly(Source source2) {
        try {
            source2.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @JvmStatic
    @NotNull
    public static final RequestBody create(@Nullable MediaType mediaType, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return new RequestBody(mediaType, inputStream){
            final /* synthetic */ MediaType $mediaType;
            final /* synthetic */ InputStream $inputStream;
            {
                this.$mediaType = $mediaType;
                this.$inputStream = $inputStream;
            }

            public MediaType contentType() {
                return this.$mediaType;
            }

            public long contentLength() {
                long l;
                try {
                    l = this.$inputStream.available();
                }
                catch (IOException e) {
                    l = 0L;
                }
                return l;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Source source2 = null;
                try {
                    source2 = -DeprecatedUpgrade.getOkio().source(this.$inputStream);
                    sink.writeAll(source2);
                }
                finally {
                    Source source3 = source2;
                    if (source3 != null) {
                        Source it = source3;
                        boolean bl = false;
                        RequestBodyUtil.access$closeQuietly(RequestBodyUtil.INSTANCE, it);
                    }
                }
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final ProgressRequestBody createProgressRequest(@NotNull RequestBody requestBody, @NotNull ProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return new ProgressRequestBody(requestBody, listener);
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @Nullable
    public static final RequestBody getEmptyBody(@NotNull String method) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            switch (method.hashCode()) {
                case 2461856: {
                    if (!method.equals("POST")) {
                        break;
                    }
                    ** GOTO lbl13
                }
                case 79599: {
                    if (!method.equals("PUT")) {
                        break;
                    }
                    ** GOTO lbl13
                }
                case 75900968: {
                    if (!method.equals("PATCH")) break;
lbl13:
                    // 3 sources

                    v0 = RequestBody.Companion.create(null, ByteString.EMPTY);
                    break block7;
                }
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ void access$closeQuietly(RequestBodyUtil $this, Source source2) {
        $this.closeQuietly(source2);
    }
}

