/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.dialog;

import android.app.Activity;
import android.content.DialogInterface;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeDialogManagerAndroidSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.dialog.AlertFragment;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="DialogManagerAndroid")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0003\u001d\u001e\u001fB\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0018\u00010\u0019R\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006 "}, d2={"Lcom/facebook/react/modules/dialog/DialogModule;", "Lcom/facebook/fbreact/specs/NativeDialogManagerAndroidSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "isInForeground", "", "getTypedExportedConstants", "", "", "", "initialize", "", "onHostPause", "onHostDestroy", "onHostResume", "showAlert", "options", "Lcom/facebook/react/bridge/ReadableMap;", "errorCallback", "Lcom/facebook/react/bridge/Callback;", "actionCallback", "fragmentManagerHelper", "Lcom/facebook/react/modules/dialog/DialogModule$FragmentManagerHelper;", "getFragmentManagerHelper", "()Lcom/facebook/react/modules/dialog/DialogModule$FragmentManagerHelper;", "invalidate", "FragmentManagerHelper", "AlertFragmentListener", "Companion", "ReactAndroid_release"})
public final class DialogModule
extends NativeDialogManagerAndroidSpec
implements LifecycleEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isInForeground;
    @NotNull
    public static final String NAME = "DialogManagerAndroid";
    @NotNull
    public static final String FRAGMENT_TAG = "com.facebook.catalyst.react.dialog.DialogModule";
    @NotNull
    public static final String ACTION_BUTTON_CLICKED = "buttonClicked";
    @NotNull
    public static final String ACTION_DISMISSED = "dismissed";
    @NotNull
    private static final String KEY_TITLE = "title";
    @NotNull
    private static final String KEY_MESSAGE = "message";
    @NotNull
    private static final String KEY_BUTTON_POSITIVE = "buttonPositive";
    @NotNull
    private static final String KEY_BUTTON_NEGATIVE = "buttonNegative";
    @NotNull
    private static final String KEY_BUTTON_NEUTRAL = "buttonNeutral";
    @NotNull
    private static final String KEY_ITEMS = "items";
    @NotNull
    private static final String KEY_CANCELABLE = "cancelable";
    @NotNull
    private static final Map<String, Object> CONSTANTS;

    public DialogModule(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @NotNull
    public Map<String, Object> getTypedExportedConstants() {
        return CONSTANTS;
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isInForeground = false;
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onHostResume() {
        this.isInForeground = true;
        FragmentManagerHelper fragmentManagerHelper = this.getFragmentManagerHelper();
        if (fragmentManagerHelper != null) {
            fragmentManagerHelper.showPendingAlert();
        } else {
            FLog.w(DialogModule.class, (String)"onHostResume called but no FragmentManager found");
        }
    }

    @Override
    public void showAlert(@NotNull ReadableMap options, @NotNull Callback errorCallback, @NotNull Callback actionCallback) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)errorCallback, (String)"errorCallback");
        Intrinsics.checkNotNullParameter((Object)actionCallback, (String)"actionCallback");
        FragmentManagerHelper fragmentManagerHelper = this.getFragmentManagerHelper();
        if (fragmentManagerHelper == null) {
            Object[] objectArray = new Object[]{"Tried to show an alert while not attached to an Activity"};
            errorCallback.invoke(objectArray);
            return;
        }
        Bundle args = new Bundle();
        if (options.hasKey(KEY_TITLE)) {
            args.putString(KEY_TITLE, options.getString(KEY_TITLE));
        }
        if (options.hasKey(KEY_MESSAGE)) {
            args.putString(KEY_MESSAGE, options.getString(KEY_MESSAGE));
        }
        if (options.hasKey(KEY_BUTTON_POSITIVE)) {
            args.putString("button_positive", options.getString(KEY_BUTTON_POSITIVE));
        }
        if (options.hasKey(KEY_BUTTON_NEGATIVE)) {
            args.putString("button_negative", options.getString(KEY_BUTTON_NEGATIVE));
        }
        if (options.hasKey(KEY_BUTTON_NEUTRAL)) {
            args.putString("button_neutral", options.getString(KEY_BUTTON_NEUTRAL));
        }
        if (options.hasKey(KEY_ITEMS)) {
            ReadableArray readableArray = options.getArray(KEY_ITEMS);
            if (readableArray == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            ReadableArray items = readableArray;
            CharSequence[] itemsArray = new CharSequence[items.size()];
            int n = items.size();
            for (int i = 0; i < n; ++i) {
                itemsArray[i] = items.getString(i);
            }
            args.putCharSequenceArray(KEY_ITEMS, itemsArray);
        }
        if (options.hasKey(KEY_CANCELABLE)) {
            args.putBoolean(KEY_CANCELABLE, options.getBoolean(KEY_CANCELABLE));
        }
        UiThreadUtil.runOnUiThread(() -> DialogModule.showAlert$lambda$0(fragmentManagerHelper, args, actionCallback));
    }

    private final FragmentManagerHelper getFragmentManagerHelper() {
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        if (!(activity instanceof FragmentActivity)) {
            return null;
        }
        FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
        return new FragmentManagerHelper(fragmentManager);
    }

    @Override
    public void invalidate() {
        this.getReactApplicationContext().removeLifecycleEventListener(this);
        super.invalidate();
    }

    private static final void showAlert$lambda$0(FragmentManagerHelper $fragmentManagerHelper, Bundle $args, Callback $actionCallback) {
        $fragmentManagerHelper.showNewAlert($args, $actionCallback);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ACTION_BUTTON_CLICKED, (Object)ACTION_BUTTON_CLICKED), TuplesKt.to((Object)ACTION_DISMISSED, (Object)ACTION_DISMISSED), TuplesKt.to((Object)KEY_BUTTON_POSITIVE, (Object)-1), TuplesKt.to((Object)KEY_BUTTON_NEGATIVE, (Object)-2), TuplesKt.to((Object)KEY_BUTTON_NEUTRAL, (Object)-3)};
        CONSTANTS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/modules/dialog/DialogModule$AlertFragmentListener;", "Landroid/content/DialogInterface$OnClickListener;", "Landroid/content/DialogInterface$OnDismissListener;", "callback", "Lcom/facebook/react/bridge/Callback;", "<init>", "(Lcom/facebook/react/modules/dialog/DialogModule;Lcom/facebook/react/bridge/Callback;)V", "callbackConsumed", "", "onClick", "", "dialog", "Landroid/content/DialogInterface;", "which", "", "onDismiss", "ReactAndroid_release"})
    public final class AlertFragmentListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnDismissListener {
        @NotNull
        private final Callback callback;
        private boolean callbackConsumed;

        public AlertFragmentListener(Callback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.callback = callback;
        }

        public void onClick(@NotNull DialogInterface dialog, int which) {
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            if (!this.callbackConsumed && DialogModule.this.getReactApplicationContext().hasActiveReactInstance()) {
                Object[] objectArray = new Object[]{DialogModule.ACTION_BUTTON_CLICKED, which};
                this.callback.invoke(objectArray);
                this.callbackConsumed = true;
            }
        }

        public void onDismiss(@Nullable DialogInterface dialog) {
            if (!this.callbackConsumed && DialogModule.this.getReactApplicationContext().hasActiveReactInstance()) {
                Object[] objectArray = new Object[]{DialogModule.ACTION_DISMISSED};
                this.callback.invoke(objectArray);
                this.callbackConsumed = true;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003R\u0016\u0010\b\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u0016\u0010\n\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/modules/dialog/DialogModule$Companion;", "", "<init>", "()V", "NAME", "", "FRAGMENT_TAG", "getFRAGMENT_TAG$ReactAndroid_release$annotations", "ACTION_BUTTON_CLICKED", "getACTION_BUTTON_CLICKED$ReactAndroid_release$annotations", "ACTION_DISMISSED", "getACTION_DISMISSED$ReactAndroid_release$annotations", "KEY_TITLE", "KEY_MESSAGE", "KEY_BUTTON_POSITIVE", "KEY_BUTTON_NEGATIVE", "KEY_BUTTON_NEUTRAL", "KEY_ITEMS", "KEY_CANCELABLE", "CONSTANTS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getFRAGMENT_TAG$ReactAndroid_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTION_BUTTON_CLICKED$ReactAndroid_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTION_DISMISSED$ReactAndroid_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/modules/dialog/DialogModule$FragmentManagerHelper;", "", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "<init>", "(Lcom/facebook/react/modules/dialog/DialogModule;Landroidx/fragment/app/FragmentManager;)V", "fragmentToShow", "Lcom/facebook/react/modules/dialog/AlertFragment;", "showPendingAlert", "", "dismissExisting", "showNewAlert", "arguments", "Landroid/os/Bundle;", "actionCallback", "Lcom/facebook/react/bridge/Callback;", "ReactAndroid_release"})
    private final class FragmentManagerHelper {
        @NotNull
        private final FragmentManager fragmentManager;
        @Nullable
        private AlertFragment fragmentToShow;

        public FragmentManagerHelper(FragmentManager fragmentManager) {
            Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
            this.fragmentManager = fragmentManager;
        }

        public final void showPendingAlert() {
            UiThreadUtil.assertOnUiThread();
            SoftAssertions.assertCondition(DialogModule.this.isInForeground, "showPendingAlert() called in background");
            AlertFragment alertFragment = this.fragmentToShow;
            if (alertFragment == null) {
                return;
            }
            AlertFragment fragmentToShow = alertFragment;
            this.dismissExisting();
            fragmentToShow.show(this.fragmentManager, DialogModule.FRAGMENT_TAG);
            this.fragmentToShow = null;
        }

        public final void dismissExisting() {
            AlertFragment oldFragment;
            if (!DialogModule.this.isInForeground) {
                return;
            }
            AlertFragment alertFragment = oldFragment = (AlertFragment)this.fragmentManager.findFragmentByTag(DialogModule.FRAGMENT_TAG);
            boolean bl = alertFragment != null ? alertFragment.isResumed() : false;
            if (bl) {
                oldFragment.dismiss();
            }
        }

        public final void showNewAlert(@NotNull Bundle arguments, @Nullable Callback actionCallback) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            UiThreadUtil.assertOnUiThread();
            this.dismissExisting();
            AlertFragmentListener actionListener = actionCallback != null ? new AlertFragmentListener(actionCallback) : null;
            AlertFragment alertFragment = new AlertFragment(actionListener, arguments);
            if (DialogModule.this.isInForeground && !this.fragmentManager.isStateSaved()) {
                if (arguments.containsKey(DialogModule.KEY_CANCELABLE)) {
                    alertFragment.setCancelable(arguments.getBoolean(DialogModule.KEY_CANCELABLE));
                }
                alertFragment.show(this.fragmentManager, DialogModule.FRAGMENT_TAG);
            } else {
                this.fragmentToShow = alertFragment;
            }
        }
    }
}

