/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.fbreact.specs.NativeTimingSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.JSTimers;
import com.facebook.react.modules.core.JavaScriptTimerExecutor;
import com.facebook.react.modules.core.JavaTimerManager;
import com.facebook.react.modules.core.ReactChoreographer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ReactModule(name="Timing")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/react/modules/core/TimingModule;", "Lcom/facebook/fbreact/specs/NativeTimingSpec;", "Lcom/facebook/react/modules/core/JavaScriptTimerExecutor;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/devsupport/interfaces/DevSupportManager;)V", "javaTimerManager", "Lcom/facebook/react/modules/core/JavaTimerManager;", "createTimer", "", "callbackIDDouble", "", "durationDouble", "jsSchedulingTime", "repeat", "", "deleteTimer", "timerIdDouble", "setSendIdleEvents", "sendIdleEvents", "callTimers", "timerIDs", "Lcom/facebook/react/bridge/WritableArray;", "callIdleCallbacks", "frameTime", "emitTimeDriftWarning", "warningMessage", "", "invalidate", "hasActiveTimersInRange", "rangeMs", "", "Companion", "ReactAndroid_release"})
public final class TimingModule
extends NativeTimingSpec
implements JavaScriptTimerExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaTimerManager javaTimerManager;
    @NotNull
    public static final String NAME = "Timing";

    public TimingModule(@NotNull ReactApplicationContext reactContext, @NotNull DevSupportManager devSupportManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)devSupportManager, (String)"devSupportManager");
        super(reactContext);
        this.javaTimerManager = new JavaTimerManager(reactContext, this, ReactChoreographer.Companion.getInstance(), devSupportManager);
    }

    @Override
    public void createTimer(double callbackIDDouble, double durationDouble, double jsSchedulingTime, boolean repeat) {
        int callbackID = (int)callbackIDDouble;
        int duration = (int)durationDouble;
        this.javaTimerManager.createAndMaybeCallTimer(callbackID, duration, jsSchedulingTime, repeat);
    }

    @Override
    public void deleteTimer(double timerIdDouble) {
        int timerId = (int)timerIdDouble;
        this.javaTimerManager.deleteTimer(timerId);
    }

    @Override
    public void setSendIdleEvents(boolean sendIdleEvents) {
        this.javaTimerManager.setSendIdleEvents(sendIdleEvents);
    }

    @Override
    public void callTimers(@NotNull WritableArray timerIDs) {
        block0: {
            JSTimers jSTimers;
            Intrinsics.checkNotNullParameter((Object)timerIDs, (String)"timerIDs");
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext == null || (jSTimers = reactApplicationContext.getJSModule(JSTimers.class)) == null) break block0;
            jSTimers.callTimers(timerIDs);
        }
    }

    @Override
    public void callIdleCallbacks(double frameTime) {
        block0: {
            JSTimers jSTimers;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext == null || (jSTimers = reactApplicationContext.getJSModule(JSTimers.class)) == null) break block0;
            jSTimers.callIdleCallbacks(frameTime);
        }
    }

    @Override
    public void emitTimeDriftWarning(@NotNull String warningMessage) {
        block0: {
            JSTimers jSTimers;
            Intrinsics.checkNotNullParameter((Object)warningMessage, (String)"warningMessage");
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext == null || (jSTimers = reactApplicationContext.getJSModule(JSTimers.class)) == null) break block0;
            jSTimers.emitTimeDriftWarning(warningMessage);
        }
    }

    @Override
    public void invalidate() {
        this.javaTimerManager.onInstanceDestroy();
    }

    @VisibleForTesting
    public final boolean hasActiveTimersInRange(long rangeMs) {
        return this.javaTimerManager.hasActiveTimersInRange$ReactAndroid_release(rangeMs);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/modules/core/TimingModule$Companion;", "", "<init>", "()V", "NAME", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

